/*
 * Decompiled with CFR 0.152.
 */
package io.jarasandha.util.concurrent;

import io.jarasandha.util.concurrent.GuardedSession;
import io.jarasandha.util.test.AbstractTest;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuardedSessionTest
extends AbstractTest {
    private static final Logger log = LoggerFactory.getLogger(GuardedSessionTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasic() throws Exception {
        try {
            new GuardedSession(3, null);
            Assert.fail((String)"Null item is not allowed");
        }
        catch (NullPointerException e) {
            log.debug("Expected", (Throwable)e);
        }
        Integer givenItem = 999999;
        GuardedSession session = new GuardedSession(3, (Object)givenItem);
        for (int i = 0; i < 100; ++i) {
            Assert.assertTrue((boolean)session.access(item -> Assert.assertSame((Object)givenItem, (Object)item)));
        }
        Integer item2 = (Integer)session.borrow();
        if (item2 != null) {
            try {
                Assert.assertSame((Object)givenItem, (Object)item2);
            }
            finally {
                try {
                    session.back((Object)(item2 * 10));
                    Assert.fail((String)"Should've failed because the returned item is not the borrowed item");
                }
                catch (IllegalArgumentException e) {
                    log.debug("Expected", (Throwable)e);
                }
                session.back((Object)item2);
            }
        }
        Assert.fail((String)"Item should not be null");
        Integer discardedItem = (Integer)session.discard();
        Assert.assertSame((Object)givenItem, (Object)discardedItem);
    }

    @Test
    public void testConcurrency() throws Exception {
        int concurrencyLimit = 3;
        Integer givenItem = 999999;
        GuardedSession session = new GuardedSession(3, (Object)givenItem);
        Integer item1 = null;
        Integer item2 = null;
        Integer item3 = null;
        Integer item4 = null;
        item1 = (Integer)session.borrow();
        if (item1 == null) {
            Assert.fail((String)"Item should not be null");
        }
        if ((item2 = (Integer)session.borrow()) == null) {
            Assert.fail((String)"Item should not be null");
        }
        if ((item3 = (Integer)session.borrow()) == null) {
            Assert.fail((String)"Item should not be null");
        }
        item4 = (Integer)session.borrow(100L, TimeUnit.MILLISECONDS);
        Assert.assertNull((String)"Item should not be null", (Object)item4);
        Assert.assertSame((Object)givenItem, (Object)item1);
        Assert.assertSame((Object)givenItem, (Object)item2);
        Assert.assertSame((Object)givenItem, (Object)item3);
        session.back((Object)item1);
        session.back((Object)item2);
        session.back((Object)item3);
        item4 = (Integer)session.borrow();
        if (item4 == null) {
            Assert.fail((String)"Item should not be null");
        }
        Assert.assertSame((Object)givenItem, (Object)item4);
        session.back((Object)item4);
        Integer discardedItem = (Integer)session.discard();
        Assert.assertSame((Object)givenItem, (Object)discardedItem);
        Assert.assertNull((Object)session.discard());
        Assert.assertNull((Object)session.borrow());
    }
}

