/*
 * Decompiled with CFR 0.152.
 */
package io.jarasandha.util.concurrent;

import io.jarasandha.util.concurrent.CancellableTask;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancellableTaskTest {
    private static final Logger log = LoggerFactory.getLogger(CancellableTaskTest.class);

    @Test
    public void testSuccess() {
        AtomicInteger successCalled = new AtomicInteger();
        AtomicReference errorCalled = new AtomicReference();
        CancellableTask task = new CancellableTask(() -> 100, successCalled::set, errorCalled::set);
        task.run();
        Assert.assertEquals((long)100L, (long)successCalled.get());
        Assert.assertNull(errorCalled.get());
        task.cancel();
    }

    @Test(expected=IllegalStateException.class)
    public void testNeverStarted() {
        AtomicInteger successCalled = new AtomicInteger(-2);
        AtomicReference errorCalled = new AtomicReference();
        CancellableTask task = new CancellableTask(() -> 100, successCalled::set, errorCalled::set);
        task.cancel();
        Assert.assertEquals((long)-2L, (long)successCalled.get());
        Assert.assertTrue((boolean)(errorCalled.get() instanceof CancellationException));
        task.run();
    }

    @Test
    public void testInterrupted() throws InterruptedException {
        AtomicInteger successCalled = new AtomicInteger(-2);
        AtomicReference errorCalled = new AtomicReference();
        CountDownLatch taskStartLatch = new CountDownLatch(1);
        CountDownLatch taskEndLatch = new CountDownLatch(1);
        CancellableTask task = new CancellableTask(() -> {
            taskStartLatch.countDown();
            Thread.sleep(Long.MAX_VALUE);
            return 100;
        }, successCalled::set, throwable -> {
            errorCalled.set(throwable);
            taskEndLatch.countDown();
        });
        Thread runnerThread = new Thread((Runnable)task);
        runnerThread.start();
        taskStartLatch.await();
        task.cancel();
        taskEndLatch.await();
        Assert.assertEquals((long)-2L, (long)successCalled.get());
        Assert.assertTrue((boolean)(errorCalled.get() instanceof InterruptedException));
    }
}

