/*
 * Decompiled with CFR 0.152.
 */
package io.github.antoniovizuete.pojospreadsheet.utils.iterator;

import io.github.antoniovizuete.pojospreadsheet.utils.iterator.IntegerIndex;
import io.github.antoniovizuete.pojospreadsheet.utils.iterator.IntegerSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public abstract class AbstractIntegerSet<T extends IntegerIndex>
implements IntegerSet<T> {
    protected Set<T> set = new HashSet<T>();

    @Override
    public T add() {
        return this.add(Math.max(this.set.size(), this.getMaxIndex()) + 1);
    }

    @Override
    public T add(Integer index) {
        return (T)Optional.ofNullable(this.get(index)).orElseGet(() -> {
            Object item = this.createItem(index);
            this.set.add(item);
            return item;
        });
    }

    @Override
    public T get(Integer index) {
        return (T)((IntegerIndex)this.set.stream().filter(item -> item.getIndex().equals(index)).findFirst().orElse(null));
    }

    @Override
    public Integer getMaxIndex() {
        return this.set.stream().map(IntegerIndex::getIndex).max(Comparator.naturalOrder()).orElse(0);
    }
}

