/*
 * Decompiled with CFR 0.152.
 */
package io.github.antoniovizuete.pojospreadsheet.core.image;

import io.github.antoniovizuete.pojospreadsheet.core.image.AbstractImage;
import io.github.antoniovizuete.pojospreadsheet.core.image.Image;
import io.github.antoniovizuete.pojospreadsheet.core.model.CellAddress;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.util.IOUtils;

public final class ImageInputStream
extends AbstractImage
implements Image {
    private String path;

    public ImageInputStream(String path, CellAddress cellAddress) {
        super(cellAddress);
        this.path = path;
    }

    public ImageInputStream(String path, CellAddress cellAddress, Image.ImageType type) {
        super(cellAddress, type);
        this.path = path;
    }

    @Override
    public byte[] getResource() throws IOException {
        return IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream(this.getPath()));
    }

    private String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String toString() {
        return "ImageInputStream['" + this.path + "'@" + this.getCellAddress().toString() + ']';
    }
}

