/*
 * Decompiled with CFR 0.152.
 */
package io.github.antoniovizuete.pojospreadsheet.core.converter;

import io.github.antoniovizuete.pojospreadsheet.core.SpreadsheetDecoration;
import io.github.antoniovizuete.pojospreadsheet.core.converter.ConverterCellDecoration;
import io.github.antoniovizuete.pojospreadsheet.core.converter.PoiConverter;
import io.github.antoniovizuete.pojospreadsheet.core.decoration.defaults.DefaultFont;
import io.github.antoniovizuete.pojospreadsheet.core.model.Border;
import io.github.antoniovizuete.pojospreadsheet.core.model.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

class ConverterCellStyle
implements PoiConverter<XSSFCellStyle, CellStyle> {
    private ConverterCellDecoration decorConverter;
    private SpreadsheetDecoration decoration;

    public ConverterCellStyle(ConverterCellDecoration decorConverter, SpreadsheetDecoration decoration) {
        this.decorConverter = decorConverter;
        this.decoration = decoration;
    }

    @Override
    public XSSFCellStyle getPoiValue(XSSFWorkbook xssfWorkbook, CellStyle cellStyle) {
        Border border;
        XSSFCellStyle xssfCellStyle = xssfWorkbook.createCellStyle();
        if (cellStyle.getBackgroundColor() != null) {
            xssfCellStyle.setFillForegroundColor(this.decorConverter.getXSSFColor(cellStyle.getBackgroundColor()));
            xssfCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        if (cellStyle.getFont() != null) {
            xssfCellStyle.setFont((Font)this.decorConverter.getXSSFFont(cellStyle.getFont()));
        } else {
            xssfCellStyle.setFont((Font)this.decorConverter.getXSSFFont(DefaultFont.DEFAULT_FONT));
        }
        if (cellStyle.getAlign() != null) {
            xssfCellStyle.setAlignment(cellStyle.getAlign());
        }
        if (cellStyle.getVerticalAlign() != null) {
            xssfCellStyle.setVerticalAlignment(cellStyle.getVerticalAlign());
        }
        if (cellStyle.getBorderTop() != null) {
            border = this.decoration.get(cellStyle.getBorderTop());
            xssfCellStyle.setBorderTop(border.getBorderStyle());
            if (border.getColor() != null) {
                xssfCellStyle.setTopBorderColor(this.decorConverter.getXSSFColor(border.getColor()));
            }
        }
        if (cellStyle.getBorderRight() != null) {
            border = this.decoration.get(cellStyle.getBorderRight());
            xssfCellStyle.setBorderRight(border.getBorderStyle());
            if (border.getColor() != null) {
                xssfCellStyle.setRightBorderColor(this.decorConverter.getXSSFColor(border.getColor()));
            }
        }
        if (cellStyle.getBorderBottom() != null) {
            border = this.decoration.get(cellStyle.getBorderBottom());
            xssfCellStyle.setBorderBottom(border.getBorderStyle());
            if (border.getColor() != null) {
                xssfCellStyle.setBottomBorderColor(this.decorConverter.getXSSFColor(border.getColor()));
            }
        }
        if (cellStyle.getBorderLeft() != null) {
            border = this.decoration.get(cellStyle.getBorderLeft());
            xssfCellStyle.setBorderLeft(border.getBorderStyle());
            if (border.getColor() != null) {
                xssfCellStyle.setLeftBorderColor(this.decorConverter.getXSSFColor(border.getColor()));
            }
        }
        if (cellStyle.getFormat() != null) {
            short iFormat = xssfWorkbook.getCreationHelper().createDataFormat().getFormat(this.decoration.get(cellStyle.getFormat()).getValue());
            xssfCellStyle.setDataFormat((int)iFormat);
        }
        return xssfCellStyle;
    }
}

