/*
 * Decompiled with CFR 0.152.
 */
package io.github.antoniovizuete.pojospreadsheet.core;

import io.github.antoniovizuete.pojospreadsheet.core.AbstractSpreadsheet;
import io.github.antoniovizuete.pojospreadsheet.core.SpreadsheetFactory;
import io.github.antoniovizuete.pojospreadsheet.core.model.Row;
import io.github.antoniovizuete.pojospreadsheet.core.model.Sheet;
import io.github.antoniovizuete.pojospreadsheet.core.model.Spreadsheet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

class Reader {
    Reader() {
    }

    Spreadsheet readWorkbook(String path) {
        File file = new File(path);
        if (!file.exists()) {
            throw new IllegalStateException("File \"" + path + "\" doesn't exist.");
        }
        Spreadsheet spreadsheet = SpreadsheetFactory.createFileSpreadsheet(file.getAbsolutePath(), file.getName());
        try (FileInputStream fis = new FileInputStream(file);
             Workbook workbook = WorkbookFactory.create((InputStream)fis);){
            workbook.sheetIterator().forEachRemaining(poiSheet -> {
                Sheet sheet = spreadsheet.newSheet().name(poiSheet.getSheetName());
                poiSheet.iterator().forEachRemaining(poiRow -> {
                    Row row = sheet.row(poiRow.getRowNum() + 1);
                    poiRow.iterator().forEachRemaining(poiCell -> {
                        Object value = this.getProperValue((Cell)poiCell);
                        row.cell(poiCell.getColumnIndex() + 1).value(value);
                    });
                });
            });
            ((AbstractSpreadsheet)spreadsheet).setFromReader(true);
        }
        catch (IOException | EncryptedDocumentException | InvalidFormatException e) {
            throw new IllegalStateException(e);
        }
        return spreadsheet;
    }

    private Object getProperValue(Cell poiCell) {
        Object value;
        switch (poiCell.getCellTypeEnum()) {
            case STRING: {
                value = poiCell.getStringCellValue();
                break;
            }
            case NUMERIC: {
                value = this.getDateOrNumeric(poiCell);
                break;
            }
            case FORMULA: {
                value = this.getFormulaValue(poiCell);
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    private Object getFormulaValue(Cell cell) {
        Object value = null;
        switch (cell.getCachedFormulaResultTypeEnum()) {
            case NUMERIC: {
                value = this.getDateOrNumeric(cell);
                break;
            }
            case STRING: {
                value = cell.getStringCellValue();
                break;
            }
        }
        return value;
    }

    private Object getDateOrNumeric(Cell cell) {
        Comparable<Date> value = DateUtil.isCellDateFormatted((Cell)cell) ? DateUtil.getJavaDate((double)cell.getNumericCellValue()) : Double.valueOf(cell.getNumericCellValue());
        return value;
    }
}

