/*
 * Decompiled with CFR 0.152.
 */
package io.github.antoniovizuete.pojospreadsheet.core;

import io.github.antoniovizuete.pojospreadsheet.core.AbstractWriter;
import io.github.antoniovizuete.pojospreadsheet.core.Reader;
import io.github.antoniovizuete.pojospreadsheet.core.SheetImpl;
import io.github.antoniovizuete.pojospreadsheet.core.SpreadsheetDecoration;
import io.github.antoniovizuete.pojospreadsheet.core.model.Sheet;
import io.github.antoniovizuete.pojospreadsheet.core.model.Spreadsheet;
import io.github.antoniovizuete.pojospreadsheet.core.model.SpreadsheetWriter;
import io.github.antoniovizuete.pojospreadsheet.utils.iterator.AbstractIntegerSet;
import java.io.OutputStream;
import java.util.Set;

public class AbstractSpreadsheet
extends AbstractIntegerSet<Sheet>
implements Spreadsheet {
    private SpreadsheetWriter writer;
    private SpreadsheetDecoration decoration = new SpreadsheetDecoration();
    private Boolean fromReader = false;

    protected AbstractSpreadsheet(SpreadsheetWriter writer) {
        this.writer = writer;
    }

    @Override
    public Set<Sheet> sheets() {
        return this.set;
    }

    @Override
    public Sheet createItem(Integer index) {
        return new SheetImpl(index);
    }

    public Boolean isFromReader() {
        return this.fromReader;
    }

    public void setFromReader(Boolean fromReader) {
        this.fromReader = fromReader;
    }

    public Sheet addSheet() {
        return (Sheet)super.add();
    }

    public Sheet addSheet(Integer index) {
        return (Sheet)super.add(index);
    }

    @Override
    public Sheet newSheet() {
        return this.addSheet();
    }

    @Override
    public SpreadsheetDecoration getDecoration() {
        return this.decoration;
    }

    @Override
    public byte[] write() {
        return ((AbstractWriter)this.writer).writeSpreadsheet(this, this.decoration);
    }

    @Override
    public OutputStream performWrite() {
        return ((AbstractWriter)this.writer).writeSpreadsheet(this);
    }

    public static Spreadsheet read(String path) {
        return new Reader().readWorkbook(path);
    }
}

