/*
 * Decompiled with CFR 0.152.
 */
package io.github.anderscheow.library.paging;

import android.arch.lifecycle.LiveData;
import android.arch.paging.PagedList;
import android.support.annotation.MainThread;
import io.github.anderscheow.library.constant.NetworkState;
import io.github.anderscheow.library.paging.BoundaryCallback;
import io.github.anderscheow.library.paging.PagingModel;
import io.github.anderscheow.library.utils.PagingRequestHelper;
import io.github.anderscheow.library.utils.PagingRequestHelperExtKt;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B)\u0012\u001a\u0010\u0004\u001a\u0016\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001e\u0010!\u001a\u00020\u00072\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u001f\u001a\u00020 H\u0002J>\u0010#\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010$\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00070\u0005H&J@\u0010&\u001a\u00020\u00072\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\u0018\u0010$\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00070\u0005H&J\u0015\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00028\u0000H\u0017\u00a2\u0006\u0002\u0010)J\u0015\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010)J\b\u0010,\u001a\u00020\u0007H\u0017J\u0006\u0010-\u001a\u00020\u0007J\u001e\u0010.\u001a\u00020\u00072\f\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0004\u001a\u0016\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/github/anderscheow/library/paging/BoundaryCallback;", "T", "Lio/github/anderscheow/library/paging/PagingModel;", "Landroid/arch/paging/PagedList$BoundaryCallback;", "handleResponse", "Lkotlin/Function1;", "", "", "executor", "Ljava/util/concurrent/Executor;", "(Lkotlin/jvm/functions/Function1;Ljava/util/concurrent/Executor;)V", "hasNext", "", "getHasNext", "()Z", "setHasNext", "(Z)V", "helper", "Lio/github/anderscheow/library/utils/PagingRequestHelper;", "getHelper", "()Lio/github/anderscheow/library/utils/PagingRequestHelper;", "networkState", "Landroid/arch/lifecycle/LiveData;", "Lio/github/anderscheow/library/constant/NetworkState;", "getNetworkState", "()Landroid/arch/lifecycle/LiveData;", "pageNumber", "", "failedCallback", "errorMessage", "", "callback", "Lio/github/anderscheow/library/utils/PagingRequestHelper$Request$Callback;", "insertItemsIntoDb", "response", "loadAfter", "success", "failed", "loadInitial", "onItemAtEndLoaded", "itemAtEnd", "(Lio/github/anderscheow/library/paging/PagingModel;)V", "onItemAtFrontLoaded", "itemAtFront", "onZeroItemsLoaded", "refresh", "successCallback", "items", "library_release"})
public abstract class BoundaryCallback<T extends PagingModel>
extends PagedList.BoundaryCallback<T> {
    @NotNull
    private final PagingRequestHelper helper;
    @NotNull
    private final LiveData<NetworkState> networkState;
    private int pageNumber;
    private boolean hasNext;
    private final Function1<List<? extends T>, Unit> handleResponse;
    private final Executor executor;

    @NotNull
    public final PagingRequestHelper getHelper() {
        return this.helper;
    }

    @NotNull
    public final LiveData<NetworkState> getNetworkState() {
        return this.networkState;
    }

    protected final boolean getHasNext() {
        return this.hasNext;
    }

    protected final void setHasNext(boolean bl) {
        this.hasNext = bl;
    }

    public abstract void loadInitial(int var1, @NotNull Function1<? super List<? extends T>, Unit> var2, @NotNull Function1<? super String, Unit> var3);

    public static /* bridge */ /* synthetic */ void loadInitial$default(BoundaryCallback boundaryCallback, int n, Function1 function1, Function1 function12, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadInitial");
        }
        if ((n2 & 1) != 0) {
            n = 1;
        }
        boundaryCallback.loadInitial(n, function1, (Function1<String, Unit>)function12);
    }

    public abstract void loadAfter(int var1, @NotNull Function1<? super List<? extends T>, Unit> var2, @NotNull Function1<? super String, Unit> var3);

    public final void refresh() {
        this.pageNumber = 1;
        this.hasNext = true;
        this.onZeroItemsLoaded();
    }

    @MainThread
    public void onZeroItemsLoaded() {
        this.helper.runIfNotRunning(PagingRequestHelper.RequestType.INITIAL, new PagingRequestHelper.Request(this){
            final /* synthetic */ BoundaryCallback this$0;

            public final void run(PagingRequestHelper.Request.Callback callback) {
                this.this$0.loadInitial(BoundaryCallback.access$getPageNumber$p(this.this$0), (Function1)new Function1<List<? extends T>, Unit>(this, callback){
                    final /* synthetic */ onZeroItemsLoaded.1 this$0;
                    final /* synthetic */ PagingRequestHelper.Request.Callback $callback;

                    public final void invoke(@NotNull List<? extends T> items) {
                        Intrinsics.checkParameterIsNotNull(items, (String)"items");
                        BoundaryCallback boundaryCallback = this.this$0.this$0;
                        PagingRequestHelper.Request.Callback callback = this.$callback;
                        Intrinsics.checkExpressionValueIsNotNull((Object)callback, (String)"callback");
                        BoundaryCallback.access$successCallback(boundaryCallback, items, callback);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$callback = callback;
                        super(1);
                    }
                }, (Function1<String, Unit>)((Function1)new Function1<String, Unit>(this, callback){
                    final /* synthetic */ onZeroItemsLoaded.1 this$0;
                    final /* synthetic */ PagingRequestHelper.Request.Callback $callback;

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        BoundaryCallback boundaryCallback = this.this$0.this$0;
                        PagingRequestHelper.Request.Callback callback = this.$callback;
                        Intrinsics.checkExpressionValueIsNotNull((Object)callback, (String)"callback");
                        BoundaryCallback.access$failedCallback(boundaryCallback, it, callback);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$callback = callback;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = boundaryCallback;
            }
        });
    }

    @MainThread
    public void onItemAtEndLoaded(@NotNull T itemAtEnd) {
        Intrinsics.checkParameterIsNotNull(itemAtEnd, (String)"itemAtEnd");
        this.helper.runIfNotRunning(PagingRequestHelper.RequestType.AFTER, new PagingRequestHelper.Request(this){
            final /* synthetic */ BoundaryCallback this$0;

            public final void run(PagingRequestHelper.Request.Callback callback) {
                if (this.this$0.getHasNext()) {
                    this.this$0.loadAfter(BoundaryCallback.access$getPageNumber$p(this.this$0), (Function1)new Function1<List<? extends T>, Unit>(this, callback){
                        final /* synthetic */ onItemAtEndLoaded.1 this$0;
                        final /* synthetic */ PagingRequestHelper.Request.Callback $callback;

                        public final void invoke(@NotNull List<? extends T> items) {
                            Intrinsics.checkParameterIsNotNull(items, (String)"items");
                            BoundaryCallback boundaryCallback = this.this$0.this$0;
                            PagingRequestHelper.Request.Callback callback = this.$callback;
                            Intrinsics.checkExpressionValueIsNotNull((Object)callback, (String)"callback");
                            BoundaryCallback.access$successCallback(boundaryCallback, items, callback);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$callback = callback;
                            super(1);
                        }
                    }, (Function1<String, Unit>)((Function1)new Function1<String, Unit>(this, callback){
                        final /* synthetic */ onItemAtEndLoaded.1 this$0;
                        final /* synthetic */ PagingRequestHelper.Request.Callback $callback;

                        public final void invoke(@NotNull String it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            BoundaryCallback boundaryCallback = this.this$0.this$0;
                            PagingRequestHelper.Request.Callback callback = this.$callback;
                            Intrinsics.checkExpressionValueIsNotNull((Object)callback, (String)"callback");
                            BoundaryCallback.access$failedCallback(boundaryCallback, it, callback);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$callback = callback;
                            super(1);
                        }
                    }));
                } else {
                    List list = CollectionsKt.emptyList();
                    PagingRequestHelper.Request.Callback callback2 = callback;
                    Intrinsics.checkExpressionValueIsNotNull((Object)callback2, (String)"callback");
                    BoundaryCallback.access$successCallback(this.this$0, list, callback2);
                }
            }
            {
                this.this$0 = boundaryCallback;
            }
        });
    }

    public void onItemAtFrontLoaded(@NotNull T itemAtFront) {
        Intrinsics.checkParameterIsNotNull(itemAtFront, (String)"itemAtFront");
    }

    private final void successCallback(List<? extends T> items, PagingRequestHelper.Request.Callback callback) {
        this.insertItemsIntoDb(items, callback);
    }

    private final void failedCallback(String errorMessage, PagingRequestHelper.Request.Callback callback) {
        callback.recordFailure(errorMessage);
    }

    private final void insertItemsIntoDb(List<? extends T> response, PagingRequestHelper.Request.Callback callback) {
        this.executor.execute(new Runnable(this, response, callback){
            final /* synthetic */ BoundaryCallback this$0;
            final /* synthetic */ List $response;
            final /* synthetic */ PagingRequestHelper.Request.Callback $callback;

            public final void run() {
                BoundaryCallback.access$getHandleResponse$p(this.this$0).invoke((Object)this.$response);
                this.$callback.recordSuccess();
                BoundaryCallback boundaryCallback = this.this$0;
                BoundaryCallback.access$setPageNumber$p(boundaryCallback, BoundaryCallback.access$getPageNumber$p(boundaryCallback) + 1);
            }
            {
                this.this$0 = boundaryCallback;
                this.$response = list;
                this.$callback = callback;
            }
        });
    }

    public BoundaryCallback(@NotNull Function1<? super List<? extends T>, Unit> handleResponse, @NotNull Executor executor) {
        Intrinsics.checkParameterIsNotNull(handleResponse, (String)"handleResponse");
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        this.handleResponse = handleResponse;
        this.executor = executor;
        this.helper = new PagingRequestHelper(this.executor);
        this.networkState = PagingRequestHelperExtKt.createStatusLiveData(this.helper);
        this.pageNumber = 1;
        this.hasNext = true;
    }

    public static final /* synthetic */ int access$getPageNumber$p(BoundaryCallback $this) {
        return $this.pageNumber;
    }

    public static final /* synthetic */ void access$setPageNumber$p(BoundaryCallback $this, int n) {
        $this.pageNumber = n;
    }

    public static final /* synthetic */ void access$successCallback(BoundaryCallback $this, @NotNull List items, @NotNull PagingRequestHelper.Request.Callback callback) {
        $this.successCallback(items, callback);
    }

    public static final /* synthetic */ void access$failedCallback(BoundaryCallback $this, @NotNull String errorMessage, @NotNull PagingRequestHelper.Request.Callback callback) {
        $this.failedCallback(errorMessage, callback);
    }

    @NotNull
    public static final /* synthetic */ Function1 access$getHandleResponse$p(BoundaryCallback $this) {
        return $this.handleResponse;
    }
}

