/*
 * Decompiled with CFR 0.152.
 */
package io.github.anderscheow.library.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.AppCompatSeekBar;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import io.github.anderscheow.library.R;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0002&'B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0015J(\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0014J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020\u000fJ\u000e\u0010 \u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\fH\u0016J\u0010\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lio/github/anderscheow/library/views/SlideButton;", "Landroid/support/v7/widget/AppCompatSeekBar;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "listener", "Lio/github/anderscheow/library/views/SlideButton$SlideButtonListener;", "mThumb", "Landroid/graphics/drawable/Drawable;", "orientation", "handleSlide", "", "onDraw", "c", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onSizeChanged", "w", "h", "oldw", "oldh", "onTouchEvent", "", "event", "Landroid/view/MotionEvent;", "resetProgress", "setSlideButtonListener", "setThumb", "thumb", "showProgress", "progress", "", "Companion", "SlideButtonListener", "library_release"})
public final class SlideButton
extends AppCompatSeekBar {
    private Drawable mThumb;
    private SlideButtonListener listener;
    private final int orientation;
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.orientation == 1) {
            super.onMeasure(heightMeasureSpec, widthMeasureSpec);
            this.setMeasuredDimension(this.getMeasuredHeight(), this.getMeasuredWidth());
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    protected void onDraw(@NotNull Canvas c) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        if (this.orientation == 1) {
            c.rotate(90.0f);
            c.translate(0.0f, (float)(-this.getWidth()));
        }
        super.onDraw(c);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.orientation == 1) {
            super.onSizeChanged(h, w, oldh, oldw);
        } else {
            super.onSizeChanged(w, h, oldw, oldh);
        }
    }

    public void setThumb(@NotNull Drawable thumb) {
        Intrinsics.checkParameterIsNotNull((Object)thumb, (String)"thumb");
        super.setThumb(thumb);
        this.mThumb = thumb;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return false;
        }
        if (this.orientation == 0) {
            if (event.getAction() == 0) {
                Drawable drawable = this.mThumb;
                if (drawable == null) {
                    Intrinsics.throwNpe();
                }
                if (!drawable.getBounds().contains((int)event.getX(), (int)event.getY())) return false;
                super.onTouchEvent(event);
            } else if (event.getAction() == 1) {
                int n;
                if (this.getProgress() > 90) {
                    this.handleSlide();
                    n = 100;
                } else {
                    n = 0;
                }
                this.setProgress(n);
            } else {
                super.onTouchEvent(event);
            }
            this.showProgress(this.getProgress());
            return true;
        } else {
            switch (event.getAction()) {
                case 0: {
                    if (event.getAction() == 0) {
                        Drawable drawable = this.mThumb;
                        if (drawable == null) {
                            Intrinsics.throwNpe();
                        }
                        if (!drawable.getBounds().contains((int)event.getY(), (int)event.getX())) {
                            return false;
                        }
                    }
                    int i = this.getMax() - (int)((float)this.getMax() * event.getY() / (float)this.getHeight());
                    this.setProgress(100 - i);
                    this.onSizeChanged(this.getWidth(), this.getHeight(), 0, 0);
                    this.showProgress(this.getProgress());
                    return true;
                }
                case 2: {
                    int i = this.getMax() - (int)((float)this.getMax() * event.getY() / (float)this.getHeight());
                    this.setProgress(100 - i);
                    this.onSizeChanged(this.getWidth(), this.getHeight(), 0, 0);
                    this.showProgress(this.getProgress());
                    return true;
                }
                case 1: {
                    int i = this.getMax() - (int)((float)this.getMax() * event.getY() / (float)this.getHeight());
                    if (i < 30) {
                        this.handleSlide();
                    }
                    this.setProgress(0);
                    this.onSizeChanged(this.getWidth(), this.getHeight(), 0, 0);
                }
            }
        }
        return true;
    }

    public final void resetProgress() {
        this.setProgress(0);
        this.showProgress(0.0);
    }

    private final void handleSlide() {
        block0: {
            SlideButtonListener slideButtonListener = this.listener;
            if (slideButtonListener == null) break block0;
            slideButtonListener.handleSlide();
        }
    }

    private final void showProgress(double progress) {
        block0: {
            SlideButtonListener slideButtonListener = this.listener;
            if (slideButtonListener == null) break block0;
            slideButtonListener.fadeOutText(progress);
        }
    }

    public final void setSlideButtonListener(@NotNull SlideButtonListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listener = listener;
    }

    @JvmOverloads
    public SlideButton(@NotNull Context context, @NotNull AttributeSet attrs, int defStyle) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.slideButton);
        this.orientation = a.getInteger(R.styleable.slideButton_orientation, 0);
        a.recycle();
    }

    @JvmOverloads
    public /* synthetic */ SlideButton(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public SlideButton(@NotNull Context context, @NotNull AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&\u00a8\u0006\u0007"}, d2={"Lio/github/anderscheow/library/views/SlideButton$SlideButtonListener;", "", "fadeOutText", "", "progress", "", "handleSlide", "library_release"})
    public static interface SlideButtonListener {
        public void handleSlide();

        public void fadeOutText(double var1);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/github/anderscheow/library/views/SlideButton$Companion;", "", "()V", "ORIENTATION_HORIZONTAL", "", "ORIENTATION_VERTICAL", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

