/*
 * Decompiled with CFR 0.152.
 */
package io.github.anderscheow.library.services;

import android.app.ProgressDialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.support.annotation.RequiresApi;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.Toast;
import io.github.anderscheow.library.R;
import io.github.anderscheow.library.kotlin.InlineFunctionUtilKt;
import io.github.anderscheow.library.services.ApplicationService;
import io.github.anderscheow.library.services.ApplicationServiceReadyCallback;
import io.github.anderscheow.library.services.ApplicationServiceScheduler;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0007H\u0005J\b\u0010\u0016\u001a\u00020\u0007H\u0005J\b\u0010\u0017\u001a\u00020\u0007H\u0005J\u0006\u0010\u0018\u001a\u00020\u0019J\u0012\u0010\u001a\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u0019H\u0014J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0014\u0010$\u001a\u00020\u00192\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\nJ\b\u0010&\u001a\u00020\u0007H\u0005J\u000e\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)J\b\u0010*\u001a\u00020\u0019H&J\u000e\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020)J\u000e\u0010+\u001a\u00020\u00192\u0006\u0010(\u001a\u00020-J\u0006\u0010.\u001a\u00020\u0019R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/github/anderscheow/library/services/ServiceBoundAppCompatActivity;", "T", "Lio/github/anderscheow/library/services/ApplicationService;", "Landroid/support/v7/app/AppCompatActivity;", "Landroid/content/ServiceConnection;", "()V", "bound", "", "callbackQueue", "Ljava/util/Queue;", "Lio/github/anderscheow/library/services/ApplicationServiceReadyCallback;", "isConnectedToInternet", "()Z", "progressDialog", "Landroid/app/ProgressDialog;", "getProgressDialog", "()Landroid/app/ProgressDialog;", "setProgressDialog", "(Landroid/app/ProgressDialog;)V", "scheduler", "Lio/github/anderscheow/library/services/ApplicationServiceScheduler;", "canAccessCamera", "canAccessLocation", "canAccessStorage", "dismissProgressDialog", "", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onServiceConnected", "name", "Landroid/content/ComponentName;", "service", "Landroid/os/IBinder;", "onServiceDisconnected", "scheduleForService", "callback", "shouldShowLocationPermissionRationalDialog", "showProgressDialog", "message", "", "startService", "toast", "resourceID", "", "toastInternetRequired", "UiThreadCallback", "library_release"})
public abstract class ServiceBoundAppCompatActivity<T extends ApplicationService>
extends AppCompatActivity
implements ServiceConnection {
    private ApplicationServiceScheduler scheduler;
    private boolean bound;
    private Queue<ApplicationServiceReadyCallback<T>> callbackQueue;
    @Nullable
    private ProgressDialog progressDialog;
    private HashMap _$_findViewCache;

    @Nullable
    public final ProgressDialog getProgressDialog() {
        return this.progressDialog;
    }

    public final void setProgressDialog(@Nullable ProgressDialog progressDialog) {
        this.progressDialog = progressDialog;
    }

    public final synchronized boolean isConnectedToInternet() {
        Context context = this.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
        return InlineFunctionUtilKt.isConnectedToInternet(context);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.callbackQueue = new LinkedList();
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.bound) {
            this.unbindService(this);
        }
    }

    public void onServiceConnected(@NotNull ComponentName name, @NotNull IBinder service) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
        ApplicationService.ApplicationContextServiceBinder binder = (ApplicationService.ApplicationContextServiceBinder)service;
        this.scheduler = binder.getScheduler();
        this.bound = true;
        Queue<ApplicationServiceReadyCallback<T>> queue = this.callbackQueue;
        if (queue != null) {
            Queue<ApplicationServiceReadyCallback<T>> queue2;
            Queue<ApplicationServiceReadyCallback<T>> it = queue2 = queue;
            while (!it.isEmpty()) {
                ApplicationServiceScheduler applicationServiceScheduler = this.scheduler;
                if (applicationServiceScheduler != null) {
                    applicationServiceScheduler.scheduleForService(it.remove());
                }
            }
        }
    }

    public void onServiceDisconnected(@NotNull ComponentName name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.scheduler = null;
        this.bound = false;
    }

    public final void scheduleForService(@NotNull ApplicationServiceReadyCallback<T> callback) {
        block2: {
            UiThreadCallback threadedCallback;
            block1: {
                Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
                threadedCallback = new UiThreadCallback(callback);
                if (this.bound) break block1;
                Queue<ApplicationServiceReadyCallback<T>> queue = this.callbackQueue;
                if (queue != null) {
                    queue.add(threadedCallback);
                }
                this.startService(ApplicationService.newIntent((Context)this));
                break block2;
            }
            ApplicationServiceScheduler applicationServiceScheduler = this.scheduler;
            if (applicationServiceScheduler == null) break block2;
            applicationServiceScheduler.scheduleForService(threadedCallback);
        }
    }

    @RequiresApi(api=23)
    protected final boolean canAccessCamera() {
        return this.checkSelfPermission("android.permission.CAMERA") == 0;
    }

    @RequiresApi(api=23)
    protected final boolean canAccessStorage() {
        return this.checkSelfPermission("android.permission.READ_EXTERNAL_STORAGE") == 0;
    }

    @RequiresApi(api=23)
    protected final boolean canAccessLocation() {
        return this.checkSelfPermission("android.permission.ACCESS_COARSE_LOCATION") == 0 && this.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") == 0;
    }

    @RequiresApi(api=23)
    protected final boolean shouldShowLocationPermissionRationalDialog() {
        return this.shouldShowRequestPermissionRationale("android.permission.ACCESS_COARSE_LOCATION") && this.shouldShowRequestPermissionRationale("android.permission.ACCESS_FINE_LOCATION");
    }

    public final void showProgressDialog(int message) {
        block5: {
            if (this.progressDialog == null) {
                this.progressDialog = new ProgressDialog((Context)this);
            }
            ProgressDialog progressDialog = this.progressDialog;
            if (progressDialog != null) {
                progressDialog.setMessage((CharSequence)(message == 0 ? this.getString(R.string.prompt_please_wait) : this.getString(message)));
            }
            ProgressDialog progressDialog2 = this.progressDialog;
            if (progressDialog2 != null) {
                progressDialog2.setCanceledOnTouchOutside(false);
            }
            ProgressDialog progressDialog3 = this.progressDialog;
            if (progressDialog3 != null) {
                progressDialog3.setCancelable(false);
            }
            ProgressDialog progressDialog4 = this.progressDialog;
            if (progressDialog4 != null) {
                progressDialog4.setIndeterminate(true);
            }
            ProgressDialog progressDialog5 = this.progressDialog;
            if (progressDialog5 == null) break block5;
            progressDialog5.show();
        }
    }

    public final void dismissProgressDialog() {
        block0: {
            ProgressDialog progressDialog = this.progressDialog;
            if (progressDialog == null) break block0;
            progressDialog.dismiss();
        }
    }

    public final void toast(int resourceID) {
        Toast.makeText((Context)((Context)this), (int)resourceID, (int)0).show();
    }

    public final void toast(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Toast.makeText((Context)((Context)this), (CharSequence)message, (int)1).show();
    }

    public final void toastInternetRequired() {
        Toast.makeText((Context)((Context)this), (CharSequence)this.getString(R.string.prompt_internet_required), (int)1).show();
    }

    public abstract void startService();

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u00012\u00020\u0002B\u0015\b\u0000\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lio/github/anderscheow/library/services/ServiceBoundAppCompatActivity$UiThreadCallback;", "Lio/github/anderscheow/library/services/ApplicationServiceReadyCallback;", "Ljava/lang/Runnable;", "callback", "(Lio/github/anderscheow/library/services/ServiceBoundAppCompatActivity;Lio/github/anderscheow/library/services/ApplicationServiceReadyCallback;)V", "service", "Lio/github/anderscheow/library/services/ApplicationService;", "onServiceReady", "", "(Lio/github/anderscheow/library/services/ApplicationService;)V", "run", "library_release"})
    private final class UiThreadCallback
    implements ApplicationServiceReadyCallback<T>,
    Runnable {
        private T service;
        private final ApplicationServiceReadyCallback<T> callback;

        @Override
        public void onServiceReady(@NotNull T service) {
            Intrinsics.checkParameterIsNotNull(service, (String)"service");
            this.service = service;
            ServiceBoundAppCompatActivity.this.runOnUiThread(this);
        }

        @Override
        public void run() {
            this.callback.onServiceReady(this.service);
        }

        public UiThreadCallback(ApplicationServiceReadyCallback<T> callback) {
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.callback = callback;
        }
    }
}

