/*
 * Decompiled with CFR 0.152.
 */
package io.github.anderscheow.library.services;

import android.app.ProgressDialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.support.annotation.RequiresApi;
import android.support.v7.app.AppCompatActivity;
import android.widget.Toast;
import io.github.anderscheow.library.R;
import io.github.anderscheow.library.services.ApplicationService;
import io.github.anderscheow.library.services.ApplicationServiceReadyCallback;
import io.github.anderscheow.library.services.ApplicationServiceScheduler;
import java.util.LinkedList;
import java.util.Queue;

public abstract class ServiceBoundAppCompatActivity<T extends ApplicationService>
extends AppCompatActivity
implements ServiceConnection {
    private ApplicationServiceScheduler scheduler;
    private boolean bound;
    private Queue<ApplicationServiceReadyCallback<T>> callbackQueue;
    ProgressDialog progressDialog;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.callbackQueue = new LinkedList<ApplicationServiceReadyCallback<T>>();
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.bound) {
            this.unbindService(this);
        }
    }

    public void onServiceConnected(ComponentName name, IBinder service) {
        ApplicationService.ApplicationContextServiceBinder binder = (ApplicationService.ApplicationContextServiceBinder)service;
        this.scheduler = binder.getScheduler();
        this.bound = true;
        while (!this.callbackQueue.isEmpty()) {
            this.scheduler.scheduleForService(this.callbackQueue.remove());
        }
    }

    public void onServiceDisconnected(ComponentName name) {
        this.scheduler = null;
        this.bound = false;
    }

    public void scheduleForService(ApplicationServiceReadyCallback<T> callback) {
        UiThreadCallback threadedCallback = new UiThreadCallback(callback);
        if (!this.bound) {
            this.callbackQueue.add(threadedCallback);
            this.startService(ApplicationService.newIntent((Context)this));
        } else {
            this.scheduler.scheduleForService(threadedCallback);
        }
    }

    public synchronized boolean isConnectedToInternet() {
        ConnectivityManager cm = (ConnectivityManager)this.getApplicationContext().getSystemService("connectivity");
        NetworkInfo netInfo = cm != null ? cm.getActiveNetworkInfo() : null;
        return netInfo != null && netInfo.isConnectedOrConnecting() && !netInfo.isRoaming();
    }

    @RequiresApi(api=23)
    protected boolean canAccessCamera() {
        return 0 == this.checkSelfPermission("android.permission.CAMERA");
    }

    @RequiresApi(api=23)
    protected boolean canAccessStorage() {
        return 0 == this.checkSelfPermission("android.permission.READ_EXTERNAL_STORAGE");
    }

    @RequiresApi(api=23)
    protected boolean canAccessLocation() {
        return 0 == this.checkSelfPermission("android.permission.ACCESS_COARSE_LOCATION") && 0 == this.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION");
    }

    @RequiresApi(api=23)
    protected boolean shouldShowLocationPermissionRationalDialog() {
        return this.shouldShowRequestPermissionRationale("android.permission.ACCESS_COARSE_LOCATION") && this.shouldShowRequestPermissionRationale("android.permission.ACCESS_FINE_LOCATION");
    }

    public void showProgressDialog(int message) {
        if (this.progressDialog == null) {
            this.progressDialog = new ProgressDialog((Context)this);
        }
        this.progressDialog.setMessage((CharSequence)(message == 0 ? this.getString(R.string.prompt_please_wait) : this.getString(message)));
        this.progressDialog.setCanceledOnTouchOutside(false);
        this.progressDialog.setCancelable(false);
        this.progressDialog.setIndeterminate(true);
        this.progressDialog.show();
    }

    public void dismissProgressDialog() {
        if (this.progressDialog != null) {
            this.progressDialog.dismiss();
        }
    }

    public void toast(int resourceID) {
        Toast.makeText((Context)this, (int)resourceID, (int)0).show();
    }

    public void toast(String message) {
        Toast.makeText((Context)this, (CharSequence)message, (int)1).show();
    }

    public void toastInternetRequired() {
        Toast.makeText((Context)this, (CharSequence)this.getString(R.string.prompt_internet_required), (int)1).show();
    }

    public abstract void startService();

    private class UiThreadCallback
    implements ApplicationServiceReadyCallback<T>,
    Runnable {
        private ApplicationServiceReadyCallback<T> callback;
        private T service;

        UiThreadCallback(ApplicationServiceReadyCallback<T> callback) {
            this.callback = callback;
        }

        @Override
        public void onServiceReady(T service) {
            this.service = service;
            ServiceBoundAppCompatActivity.this.runOnUiThread(this);
        }

        @Override
        public void run() {
            this.callback.onServiceReady(this.service);
        }
    }
}

