/*
 * Decompiled with CFR 0.152.
 */
package io.github.anderscheow.library.services;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.IBinder;
import io.github.anderscheow.library.services.ApplicationServiceReadyCallback;
import io.github.anderscheow.library.services.ApplicationServiceScheduler;
import java.util.concurrent.Semaphore;

public abstract class ApplicationService
extends Service
implements ApplicationServiceScheduler {
    private final ApplicationContextServiceBinder serviceBinder = new ApplicationContextServiceBinder();
    private final Semaphore semaphore = new Semaphore(0);
    public boolean isSynchronized = false;
    private int runningTasks = 0;

    public static Intent newIntent(Context context) {
        return new Intent(context, ApplicationService.class);
    }

    public IBinder onBind(Intent intent) {
        this.loadResources();
        return this.serviceBinder;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.loadResources();
        return super.onStartCommand(intent, flags, startId);
    }

    public synchronized void loadResources() {
    }

    public synchronized void logout() {
        this.isSynchronized = false;
    }

    public void addWork() {
        ++this.runningTasks;
    }

    public synchronized void workDone() {
        this.semaphore.release();
    }

    public void requestWorkerTo(Runnable runnable) {
        new WorkerAsyncTask();
        WorkerAsyncTask.execute((Runnable)runnable);
    }

    @Override
    public void scheduleForService(ApplicationServiceReadyCallback callback) {
        new ServiceReadyAsyncTask().execute(new ApplicationServiceReadyCallback[]{callback});
    }

    private class WorkerAsyncTask
    extends AsyncTask<Runnable, Void, Void> {
        private WorkerAsyncTask() {
        }

        protected Void doInBackground(Runnable ... params) {
            for (Runnable runnable : params) {
                runnable.run();
            }
            return null;
        }
    }

    private class ServiceReadyAsyncTask
    extends AsyncTask<ApplicationServiceReadyCallback, Void, Void> {
        private ServiceReadyAsyncTask() {
        }

        protected Void doInBackground(ApplicationServiceReadyCallback ... params) {
            try {
                ApplicationService.this.semaphore.acquire(ApplicationService.this.runningTasks);
                ApplicationService.this.runningTasks = 0;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            for (ApplicationServiceReadyCallback handler : params) {
                handler.onServiceReady(ApplicationService.this);
            }
            return null;
        }
    }

    class ApplicationContextServiceBinder
    extends Binder {
        ApplicationContextServiceBinder() {
        }

        ApplicationServiceScheduler getScheduler() {
            return ApplicationService.this;
        }
    }
}

