/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexengrig.gradle.spring.banner.task;

import io.github.alexengrig.gradle.spring.banner.SpringBannerExtension;
import io.github.alexengrig.gradle.spring.banner.figlet.FigletBannerRenderer;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;

public class ShowSpringBannerTask
extends DefaultTask {
    public static final String NAME = "showBanner";
    private final Project project;
    private final SpringBannerExtension extension;
    private final FigletBannerRenderer renderer;

    @Inject
    public ShowSpringBannerTask(Project project, FigletBannerRenderer renderer) {
        this.project = project;
        this.extension = (SpringBannerExtension)project.getExtensions().getByType(SpringBannerExtension.class);
        this.renderer = renderer;
        this.setGroup("spring banner");
        this.setDescription("Displays Spring banner.");
    }

    public static void register(Project project) {
        TaskContainer tasks = project.getTasks();
        FigletBannerRenderer renderer = FigletBannerRenderer.SINGLETON;
        tasks.register(NAME, ShowSpringBannerTask.class, new Object[]{project, renderer});
    }

    @TaskAction
    public void display() {
        String text = this.extension.getTextValue(this.project);
        String caption = this.extension.getCaptionValue();
        String font = this.extension.getFontValue();
        String banner = this.renderer.render(font, text);
        if (caption.isBlank()) {
            System.out.println(banner);
        } else {
            String separator = this.extension.getSeparatorValue();
            System.out.println(banner + separator + caption);
        }
    }
}

