/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexengrig.gradle.spring.banner.task;

import io.github.alexengrig.gradle.spring.banner.SpringBannerExtension;
import io.github.alexengrig.gradle.spring.banner.figlet.FigletBannerRenderer;
import io.github.alexengrig.gradle.spring.banner.figlet.Fonts;
import java.util.StringJoiner;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;

public class ShowAllSpringBannersTask
extends DefaultTask {
    public static final String NAME = "showAllBanners";
    private final Project project;
    private final SpringBannerExtension extension;
    private final FigletBannerRenderer renderer;

    @Inject
    public ShowAllSpringBannersTask(Project project, FigletBannerRenderer renderer) {
        this.project = project;
        this.extension = (SpringBannerExtension)project.getExtensions().getByType(SpringBannerExtension.class);
        this.renderer = renderer;
        this.setGroup("spring banner");
        this.setDescription("Displays all Spring banners.");
    }

    public static void register(Project project) {
        TaskContainer tasks = project.getTasks();
        FigletBannerRenderer renderer = FigletBannerRenderer.SINGLETON;
        tasks.register(NAME, ShowAllSpringBannersTask.class, new Object[]{project, renderer});
    }

    @TaskAction
    public void display() {
        String text = this.extension.getTextValue(this.project);
        String separator = this.extension.getSeparatorValue();
        StringJoiner joiner = new StringJoiner(separator);
        for (String font : Fonts.all()) {
            joiner.add("Font: " + font).add(this.renderer.render(font, text)).add(separator);
        }
        System.out.println(joiner);
    }
}

