/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexengrig.gradle.spring.banner.task;

import io.github.alexengrig.gradle.spring.banner.SpringBannerExtension;
import io.github.alexengrig.gradle.spring.banner.figlet.FigletBannerRenderer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public class GenerateSpringBannerTask
extends DefaultTask {
    public static final String NAME = "generateBanner";
    private static final String FILENAME = "banner.txt";
    private final Project project;
    private final SpringBannerExtension extension;
    private final FigletBannerRenderer renderer;

    @Inject
    public GenerateSpringBannerTask(Project project, FigletBannerRenderer renderer) {
        this.project = project;
        this.extension = (SpringBannerExtension)project.getExtensions().getByType(SpringBannerExtension.class);
        this.renderer = renderer;
        this.setGroup("spring banner");
        this.setDescription("Generates 'banner.txt'.");
    }

    public static void register(Project project) {
        TaskContainer tasks = project.getTasks();
        FigletBannerRenderer renderer = FigletBannerRenderer.SINGLETON;
        TaskProvider generateTask = tasks.register(NAME, GenerateSpringBannerTask.class, new Object[]{project, renderer});
        Task processResourceTask = tasks.getByName(((SourceSet)((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("main")).getProcessResourcesTaskName());
        processResourceTask.finalizedBy(new Object[]{generateTask.get()});
    }

    @TaskAction
    public void generate() {
        Path path = Objects.requireNonNull(((SourceSet)((SourceSetContainer)this.project.getExtensions().getByType(SourceSetContainer.class)).getByName("main")).getOutput().getResourcesDir(), "sourceSets.main.resourcesDir").toPath().resolve(FILENAME);
        String text = this.extension.getTextValue(this.project);
        String font = this.extension.getFontValue();
        String banner = this.renderer.render(font, text);
        String caption = this.extension.getCaptionValue();
        String separator = this.extension.getSeparatorValue();
        String result = caption.isBlank() ? banner : banner + separator + caption;
        try {
            Path dir = path.getParent();
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            Files.write(path, (result + separator).getBytes(), StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

