/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexengrig.gradle.spring.banner.figlet;

import com.github.dtmo.jfiglet.FigFont;
import com.github.dtmo.jfiglet.FigFontResources;
import io.github.alexengrig.gradle.spring.banner.figlet.FontLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class LibraryFontLoader
implements FontLoader {
    private static SortedSet<String> NAMES;
    private final ClassLoader classLoader = FigFontResources.class.getClassLoader();

    LibraryFontLoader() {
    }

    static SortedSet<String> fontNames() {
        if (NAMES == null) {
            Stream<String> stream = Stream.of("banner.flf", "big.flf", "block.flf", "bubble.flf", "digital.flf", "ivrit.flf", "lean.flf", "mini.flf", "mnemonic.flf", "script.flf", "shadow.flf", "slant.flf", "small.flf", "smscript.flf", "smshadow.flf", "smslant.flf", "standard.flf");
            TreeSet names = stream.map(FontLoader::getFontNameByFilename).collect(Collectors.toCollection(TreeSet::new));
            NAMES = Collections.unmodifiableSortedSet(names);
        }
        return NAMES;
    }

    @Override
    public boolean hasFont(String font) {
        return LibraryFontLoader.fontNames().contains(font);
    }

    @Override
    public FigFont loadFont(String font) {
        FigFont figFont;
        block8: {
            String resource = font + ".flf";
            InputStream inputStream = this.classLoader.getResourceAsStream(resource);
            try {
                Objects.requireNonNull(inputStream, () -> "Not found font resource: " + resource);
                figFont = FigFont.loadFigFont((InputStream)inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Exception of loading font resource: " + resource, e);
                }
            }
            inputStream.close();
        }
        return figFont;
    }
}

