/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexengrig.gradle.spring.banner.figlet;

import com.github.dtmo.jfiglet.FigFont;
import com.github.dtmo.jfiglet.FigletRenderer;
import io.github.alexengrig.gradle.spring.banner.figlet.FontLoader;
import io.github.alexengrig.gradle.spring.banner.figlet.LibraryFontLoader;
import io.github.alexengrig.gradle.spring.banner.figlet.LocalFontLoader;
import java.util.Objects;
import java.util.Set;

public final class FigletBannerRenderer {
    public static FigletBannerRenderer SINGLETON = new FigletBannerRenderer();
    private final Set<FontLoader> fontLoaders;

    public FigletBannerRenderer() {
        this(Set.of(new LibraryFontLoader(), new LocalFontLoader()));
    }

    public FigletBannerRenderer(Set<FontLoader> fontLoaders) {
        this.fontLoaders = fontLoaders;
    }

    public String render(String font, String text) {
        Objects.requireNonNull(font, "font");
        Objects.requireNonNull(text, "text");
        for (FontLoader fontLoader : this.fontLoaders) {
            if (!fontLoader.hasFont(font)) continue;
            FigFont figFont = fontLoader.loadFont(font);
            FigletRenderer renderer = new FigletRenderer(figFont);
            return renderer.renderText(text);
        }
        throw new IllegalArgumentException("Unknown font: " + font);
    }
}

