/*
 * Decompiled with CFR 0.152.
 */
package uk.co.certait.htmlexporter.writer.ods;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Element;
import org.odftoolkit.simple.SpreadsheetDocument;
import org.odftoolkit.simple.table.Column;
import org.odftoolkit.simple.table.Table;
import uk.co.certait.htmlexporter.css.StyleMap;
import uk.co.certait.htmlexporter.writer.AbstractExporter;
import uk.co.certait.htmlexporter.writer.ods.OdsTableCellWriter;
import uk.co.certait.htmlexporter.writer.ods.OdsTableRowWriter;
import uk.co.certait.htmlexporter.writer.ods.OdsTableWriter;

public class OdsExporter
extends AbstractExporter {
    @Override
    public void exportHtml(String html, OutputStream out) throws IOException {
        SpreadsheetDocument spreadsheet = null;
        try {
            spreadsheet = SpreadsheetDocument.newSpreadsheetDocument();
            Table table = spreadsheet.getSheetByIndex(0);
            StyleMap styleMapper = this.getStyleMapper(html);
            int startRow = 0;
            boolean firstLoop = true;
            for (Element element : this.getTables(html)) {
                String sheetName;
                if (firstLoop) {
                    sheetName = this.getSheetName(element);
                    if (StringUtils.isNotEmpty((CharSequence)sheetName)) {
                        table.setTableName(sheetName);
                    }
                } else if (this.isNewSheet(element)) {
                    sheetName = this.getSheetName(element);
                    table = StringUtils.isNotEmpty((CharSequence)sheetName) ? spreadsheet.appendSheet(sheetName) : spreadsheet.appendSheet("Sheet " + (spreadsheet.getSheetCount() + 1));
                    startRow = 0;
                    if (spreadsheet.getSheetByIndex(spreadsheet.getSheetCount() - 1).getRowCount() == 0) {
                        spreadsheet.removeSheet(spreadsheet.getSheetCount() - 1);
                    }
                }
                OdsTableWriter writer = new OdsTableWriter(new OdsTableRowWriter(table, new OdsTableCellWriter(table, styleMapper)));
                startRow += writer.writeTable(element, styleMapper, startRow) + 1;
                firstLoop = false;
            }
            for (int i = 0; i < spreadsheet.getSheetCount(); ++i) {
                this.formatSheet(spreadsheet.getSheetByIndex(i));
            }
            spreadsheet.save(out);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    protected void formatSheet(Table sheet) {
        Iterator columns = sheet.getColumnIterator();
        while (columns.hasNext()) {
            ((Column)columns.next()).setUseOptimalWidth(true);
        }
    }
}

