/*
 * Decompiled with CFR 0.152.
 */
package uk.co.certait.htmlexporter.writer.excel;

import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.jsoup.nodes.Element;
import uk.co.certait.htmlexporter.writer.AbstractTableRowWriter;
import uk.co.certait.htmlexporter.writer.TableCellWriter;

public class ExcelTableRowWriter
extends AbstractTableRowWriter {
    private Sheet sheet;

    public ExcelTableRowWriter(Sheet sheet, TableCellWriter cellWriter) {
        super(cellWriter);
        this.sheet = sheet;
    }

    @Override
    public void renderRow(Element row, int rowIndex) {
        if (this.sheet.getRow(rowIndex) == null) {
            this.sheet.createRow(rowIndex);
        }
    }

    @Override
    public void doMerge(int rowIndex, int columnIndex, int rowSpan, int columnSpan) {
        XSSFCell cell = (XSSFCell)this.sheet.getRow(rowIndex).getCell(columnIndex);
        CellRangeAddress range = new CellRangeAddress(rowIndex, rowIndex + rowSpan - 1, columnIndex, columnIndex + columnSpan - 1);
        for (int row = rowIndex; row < rowIndex + rowSpan; ++row) {
            if (this.sheet.getRow(row) == null) {
                this.sheet.createRow(row);
            }
            for (int col = columnIndex; col < columnIndex + columnSpan; ++col) {
                XSSFCell nextCell = (XSSFCell)this.sheet.getRow(row).getCell(col);
                if (nextCell == null) {
                    nextCell = (XSSFCell)this.sheet.getRow(row).createCell(col);
                }
                nextCell.setCellStyle((CellStyle)cell.getCellStyle());
            }
        }
        this.sheet.addMergedRegion(range);
    }
}

