/*
 * Decompiled with CFR 0.152.
 */
package uk.co.certait.htmlexporter.writer;

import org.jsoup.nodes.Element;
import uk.co.certait.htmlexporter.writer.RowTracker;
import uk.co.certait.htmlexporter.writer.TableCellWriter;
import uk.co.certait.htmlexporter.writer.TableRowWriter;

public abstract class AbstractTableRowWriter
implements TableRowWriter {
    private TableCellWriter cellWriter;
    private RowTracker rowTracker;

    public AbstractTableRowWriter(TableCellWriter cellWriter) {
        this.cellWriter = cellWriter;
        this.rowTracker = new RowTracker();
    }

    @Override
    public void writeRow(Element row, int rowIndex) {
        this.renderRow(row, rowIndex);
        for (Element element : row.getAllElements()) {
            if (!element.tag().getName().equals("td") && !element.tag().getName().equals("th")) continue;
            int columnIndex = this.rowTracker.getNextColumnIndexForRow(rowIndex);
            this.cellWriter.writeCell(element, rowIndex, columnIndex);
            int rowSpan = this.getRowSpan(element);
            int columnSpan = this.getColumnSpan(element);
            this.rowTracker.addCell(rowIndex, columnIndex, rowSpan, columnSpan);
            if (rowSpan <= 1 && columnSpan <= 1) continue;
            this.doMerge(rowIndex, columnIndex, rowSpan, columnSpan);
        }
    }

    protected boolean isRowGrouped(Element row) {
        return row.hasAttr("");
    }

    protected String[] getRowGroups(Element row) {
        return this.getAttributeValues(row, "");
    }

    protected String[] getAttributeValues(Element element, String attributeName) {
        String[] values = null;
        if (element.hasAttr(attributeName)) {
            for (String value : values = element.attr(attributeName).toLowerCase().split(",")) {
                value = value.trim().toLowerCase();
            }
        }
        return values;
    }

    protected int getColumnSpan(Element element) {
        int columnSpan = 1;
        if (element.hasAttr("colspan")) {
            columnSpan = Integer.parseInt(element.attr("colspan"));
        }
        return columnSpan;
    }

    protected int getRowSpan(Element element) {
        int rowSpan = 1;
        if (element.hasAttr("rowSpan")) {
            rowSpan = Integer.parseInt(element.attr("rowSpan"));
        }
        return rowSpan;
    }

    public abstract void renderRow(Element var1, int var2);

    public abstract void doMerge(int var1, int var2, int var3, int var4);
}

