/*
 * Decompiled with CFR 0.152.
 */
package uk.co.certait.htmlexporter.ss;

import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.util.CellReference;
import uk.co.certait.htmlexporter.ss.CellRange;
import uk.co.certait.htmlexporter.ss.CellRangeResolver;
import uk.co.certait.htmlexporter.ss.CellRangeRow;
import uk.co.certait.htmlexporter.ss.TableCellReference;

public abstract class AbstractCellRangeResolver
implements CellRangeResolver {
    @Override
    public String getRangeString(CellRange range) {
        String rangeString = range.isContiguous() ? this.buildContiguousString(range) : this.buildNonContigousString(range);
        return rangeString;
    }

    private String buildContiguousString(CellRange range) {
        TableCellReference firstCell = range.getFirstCell();
        CellReference first = new CellReference(firstCell.getRowIndex(), firstCell.getColumnIndex());
        TableCellReference lastCell = range.getLastCell();
        CellReference last = new CellReference(lastCell.getRowIndex(), lastCell.getColumnIndex());
        return first.formatAsString() + ":" + last.formatAsString();
    }

    private String buildNonContigousString(CellRange range) {
        StringBuilder builder = new StringBuilder();
        for (CellRangeRow row : range.getRows()) {
            for (TableCellReference cell : row.getCells()) {
                if (cell == null) continue;
                builder.append(new CellReference(cell.getRowIndex(), cell.getColumnIndex()).formatAsString()).append(this.getCellSeparator());
            }
        }
        return StringUtils.removeEnd((String)builder.toString(), (String)this.getCellSeparator());
    }

    public abstract String getCellSeparator();
}

