/*
 * Decompiled with CFR 0.152.
 */
package uk.co.certait.htmlexporter.css;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import uk.co.certait.htmlexporter.css.CssColorProperty;
import uk.co.certait.htmlexporter.css.CssIntegerProperty;
import uk.co.certait.htmlexporter.css.CssStringProperty;

public class Style {
    protected static final String BOLD_FONT_STYLE = "bold";
    protected static final String ITALIC_FONT_STYLE = "italic";
    protected static final String TEXT_DECORATION_UNDERLINE = "underline";
    protected static final String LEFT_ALIGN = "left";
    protected static final String RIGHT_ALIGN = "right";
    protected static final String CENTER_ALIGN = "center";
    protected static final String TOP_ALIGN = "top";
    protected static final String BOTTOM_ALIGN = "bottom";
    protected static final String MIDDLE_ALIGN = "middle";
    protected static final String SOLID_BORDER = "solid";
    protected static final String DASHED_BORDER = "dashed";
    protected static final String DOTTED_BORDER = "dotted";
    protected static final String DOUBLE_BORDER = "double";
    private Map<CssIntegerProperty, Integer> integerProperties = new HashMap<CssIntegerProperty, Integer>();
    private Map<CssStringProperty, String> stringProperties = new HashMap<CssStringProperty, String>();
    private Map<CssColorProperty, Color> colorProperties = new HashMap<CssColorProperty, Color>();

    public void addProperty(CssIntegerProperty property, Integer value) {
        if (value != null) {
            this.integerProperties.put(property, value);
        }
    }

    public void addProperty(CssStringProperty property, String value) {
        if (!StringUtils.isEmpty((CharSequence)value)) {
            this.stringProperties.put(property, value);
        }
    }

    public void addProperty(CssColorProperty property, Color color) {
        if (color != null) {
            this.colorProperties.put(property, color);
        }
    }

    protected Map<CssIntegerProperty, Integer> getIntegerProperties() {
        return this.integerProperties;
    }

    protected Map<CssStringProperty, String> getStringProperties() {
        return this.stringProperties;
    }

    protected Map<CssColorProperty, Color> getColorProperties() {
        return this.colorProperties;
    }

    public Optional<Integer> getProperty(CssIntegerProperty property) {
        return Optional.ofNullable(this.integerProperties.get((Object)property));
    }

    public Optional<String> getProperty(CssStringProperty property) {
        return Optional.ofNullable(this.stringProperties.get((Object)property));
    }

    public Optional<Color> getProperty(CssColorProperty property) {
        return Optional.ofNullable(this.colorProperties.get((Object)property));
    }

    public boolean isFontSizeSet() {
        return this.integerProperties.containsKey((Object)CssIntegerProperty.FONT_SIZE);
    }

    public boolean isWidthSet() {
        return this.integerProperties.containsKey((Object)CssIntegerProperty.WIDTH);
    }

    public boolean isFontNameSet() {
        return this.stringProperties.containsKey((Object)CssStringProperty.FONT_FAMILY);
    }

    public boolean isFontBold() {
        return BOLD_FONT_STYLE.equals(this.stringProperties.get((Object)CssStringProperty.FONT_WEIGHT));
    }

    public boolean isFontItalic() {
        return ITALIC_FONT_STYLE.equals(this.stringProperties.get((Object)CssStringProperty.FONT_STYLE));
    }

    public boolean isTextUnderlined() {
        return TEXT_DECORATION_UNDERLINE.equals(this.stringProperties.get((Object)CssStringProperty.TEXT_DECORATION));
    }

    public boolean isHorizontallyAlignedLeft() {
        return LEFT_ALIGN.equals(this.stringProperties.get((Object)CssStringProperty.TEXT_ALIGN));
    }

    public boolean isHorizontallyAlignedRight() {
        return RIGHT_ALIGN.equals(this.stringProperties.get((Object)CssStringProperty.TEXT_ALIGN));
    }

    public boolean isHorizontallyAlignedCenter() {
        return CENTER_ALIGN.equals(this.stringProperties.get((Object)CssStringProperty.TEXT_ALIGN));
    }

    public boolean isVerticallyAlignedTop() {
        return TOP_ALIGN.equals(this.stringProperties.get((Object)CssStringProperty.VERTICAL_ALIGN));
    }

    public boolean isVerticallyAlignedBottom() {
        return BOTTOM_ALIGN.equals(this.stringProperties.get((Object)CssStringProperty.VERTICAL_ALIGN));
    }

    public boolean isVerticallyAlignedMiddle() {
        return MIDDLE_ALIGN.equals(this.stringProperties.get((Object)CssStringProperty.VERTICAL_ALIGN));
    }

    public boolean isBackgroundSet() {
        return this.colorProperties.containsKey((Object)CssColorProperty.BACKGROUND_COLOR);
    }

    public boolean isBorderColorSet() {
        return this.colorProperties.containsKey((Object)CssColorProperty.BORDER_COLOR);
    }

    public boolean isColorSet() {
        return this.colorProperties.containsKey((Object)CssColorProperty.COLOR);
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (this == obj) {
            equals = true;
        } else if (obj != null && obj instanceof Style) {
            Style other = (Style)obj;
            equals = new EqualsBuilder().append(this.integerProperties, other.integerProperties).append(this.stringProperties, other.stringProperties).append(this.colorProperties, other.colorProperties).isEquals();
        }
        return equals;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.integerProperties).append(this.stringProperties).append(this.colorProperties).toHashCode();
    }
}

