/*
 * Decompiled with CFR 0.152.
 */
package uk.co.certait.htmlexporter.writer.excel;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import uk.co.certait.htmlexporter.css.CssColorProperty;
import uk.co.certait.htmlexporter.css.CssIntegerProperty;
import uk.co.certait.htmlexporter.css.CssStringProperty;
import uk.co.certait.htmlexporter.css.Style;

public class ExcelStyleGenerator {
    private static final Map<BorderMappingKey, BorderStyle> BORDER_STYLE_MAP = new HashMap<BorderMappingKey, BorderStyle>();
    private Map<Style, XSSFCellStyle> styles = new HashMap<Style, XSSFCellStyle>();

    public CellStyle getStyle(Cell cell, Style style) {
        XSSFCellStyle cellStyle;
        if (this.styles.containsKey(style)) {
            cellStyle = this.styles.get(style);
        } else {
            cellStyle = (XSSFCellStyle)cell.getSheet().getWorkbook().createCellStyle();
            this.applyBackground(style, cellStyle);
            this.applyBorders(style, cellStyle);
            this.applyFont(cell, style, cellStyle);
            this.applyHorizontalAlignment(style, cellStyle);
            this.applyverticalAlignment(style, cellStyle);
            this.applyWidth(cell, style);
            this.styles.put(style, cellStyle);
        }
        return cellStyle;
    }

    protected void applyBackground(Style style, XSSFCellStyle cellStyle) {
        if (style.isBackgroundSet()) {
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cellStyle.setFillForegroundColor(new XSSFColor(style.getProperty(CssColorProperty.BACKGROUND_COLOR).get(), null));
        }
    }

    protected void applyBorders(Style style, XSSFCellStyle cellStyle) {
        BorderStyle rightBorderStyle;
        BorderStyle leftBorderStyle;
        BorderStyle bottomBorderStyle;
        Color borderColor = style.getProperty(CssColorProperty.BORDER_COLOR).orElse(Color.BLACK);
        BorderStyle topBorderStyle = this.getBorderStyle(style, CssStringProperty.BORDER_TOP_STYLE, CssStringProperty.BORDER_TOP_WIDTH);
        if (topBorderStyle != null) {
            cellStyle.setBorderTop(topBorderStyle);
            Color topBorderColor = style.getProperty(CssColorProperty.BORDER_TOP_COLOR).orElse(borderColor);
            cellStyle.setTopBorderColor(new XSSFColor(topBorderColor, null));
        }
        if ((bottomBorderStyle = this.getBorderStyle(style, CssStringProperty.BORDER_BOTTOM_STYLE, CssStringProperty.BORDER_BOTTOM_WIDTH)) != null) {
            cellStyle.setBorderBottom(bottomBorderStyle);
            Color bottomBorderColor = style.getProperty(CssColorProperty.BORDER_BOTTOM_COLOR).orElse(borderColor);
            cellStyle.setBottomBorderColor(new XSSFColor(bottomBorderColor, null));
        }
        if ((leftBorderStyle = this.getBorderStyle(style, CssStringProperty.BORDER_LEFT_STYLE, CssStringProperty.BORDER_LEFT_WIDTH)) != null) {
            cellStyle.setBorderLeft(leftBorderStyle);
            Color leftBorderColor = style.getProperty(CssColorProperty.BORDER_LEFT_COLOR).orElse(borderColor);
            cellStyle.setLeftBorderColor(new XSSFColor(leftBorderColor, null));
        }
        if ((rightBorderStyle = this.getBorderStyle(style, CssStringProperty.BORDER_RIGHT_STYLE, CssStringProperty.BORDER_RIGHT_WIDTH)) != null) {
            cellStyle.setBorderRight(rightBorderStyle);
            Color rightBorderColor = style.getProperty(CssColorProperty.BORDER_RIGHT_COLOR).orElse(borderColor);
            cellStyle.setRightBorderColor(new XSSFColor(rightBorderColor, null));
        }
    }

    protected BorderStyle getBorderStyle(Style style, CssStringProperty borderStyleProperty, CssStringProperty borderWidthProperty) {
        String cssBorderWidth;
        BorderStyle excelBorderStyle = null;
        String cssBorderStyle = style.getProperty(borderStyleProperty).orElse(style.getProperty(CssStringProperty.BORDER_STYLE).orElse(null));
        excelBorderStyle = BORDER_STYLE_MAP.get(new BorderMappingKey(cssBorderStyle, cssBorderWidth = style.getProperty(borderWidthProperty).orElse(style.getProperty(CssStringProperty.BORDER_WIDTH).orElse(null))));
        if (excelBorderStyle == null) {
            try {
                excelBorderStyle = BorderStyle.valueOf((String)cssBorderStyle.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return excelBorderStyle;
    }

    protected void applyFont(Cell cell, Style style, XSSFCellStyle cellStyle) {
        Font font = this.createFont(cell.getSheet().getWorkbook(), style);
        cellStyle.setFont(font);
    }

    protected void applyHorizontalAlignment(Style style, XSSFCellStyle cellStyle) {
        if (style.isHorizontallyAlignedLeft()) {
            cellStyle.setAlignment(HorizontalAlignment.LEFT);
        } else if (style.isHorizontallyAlignedRight()) {
            cellStyle.setAlignment(HorizontalAlignment.RIGHT);
        } else if (style.isHorizontallyAlignedCenter()) {
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
        }
    }

    protected void applyverticalAlignment(Style style, XSSFCellStyle cellStyle) {
        if (style.isVerticallyAlignedTop()) {
            cellStyle.setVerticalAlignment(VerticalAlignment.TOP);
        } else if (style.isVerticallyAlignedBottom()) {
            cellStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
        } else if (style.isVerticallyAlignedMiddle()) {
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        }
    }

    protected void applyWidth(Cell cell, Style style) {
        if (style.getProperty(CssIntegerProperty.WIDTH).isPresent()) {
            cell.getSheet().setColumnWidth(cell.getColumnIndex(), style.getProperty(CssIntegerProperty.WIDTH).get() * 50);
        }
    }

    public Font createFont(Workbook workbook, Style style) {
        Font font = workbook.createFont();
        if (style.isFontNameSet()) {
            String fontName = style.getProperty(CssStringProperty.FONT_FAMILY).get().split(",")[0].trim().replaceAll("\"", "");
            font.setFontName(fontName);
        }
        if (style.isFontSizeSet()) {
            font.setFontHeightInPoints((short)style.getProperty(CssIntegerProperty.FONT_SIZE).get().intValue());
        }
        if (style.isColorSet()) {
            Color color = style.getProperty(CssColorProperty.COLOR).get();
            ((XSSFFont)font).setColor(new XSSFColor(color, null));
        }
        font.setBold(style.isFontBold());
        font.setItalic(style.isFontItalic());
        if (style.isTextUnderlined()) {
            font.setUnderline((byte)1);
        }
        return font;
    }

    static {
        BORDER_STYLE_MAP.put(new BorderMappingKey("solid", null), BorderStyle.THIN);
        BORDER_STYLE_MAP.put(new BorderMappingKey("solid", "thin"), BorderStyle.THIN);
        BORDER_STYLE_MAP.put(new BorderMappingKey("solid", "medium"), BorderStyle.MEDIUM);
        BORDER_STYLE_MAP.put(new BorderMappingKey("solid", "thick"), BorderStyle.THICK);
    }

    static class BorderMappingKey {
        private String borderStyle;
        private String borderWidth;

        public BorderMappingKey(String borderStyle, String borderWidth) {
            this.borderStyle = borderStyle;
            this.borderWidth = borderWidth;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof BorderMappingKey) {
                BorderMappingKey other = (BorderMappingKey)obj;
                return new EqualsBuilder().append((Object)this.borderStyle, (Object)other.borderStyle).append((Object)this.borderWidth, (Object)other.borderWidth).isEquals();
            }
            return false;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.borderStyle).append((Object)this.borderWidth).toHashCode();
        }
    }
}

