/*
 * Decompiled with CFR 0.152.
 */
package uk.co.certait.htmlexporter.demo.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import uk.co.certait.htmlexporter.demo.domain.ProductGroup;
import uk.co.certait.htmlexporter.demo.domain.Store;

public class Region {
    private String id;
    private String name;
    private List<Store> stores;

    public Region(String id, String name) {
        this.id = id;
        this.name = name;
        this.stores = new ArrayList<Store>();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<Store> getStores() {
        return this.stores;
    }

    public void addStore(Store store) {
        this.stores.add(store);
    }

    public int getNumberOfSalesForProductGroup(ProductGroup group) {
        int count = 0;
        for (Store store : this.stores) {
            count += store.getNumberOfSalesForProductGroup(group);
        }
        return count;
    }

    public BigDecimal getValueOfSalesForProductGroup(ProductGroup group) {
        BigDecimal total = new BigDecimal("0");
        for (Store store : this.stores) {
            total = total.add(store.getValueOfSalesForProductGroup(group));
        }
        return total;
    }

    public int getNumberOfSales() {
        int total = 0;
        for (Store store : this.stores) {
            total += store.getNumberOfSales();
        }
        return total;
    }

    public BigDecimal getValueOfSales() {
        BigDecimal total = new BigDecimal("0");
        for (Store store : this.stores) {
            total = total.add(store.getValueOfSales());
        }
        return total;
    }

    public int getNumberOfStores() {
        return this.stores.size();
    }
}

