/*
 * Decompiled with CFR 0.152.
 */
package uk.co.certait.htmlexporter.demo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import uk.co.certait.htmlexporter.demo.domain.Area;
import uk.co.certait.htmlexporter.demo.domain.ProductGroup;
import uk.co.certait.htmlexporter.demo.domain.Region;
import uk.co.certait.htmlexporter.demo.domain.Sale;
import uk.co.certait.htmlexporter.demo.domain.SalesReportData;
import uk.co.certait.htmlexporter.demo.domain.Store;
import uk.co.certait.htmlexporter.pdf.PdfExporter;
import uk.co.certait.htmlexporter.writer.excel.ExcelExporter;
import uk.co.certait.htmlexporter.writer.ods.OdsExporter;

public class ReportGenerator {
    public ReportGenerator() throws Exception {
        String html = this.generateHTML("report.vm");
        File directory = new File(System.getProperty("user.home") + "/html-exporter");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yy-HH-mm-ss");
        String timestamp = LocalDateTime.now().format(formatter);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        LocalDateTime.now();
        new ExcelExporter().exportHtml(html, new File(directory, "report-" + timestamp + ".xlsx"));
        new PdfExporter().exportHtml(html, new File(directory, "report-" + timestamp + ".pdf"));
        new OdsExporter().exportHtml(html, new File(directory, "report-" + timestamp + ".ods"));
    }

    public static void main(String[] args) throws Exception {
        new ReportGenerator();
        System.exit(0);
    }

    public String generateHTML(String templateName) {
        Properties props = new Properties();
        props.put("resource.loader", "class");
        props.put("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.init((Properties)props);
        Template template = Velocity.getTemplate((String)templateName);
        VelocityContext context = new VelocityContext();
        context.put("data", (Object)this.generateData());
        context.put("productGroups", (Object)ProductGroup.values());
        StringWriter writer = new StringWriter();
        template.merge((Context)context, (Writer)writer);
        return ((Object)writer).toString();
    }

    public SalesReportData generateData() {
        SalesReportData data = new SalesReportData();
        String[] areaNames = new String[]{"North", "South", "East", "West"};
        String[][] regionNames = new String[][]{{"Grampian", "Highland"}, {"Borders", "Dumfries"}, {"Fife", "Lothian", "Tayside"}, {"Argyll", "Ayrshire", "Glasgow"}};
        for (int i = 0; i < areaNames.length; ++i) {
            Area area = new Area(i, areaNames[i]);
            int storeCount = RandomUtils.nextInt((int)1, (int)2) + 2;
            for (int j = 0; j < regionNames[i].length; ++j) {
                Region region = new Region(i + "_" + j, regionNames[i][j]);
                area.addRegion(region);
                for (int k = 0; k < storeCount; ++k) {
                    Store store = new Store(region.getName() + "_" + (k + 1), region.getName() + " Store " + (k + 1));
                    region.addStore(store);
                    for (ProductGroup group : ProductGroup.values()) {
                        int saleCount = RandomUtils.nextInt((int)1, (int)50);
                        for (int m = 0; m < saleCount; ++m) {
                            int value = RandomUtils.nextInt((int)1, (int)100) + 10;
                            store.addSale(new Sale(group, new BigDecimal(Integer.toString(value))));
                        }
                    }
                }
            }
            data.addArea(area);
        }
        return data;
    }

    public void saveFile(String fileName, byte[] data) throws IOException {
        File file = new File(fileName);
        FileOutputStream out = new FileOutputStream(file);
        IOUtils.write((byte[])data, (OutputStream)out);
    }
}

