/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.aiui.player.core;

import android.content.Context;
import android.media.AudioManager;
import android.os.Handler;
import com.iflytek.aiui.player.common.data.MetaItem;
import com.iflytek.aiui.player.common.default.DefaultMediaPlayer;
import com.iflytek.aiui.player.common.logger.HttpLogger;
import com.iflytek.aiui.player.common.logger.Logger;
import com.iflytek.aiui.player.common.player.MetaAbstractPlayer;
import com.iflytek.aiui.player.common.player.MetaListener;
import com.iflytek.aiui.player.common.player.MetaMediaPlayer;
import com.iflytek.aiui.player.common.player.MetaState;
import com.iflytek.aiui.player.common.request.Request;
import com.iflytek.aiui.player.common.rpc.RPC;
import com.iflytek.aiui.player.common.rpc.RPCListener;
import com.iflytek.aiui.player.common.rpc.connection.DataConnection;
import com.iflytek.aiui.player.common.rpc.connection.impl.WebSocketServerConnection;
import com.iflytek.aiui.player.common.storage.Storage;
import com.iflytek.aiui.player.common.utils.UniqueIDUtil;
import com.iflytek.aiui.player.core.AIUIPlayer;
import com.iflytek.aiui.player.core.AIUIPlayer$WhenMappings;
import com.iflytek.aiui.player.core.AIUIPlayer$initialize$;
import com.iflytek.aiui.player.core.AudioFocus;
import com.iflytek.aiui.player.core.PlayState;
import com.iflytek.aiui.player.core.PlayerListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020(J \u0010:\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00052\b\b\u0002\u0010>\u001a\u00020\u0005JT\u0010?\u001a\u0002082\u0006\u0010@\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00052\u001c\u0010A\u001a\u0018\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u0002080Bj\b\u0012\u0004\u0012\u00020<`C2\u001c\u0010D\u001a\u0018\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002080Ej\u0002`FH\u0007J\u0006\u0010G\u001a\u00020\u0018J\u0006\u0010H\u001a\u000208J\u0006\u0010I\u001a\u00020\u001cJ\b\u0010J\u001a\u000208H\u0002J\u0010\u0010K\u001a\u0002082\u0006\u0010L\u001a\u00020\u0010H\u0002J\u0010\u0010M\u001a\u0002082\u0006\u0010N\u001a\u00020\u0014H\u0002J\u0018\u0010O\u001a\u0002082\u0006\u0010D\u001a\u00020%2\u0006\u0010P\u001a\u00020\u0005H\u0002J\u0006\u0010Q\u001a\u000208J*\u0010R\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00052\b\b\u0002\u0010>\u001a\u00020\u00052\b\b\u0002\u0010S\u001a\u00020\u001cJ\u0012\u0010T\u001a\u00020\u001c2\b\b\u0002\u0010U\u001a\u00020\u001cH\u0002J\u0006\u0010V\u001a\u00020\u001cJ\u0006\u0010W\u001a\u000208J\u000e\u0010X\u001a\u0002082\u0006\u00109\u001a\u00020(JJ\u0010Y\u001a\u0002082\u0006\u0010Y\u001a\u00020Z2\u001c\u0010A\u001a\u0018\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002080Bj\b\u0012\u0004\u0012\u00020\u0001`C2\u001c\u0010D\u001a\u0018\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002080Ej\u0002`FJ\u0006\u0010[\u001a\u000208J\u0006\u0010\\\u001a\u000208J\u0016\u0010]\u001a\u0002082\f\u0010^\u001a\b\u0012\u0004\u0012\u0002080_H\u0002J\u000e\u0010`\u001a\u0002082\u0006\u0010a\u001a\u00020\u0018J\u000e\u0010b\u001a\u0002082\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010c\u001a\u000208R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020(0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001e0#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lcom/iflytek/aiui/player/core/AIUIPlayer;", "", "context", "Landroid/content/Context;", "config", "", "(Landroid/content/Context;Ljava/lang/String;)V", "appId", "getAppId", "()Ljava/lang/String;", "setAppId", "(Ljava/lang/String;)V", "appKey", "getAppKey", "setAppKey", "currentPlay", "Lcom/iflytek/aiui/player/common/data/MetaItem;", "getCurrentPlay", "()Lcom/iflytek/aiui/player/common/data/MetaItem;", "currentState", "Lcom/iflytek/aiui/player/core/PlayState;", "getCurrentState", "()Lcom/iflytek/aiui/player/core/PlayState;", "duration", "", "getDuration", "()J", "isDebug", "", "mActivePlayer", "Lcom/iflytek/aiui/player/common/player/MetaAbstractPlayer;", "mAudioFocus", "Lcom/iflytek/aiui/player/core/AudioFocus;", "mAutoSkipError", "mData", "", "mIndex", "", "mInitialized", "mListeners", "Lcom/iflytek/aiui/player/core/PlayerListener;", "mLogger", "Lcom/iflytek/aiui/player/common/logger/Logger;", "mMainHandler", "Landroid/os/Handler;", "mPlayers", "mRPCServer", "Lcom/iflytek/aiui/player/common/rpc/RPC;", "mReadyCount", "mServerConnection", "Lcom/iflytek/aiui/player/common/rpc/connection/DataConnection;", "mState", "mStorage", "Lcom/iflytek/aiui/player/common/storage/Storage;", "positiveDirection", "addListener", "", "listener", "anyAvailablePlay", "data", "Lorg/json/JSONArray;", "service", "sid", "getAudioUrls", "jsonArrayData", "success", "Lkotlin/Function1;", "Lcom/iflytek/aiui/player/common/request/SuccessRetCallback;", "error", "Lkotlin/Function2;", "Lcom/iflytek/aiui/player/common/request/ErrorCallback;", "getCurrentPosition", "initialize", "next", "onComplete", "onItemChange", "item", "onStateChange", "state", "onStateError", "description", "pause", "play", "autoSkipError", "playToNextAvailable", "positive", "previous", "release", "removeListener", "request", "Lcom/iflytek/aiui/player/common/request/Request;", "reset", "resume", "runMain", "action", "Lkotlin/Function0;", "seekTo", "msec", "setDebug", "stop", "aiui_player_release"})
public final class AIUIPlayer {
    private DataConnection mServerConnection;
    private RPC mRPCServer;
    @NotNull
    private String appId;
    @NotNull
    private String appKey;
    private Handler mMainHandler;
    private Storage mStorage;
    private List<MetaAbstractPlayer> mPlayers;
    private MetaAbstractPlayer mActivePlayer;
    private final List<PlayerListener> mListeners;
    private PlayState mState;
    private List<MetaItem> mData;
    private int mIndex;
    private boolean positiveDirection;
    private boolean mInitialized;
    private int mReadyCount;
    private boolean mAutoSkipError;
    private Logger mLogger;
    private final AudioFocus mAudioFocus;
    private boolean isDebug;
    private final Context context;
    private final String config;

    @NotNull
    public final String getAppId() {
        return this.appId;
    }

    public final void setAppId(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.appId = string;
    }

    @NotNull
    public final String getAppKey() {
        return this.appKey;
    }

    public final void setAppKey(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.appKey = string;
    }

    @Nullable
    public final MetaItem getCurrentPlay() {
        int n = this.mIndex;
        return 0 > n || this.mData.size() <= n ? null : this.mData.get(this.mIndex);
    }

    @NotNull
    public final PlayState getCurrentState() {
        return this.mState;
    }

    public final long getDuration() {
        MetaAbstractPlayer metaAbstractPlayer = this.mActivePlayer;
        return metaAbstractPlayer != null ? metaAbstractPlayer.getDuration() : 0L;
    }

    public final long getCurrentPosition() {
        MetaAbstractPlayer metaAbstractPlayer = this.mActivePlayer;
        return metaAbstractPlayer != null ? metaAbstractPlayer.getCurrentPos() : 0L;
    }

    public final void initialize() {
        String it;
        if (this.mInitialized) {
            return;
        }
        this.mLogger = (Logger)new HttpLogger(this.appId, this.appKey, UniqueIDUtil.INSTANCE.getMscUniqueId(this.context));
        Object[] objectArray = new MetaAbstractPlayer[1];
        Logger logger = this.mLogger;
        if (logger == null) {
            Intrinsics.throwNpe();
        }
        objectArray[0] = (MetaAbstractPlayer)new MetaMediaPlayer(this.context, this.config, this.mRPCServer, this.mStorage, logger);
        this.mPlayers = CollectionsKt.mutableListOf((Object[])objectArray);
        String prefix = "com.iflytek.aiui.player.players";
        List players = CollectionsKt.listOf((Object[])new String[]{prefix + ".KuwoLSMusicPlayer", prefix + ".MetaKGPlayer", prefix + ".MetaQTPlayer", prefix + ".MetaMiGuPlayer", prefix + ".MetaKWPlayer"});
        Iterable $this$forEach$iv = players;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            try {
                Object object;
                Object player;
                Class<?> clazz = Class.forName(it);
                Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(it)");
                KClass playerClass = JvmClassMappingKt.getKotlinClass(clazz);
                KFunction kFunction = KClasses.getPrimaryConstructor((KClass)playerClass);
                Object object2 = player = kFunction != null ? kFunction.call(new Object[]{this.context, this.config, this.mRPCServer, this.mStorage, this.mLogger}) : null;
                if (player == null) continue;
                boolean bl2 = false;
                boolean bl3 = false;
                Object it2 = object;
                boolean bl4 = false;
                this.mPlayers.add((MetaAbstractPlayer)player);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        Logger logger2 = this.mLogger;
        if (logger2 == null) {
            Intrinsics.throwNpe();
        }
        this.mPlayers.add((MetaAbstractPlayer)new DefaultMediaPlayer(this.context, this.config, this.mRPCServer, this.mStorage, logger2));
        this.mServerConnection.start();
        this.onStateChange(PlayState.INITIALIZING);
        $this$forEach$iv = this.mPlayers;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MetaAbstractPlayer)element$iv;
            boolean bl = false;
            it.initialize();
            it.setDebug(this.isDebug);
            it.addListener(new MetaListener(this){
                final /* synthetic */ AIUIPlayer this$0;
                {
                    this.this$0 = aIUIPlayer;
                }

                public void onError(int error, @NotNull String description) {
                    Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
                    if (AIUIPlayer.access$getMAutoSkipError$p(this.this$0)) {
                        if (AIUIPlayer.access$getPositiveDirection$p(this.this$0)) {
                            if (!this.this$0.next()) {
                                AIUIPlayer.access$onStateError(this.this$0, error, description);
                            }
                        } else if (!this.this$0.previous()) {
                            AIUIPlayer.access$onStateError(this.this$0, error, description);
                        }
                    } else {
                        AIUIPlayer.access$onStateError(this.this$0, error, description);
                    }
                }

                public void onReady() {
                    AIUIPlayer aIUIPlayer = this.this$0;
                    AIUIPlayer.access$setMReadyCount$p(aIUIPlayer, AIUIPlayer.access$getMReadyCount$p(aIUIPlayer) + 1);
                    if (AIUIPlayer.access$getMReadyCount$p(aIUIPlayer) == AIUIPlayer.access$getMPlayers$p(this.this$0).size()) {
                        AIUIPlayer.access$onStateChange(this.this$0, PlayState.READY);
                        AIUIPlayer.access$runMain(this.this$0, (Function0)new Function0<Unit>(this){
                            final /* synthetic */ initialize$$inlined$forEach$lambda$1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }

                            public final void invoke() {
                                Iterable $this$forEach$iv = AIUIPlayer.access$getMListeners$p(this.this$0.this$0);
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    PlayerListener listener = (PlayerListener)element$iv;
                                    boolean bl = false;
                                    listener.onPlayerReady();
                                }
                            }
                        });
                    }
                }

                public void onStateChange(@NotNull MetaState state) {
                    Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                    switch (AIUIPlayer$WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                        case 1: {
                            AIUIPlayer.access$onStateChange(this.this$0, PlayState.LOADING);
                            break;
                        }
                        case 2: {
                            if (AIUIPlayer.access$getMState$p(this.this$0) == PlayState.LOADING) {
                                AIUIPlayer.access$onStateChange(this.this$0, PlayState.PLAYING);
                            }
                            if (AIUIPlayer.access$getMAudioFocus$p(this.this$0).requestAudioFocusIfNeed() == 1) break;
                            this.this$0.pause();
                            break;
                        }
                        case 3: {
                            if (this.this$0.next()) break;
                            AIUIPlayer.access$onComplete(this.this$0);
                            AIUIPlayer.access$getMAudioFocus$p(this.this$0).abandonAudioFocus();
                        }
                    }
                }

                public void onRelease() {
                    AIUIPlayer aIUIPlayer = this.this$0;
                    AIUIPlayer.access$setMReadyCount$p(aIUIPlayer, AIUIPlayer.access$getMReadyCount$p(aIUIPlayer) + -1);
                    if (AIUIPlayer.access$getMReadyCount$p(aIUIPlayer) == 0) {
                        AIUIPlayer.access$runMain(this.this$0, (Function0)new Function0<Unit>(this){
                            final /* synthetic */ initialize$$inlined$forEach$lambda$1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }

                            public final void invoke() {
                                Iterable $this$forEach$iv = AIUIPlayer.access$getMListeners$p(this.this$0.this$0);
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    PlayerListener listener = (PlayerListener)element$iv;
                                    boolean bl = false;
                                    listener.onPlayerRelease();
                                }
                            }
                        });
                        AIUIPlayer.access$onStateChange(this.this$0, PlayState.IDLE);
                    }
                }
            });
        }
        this.mInitialized = true;
    }

    public final void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
        Iterable $this$forEach$iv = this.mPlayers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MetaAbstractPlayer it = (MetaAbstractPlayer)element$iv;
            boolean bl = false;
            it.setDebug(isDebug);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean anyAvailablePlay(@NotNull JSONArray data, @NotNull String service, @NotNull String sid) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
        Intrinsics.checkParameterIsNotNull((Object)sid, (String)"sid");
        int n = 0;
        int n2 = data.length();
        while (n < n2) {
            void i;
            boolean bl;
            block5: {
                Iterable $this$any$iv = this.mPlayers;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        MetaAbstractPlayer it = (MetaAbstractPlayer)element$iv;
                        boolean bl2 = false;
                        JSONObject jSONObject = data.optJSONObject((int)i);
                        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"data.optJSONObject(i)");
                        if (!it.canDispose(new MetaItem(jSONObject, service, sid))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static /* synthetic */ boolean anyAvailablePlay$default(AIUIPlayer aIUIPlayer, JSONArray jSONArray, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        return aIUIPlayer.anyAvailablePlay(jSONArray, string, string2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean play(@NotNull JSONArray data, @NotNull String service, @NotNull String sid, boolean autoSkipError) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
        Intrinsics.checkParameterIsNotNull((Object)sid, (String)"sid");
        if (this.mState != PlayState.READY || !AIUIPlayer.anyAvailablePlay$default(this, data, service, null, 4, null)) {
            return false;
        }
        MetaAbstractPlayer metaAbstractPlayer = this.mActivePlayer;
        if (metaAbstractPlayer != null) {
            metaAbstractPlayer.pause();
        }
        AIUIPlayer aIUIPlayer = this;
        int n = 0;
        aIUIPlayer.mData = list = (List)new ArrayList();
        n = 0;
        int n2 = data.length();
        while (n < n2) {
            void i;
            JSONObject jSONObject = data.optJSONObject((int)i);
            Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"data.optJSONObject(i)");
            this.mData.add(new MetaItem(jSONObject, service, sid));
            ++i;
        }
        this.mIndex = -1;
        this.mAutoSkipError = autoSkipError;
        return AIUIPlayer.playToNextAvailable$default(this, false, 1, null);
    }

    public static /* synthetic */ boolean play$default(AIUIPlayer aIUIPlayer, JSONArray jSONArray, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return aIUIPlayer.play(jSONArray, string, string2, bl);
    }

    public final boolean next() {
        this.positiveDirection = true;
        return AIUIPlayer.playToNextAvailable$default(this, false, 1, null);
    }

    public final boolean previous() {
        this.positiveDirection = false;
        return this.playToNextAvailable(false);
    }

    public final void pause() {
        switch (AIUIPlayer$WhenMappings.$EnumSwitchMapping$1[this.mState.ordinal()]) {
            case 1: 
            case 2: {
                this.onStateChange(PlayState.PAUSED);
                MetaAbstractPlayer metaAbstractPlayer = this.mActivePlayer;
                if (metaAbstractPlayer != null) {
                    metaAbstractPlayer.pause();
                }
                break;
            }
        }
    }

    public final void stop() {
        this.reset();
    }

    public final void resume() {
        switch (AIUIPlayer$WhenMappings.$EnumSwitchMapping$2[this.mState.ordinal()]) {
            case 1: {
                this.onStateChange(PlayState.PLAYING);
                MetaAbstractPlayer metaAbstractPlayer = this.mActivePlayer;
                if (metaAbstractPlayer != null) {
                    metaAbstractPlayer.resume();
                }
                break;
            }
            case 2: {
                int n = this.mIndex;
                this.mIndex = n + 1;
                this.playToNextAvailable(false);
                break;
            }
        }
    }

    public final void seekTo(long msec) {
        block0: {
            MetaAbstractPlayer metaAbstractPlayer = this.mActivePlayer;
            if (metaAbstractPlayer == null) break block0;
            metaAbstractPlayer.seekTo(msec);
        }
    }

    public final void reset() {
        this.onStateChange(PlayState.READY);
        MetaAbstractPlayer metaAbstractPlayer = this.mActivePlayer;
        if (metaAbstractPlayer != null) {
            metaAbstractPlayer.pause();
        }
        this.mData.clear();
        this.mIndex = -1;
    }

    public final void addListener(@NotNull PlayerListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.mListeners.add(listener);
        if (this.mState != PlayState.IDLE && this.mState != PlayState.INITIALIZING) {
            this.runMain((Function0<Unit>)((Function0)new Function0<Unit>(listener){
                final /* synthetic */ PlayerListener $listener;

                public final void invoke() {
                    this.$listener.onPlayerReady();
                    this.$listener.onStateChange(PlayState.READY);
                }
                {
                    this.$listener = playerListener;
                    super(0);
                }
            }));
        }
    }

    public final void removeListener(@NotNull PlayerListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.mListeners.remove(listener);
    }

    public final void release() {
        if (!this.mInitialized) {
            return;
        }
        this.mInitialized = false;
        this.reset();
        Iterable $this$forEach$iv = this.mPlayers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MetaAbstractPlayer it = (MetaAbstractPlayer)element$iv;
            boolean bl = false;
            it.release();
        }
    }

    public final void request(@NotNull Request request, @NotNull Function1<Object, Unit> success, @NotNull Function2<? super Integer, ? super String, Unit> error) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull(success, (String)"success");
        Intrinsics.checkParameterIsNotNull(error, (String)"error");
        for (MetaAbstractPlayer subPlayer : this.mPlayers) {
            if (subPlayer.onRequest(request, success, error)) break;
        }
    }

    private final void runMain(Function0<Unit> action) {
        this.mMainHandler.post(new Runnable(action){
            final /* synthetic */ Function0 $action;

            public final void run() {
                this.$action.invoke();
            }
            {
                this.$action = function0;
            }
        });
    }

    private final void onComplete() {
        this.mIndex = this.mData.size() - 1;
        MetaAbstractPlayer metaAbstractPlayer = this.mActivePlayer;
        if (metaAbstractPlayer != null) {
            metaAbstractPlayer.pause();
        }
        this.onStateChange(PlayState.COMPLETE);
    }

    private final void onStateChange(PlayState state) {
        this.mState = state;
        this.runMain((Function0<Unit>)((Function0)new Function0<Unit>(this, state){
            final /* synthetic */ AIUIPlayer this$0;
            final /* synthetic */ PlayState $state;

            public final void invoke() {
                Iterable $this$forEach$iv = AIUIPlayer.access$getMListeners$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    PlayerListener it = (PlayerListener)element$iv;
                    boolean bl = false;
                    it.onStateChange(this.$state);
                }
            }
            {
                this.this$0 = aIUIPlayer;
                this.$state = playState;
                super(0);
            }
        }));
    }

    private final void onStateError(int error, String description) {
        this.onStateChange(PlayState.ERROR);
        this.runMain((Function0<Unit>)((Function0)new Function0<Unit>(this, error, description){
            final /* synthetic */ AIUIPlayer this$0;
            final /* synthetic */ int $error;
            final /* synthetic */ String $description;

            public final void invoke() {
                Iterable $this$forEach$iv = AIUIPlayer.access$getMListeners$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    PlayerListener it = (PlayerListener)element$iv;
                    boolean bl = false;
                    it.onError(this.$error, this.$description);
                }
            }
            {
                this.this$0 = aIUIPlayer;
                this.$error = n;
                this.$description = string;
                super(0);
            }
        }));
    }

    private final void onItemChange(MetaItem item) {
        this.runMain((Function0<Unit>)((Function0)new Function0<Unit>(this, item){
            final /* synthetic */ AIUIPlayer this$0;
            final /* synthetic */ MetaItem $item;

            public final void invoke() {
                Iterable $this$forEach$iv = AIUIPlayer.access$getMListeners$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    PlayerListener it = (PlayerListener)element$iv;
                    boolean bl = false;
                    it.onMediaChange(this.$item);
                }
            }
            {
                this.this$0 = aIUIPlayer;
                this.$item = metaItem;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean playToNextAvailable(boolean positive) {
        IntProgression range = (IntProgression)RangesKt.until((int)(this.mIndex + 1), (int)this.mData.size());
        if (!positive) {
            range = RangesKt.downTo((int)(this.mIndex - 1), (int)0);
        }
        IntProgression intProgression = range;
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = n;
        int n5 = n2;
        if (n3 >= 0 ? n4 <= n5 : n4 >= n5) {
            while (true) {
                void index;
                void var6_6;
                if (false <= (var6_6 = index)) {
                    if (this.mData.size() <= var6_6) {
                    } else {
                        Object v3;
                        block12: {
                            Iterable iterable = this.mPlayers;
                            boolean bl = false;
                            Iterable iterable2 = iterable;
                            boolean bl2 = false;
                            for (Object t : iterable2) {
                                MetaAbstractPlayer it = (MetaAbstractPlayer)t;
                                boolean bl3 = false;
                                if (!it.canDispose(this.mData.get((int)index))) continue;
                                v3 = t;
                                break block12;
                            }
                            v3 = null;
                        }
                        MetaAbstractPlayer availablePlayer = v3;
                        if (availablePlayer != null) {
                            MetaAbstractPlayer metaAbstractPlayer = this.mActivePlayer;
                            if (metaAbstractPlayer != null) {
                                metaAbstractPlayer.pause();
                            }
                            MetaAbstractPlayer metaAbstractPlayer2 = this.mActivePlayer;
                            if (metaAbstractPlayer2 != null) {
                                metaAbstractPlayer2.setMActive(false);
                            }
                            this.mIndex = index;
                            MetaAbstractPlayer metaAbstractPlayer3 = this.mActivePlayer = availablePlayer;
                            if (metaAbstractPlayer3 != null) {
                                metaAbstractPlayer3.setMActive(true);
                            }
                            this.onItemChange(this.mData.get(this.mIndex));
                            MetaAbstractPlayer metaAbstractPlayer4 = this.mActivePlayer;
                            if (metaAbstractPlayer4 != null) {
                                metaAbstractPlayer4.play(this.mData.get((int)index));
                            }
                            return true;
                        }
                    }
                }
                if (index == n2) break;
                n = index + n3;
            }
        }
        return false;
    }

    static /* synthetic */ boolean playToNextAvailable$default(AIUIPlayer aIUIPlayer, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return aIUIPlayer.playToNextAvailable(bl);
    }

    @Deprecated(message="\u7531\u4e8e\u97f3\u4e50\u64ad\u653e\u7684url\u6709\u65f6\u6548\u9650\u5236\uff0c\u76ee\u524d\u662f1\u4e2a\u5c0f\u65f6\u8fc7\u671f\uff0c\u6240\u4ee5\u6279\u91cf\u83b7\u53d6\u53ef\u64ad\u653e\u7684url\u4f1a\u5b58\u5728\u65e0\u6cd5\u64ad\u653e\u7684\u60c5\u51b5\u3002\u6b64\u65b9\u6cd5\u540e\u671f\u4e0d\u7ef4\u62a4")
    public final void getAudioUrls(@NotNull JSONArray jsonArrayData, @NotNull String service, @NotNull Function1<? super JSONArray, Unit> success, @NotNull Function2<? super Integer, ? super String, Unit> error) {
        Intrinsics.checkParameterIsNotNull((Object)jsonArrayData, (String)"jsonArrayData");
        Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
        Intrinsics.checkParameterIsNotNull(success, (String)"success");
        Intrinsics.checkParameterIsNotNull(error, (String)"error");
        if (this.mPlayers.isEmpty()) {
            Iterable $this$forEach$iv = this.mListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PlayerListener it = (PlayerListener)element$iv;
                boolean bl = false;
                error.invoke((Object)-1, (Object)"please init AIUI Player");
            }
            return;
        }
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this, jsonArrayData, service, success){
            final /* synthetic */ AIUIPlayer this$0;
            final /* synthetic */ JSONArray $jsonArrayData;
            final /* synthetic */ String $service;
            final /* synthetic */ Function1 $success;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                String string = this.$jsonArrayData.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jsonArrayData.toString()");
                String json = string;
                JSONArray tempData = new JSONArray(new JSONTokener(json));
                int n = 0;
                HashMap<K, V> needGetUrls = new HashMap<K, V>();
                n = 0;
                int n2 = tempData.length();
                while (n < n2) {
                    void i;
                    JSONObject jobj;
                    JSONObject jSONObject = jobj = tempData.optJSONObject((int)i);
                    if (jSONObject != null) {
                        jSONObject.put("expiretime", (Object)"");
                    }
                    JSONObject jSONObject2 = jobj;
                    if (jSONObject2 != null) {
                        jSONObject2.put("audiopath", (Object)"");
                    }
                    JSONObject jSONObject3 = jobj;
                    if (jSONObject3 != null) {
                        jSONObject3.put("resultCode", -1);
                    }
                    JSONObject jSONObject4 = tempData.optJSONObject((int)i);
                    Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject4, (String)"tempData.optJSONObject(i)");
                    MetaItem metaItem = new MetaItem(jSONObject4, this.$service, "");
                    Map map = needGetUrls;
                    String string2 = jobj.optString("itemid");
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"jobj.optString(\"itemid\")");
                    map.put(string2, metaItem);
                    ++i;
                }
                CountDownLatch countDownLatch = new CountDownLatch(needGetUrls.size());
                Collection<V> collection = needGetUrls.values();
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"needGetUrls.values");
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    MetaAbstractPlayer availablePlayer;
                    Object v9;
                    MetaItem metaItem;
                    block6: {
                        metaItem = (MetaItem)element$iv;
                        boolean bl = false;
                        Iterable iterable = AIUIPlayer.access$getMPlayers$p(this.this$0);
                        boolean bl2 = false;
                        Iterable iterable2 = iterable;
                        boolean bl3 = false;
                        for (T t : iterable2) {
                            MetaAbstractPlayer it = (MetaAbstractPlayer)t;
                            boolean bl4 = false;
                            MetaItem metaItem2 = metaItem;
                            Intrinsics.checkExpressionValueIsNotNull((Object)metaItem2, (String)"metaItem");
                            if (!it.canDispose(metaItem2)) continue;
                            v9 = t;
                            break block6;
                        }
                        v9 = null;
                    }
                    MetaAbstractPlayer metaAbstractPlayer = availablePlayer = (MetaAbstractPlayer)v9;
                    if (metaAbstractPlayer == null) continue;
                    MetaItem metaItem3 = metaItem;
                    Intrinsics.checkExpressionValueIsNotNull((Object)metaItem3, (String)"metaItem");
                    metaAbstractPlayer.getAudioUrls(metaItem3, (Function1)new Function1<JSONObject, Unit>(this, countDownLatch, needGetUrls){
                        final /* synthetic */ getAudioUrls.2 this$0;
                        final /* synthetic */ CountDownLatch $countDownLatch$inlined;
                        final /* synthetic */ HashMap $needGetUrls$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$countDownLatch$inlined = countDownLatch;
                            this.$needGetUrls$inlined = hashMap;
                            super(1);
                        }

                        public final void invoke(@NotNull JSONObject jsonobj) {
                            block2: {
                                JSONObject jobj;
                                Intrinsics.checkParameterIsNotNull((Object)jsonobj, (String)"jsonobj");
                                this.$countDownLatch$inlined.countDown();
                                String itemid = jsonobj.optString("itemid");
                                String expiretime = jsonobj.optString("expiretime");
                                String audiopath = jsonobj.optString("audiopath");
                                MetaItem metaItem = (MetaItem)this.$needGetUrls$inlined.get(itemid);
                                JSONObject jSONObject = jobj = metaItem != null ? metaItem.getInfo() : null;
                                if (jSONObject != null) {
                                    jSONObject.put("expiretime", (Object)expiretime);
                                }
                                JSONObject jSONObject2 = jobj;
                                if (jSONObject2 != null) {
                                    jSONObject2.put("audiopath", (Object)audiopath);
                                }
                                JSONObject jSONObject3 = jobj;
                                if (jSONObject3 == null) break block2;
                                jSONObject3.put("resultCode", 0);
                            }
                        }
                    }, (Function2)new Function2<Integer, String, Unit>(this, countDownLatch, needGetUrls){
                        final /* synthetic */ getAudioUrls.2 this$0;
                        final /* synthetic */ CountDownLatch $countDownLatch$inlined;
                        final /* synthetic */ HashMap $needGetUrls$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$countDownLatch$inlined = countDownLatch;
                            this.$needGetUrls$inlined = hashMap;
                            super(2);
                        }

                        public final void invoke(int code, @NotNull String msg) {
                            Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                            this.$countDownLatch$inlined.countDown();
                        }
                    });
                }
                countDownLatch.await(5L, TimeUnit.SECONDS);
                AIUIPlayer.access$runMain(this.this$0, (Function0)new Function0<Unit>(this, tempData){
                    final /* synthetic */ getAudioUrls.2 this$0;
                    final /* synthetic */ JSONArray $tempData;

                    public final void invoke() {
                        this.this$0.$success.invoke((Object)this.$tempData);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$tempData = jSONArray;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = aIUIPlayer;
                this.$jsonArrayData = jSONArray;
                this.$service = string;
                this.$success = function1;
                super(0);
            }
        }), (int)31, null);
    }

    public AIUIPlayer(@NotNull Context context, @NotNull String config) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.context = context;
        this.config = config;
        this.mServerConnection = (DataConnection)new WebSocketServerConnection(4096);
        this.mRPCServer = new RPC(this.mServerConnection, new RPCListener(this){
            final /* synthetic */ AIUIPlayer this$0;

            public void onRequest(@NotNull RPC rpc, @NotNull String data) {
                block1: {
                    MetaAbstractPlayer subPlayer;
                    boolean canHandle;
                    Request request;
                    Intrinsics.checkParameterIsNotNull((Object)rpc, (String)"rpc");
                    Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                    Request request2 = request = Request.Companion.decodeRequest(new JSONObject(data));
                    if (request2 == null) break block1;
                    Request request3 = request2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Request it = request3;
                    boolean bl3 = false;
                    Iterator<E> iterator = AIUIPlayer.access$getMPlayers$p(this.this$0).iterator();
                    while (iterator.hasNext() && !(canHandle = (subPlayer = (MetaAbstractPlayer)iterator.next()).onRequest(request, (Function1)new Function1<Object, Unit>(this, request, rpc){
                        final /* synthetic */ mRPCServer.1 this$0;
                        final /* synthetic */ Request $request$inlined;
                        final /* synthetic */ RPC $rpc$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$request$inlined = request;
                            this.$rpc$inlined = rPC;
                        }

                        public void invoke(@NotNull Object p1) {
                            Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                            this.$rpc$inlined.response(this.$request$inlined, p1);
                        }
                    }, (Function2)new Function2<Integer, String, Unit>(this, request, rpc){
                        final /* synthetic */ mRPCServer.1 this$0;
                        final /* synthetic */ Request $request$inlined;
                        final /* synthetic */ RPC $rpc$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$request$inlined = request;
                            this.$rpc$inlined = rPC;
                        }

                        public void invoke(int p1, @NotNull String p2) {
                            Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                            this.$rpc$inlined.response(this.$request$inlined, p1, p2);
                        }
                    }))) {
                    }
                }
            }
            {
                this.this$0 = $outer;
            }
        });
        this.appId = "";
        this.appKey = "";
        List configStrs = StringsKt.split$default((CharSequence)this.config, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
        Iterable $this$forEach$iv = configStrs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            List param = StringsKt.split$default((CharSequence)it, (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
            if (param.size() != 2) continue;
            String str$iv = (String)param.get(0);
            boolean $i$f$replaceBlank = false;
            String dest$iv = "";
            CharSequence charSequence = str$iv;
            boolean bl2 = false;
            if (charSequence.length() > 0) {
                Pattern p$iv = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m$iv = p$iv.matcher(str$iv);
                String string = m$iv.replaceAll("");
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"m.replaceAll(\"\")");
                dest$iv = string;
            }
            String key = dest$iv;
            String str$iv2 = (String)param.get(1);
            boolean $i$f$replaceBlank2 = false;
            String dest$iv2 = "";
            CharSequence m$iv = str$iv2;
            boolean bl3 = false;
            if (m$iv.length() > 0) {
                Pattern p$iv = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m$iv2 = p$iv.matcher(str$iv2);
                String string = m$iv2.replaceAll("");
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"m.replaceAll(\"\")");
                dest$iv2 = string;
            }
            String value = dest$iv2;
            switch (key) {
                case "appId": {
                    this.appId = value;
                    break;
                }
                case "appKey": {
                    this.appKey = value;
                }
            }
        }
        this.mMainHandler = new Handler(this.context.getMainLooper());
        this.mStorage = new Storage(this.context);
        AIUIPlayer aIUIPlayer = this;
        boolean bl = false;
        aIUIPlayer.mPlayers = list = (List)new ArrayList();
        aIUIPlayer = this;
        bl = false;
        aIUIPlayer.mListeners = list = (List)new ArrayList();
        this.mState = PlayState.IDLE;
        aIUIPlayer = this;
        bl = false;
        aIUIPlayer.mData = list = (List)new ArrayList();
        this.positiveDirection = true;
        this.mAutoSkipError = true;
        this.mAudioFocus = new AudioFocus(this.context, new AudioManager.OnAudioFocusChangeListener(this){
            final /* synthetic */ AIUIPlayer this$0;

            public final void onAudioFocusChange(int focusChange) {
                switch (focusChange) {
                    case -2: 
                    case -1: {
                        this.this$0.pause();
                        break;
                    }
                }
            }
            {
                this.this$0 = aIUIPlayer;
            }
        });
    }

    public static final /* synthetic */ boolean access$getMAutoSkipError$p(AIUIPlayer $this) {
        return $this.mAutoSkipError;
    }

    public static final /* synthetic */ void access$setMAutoSkipError$p(AIUIPlayer $this, boolean bl) {
        $this.mAutoSkipError = bl;
    }

    public static final /* synthetic */ boolean access$getPositiveDirection$p(AIUIPlayer $this) {
        return $this.positiveDirection;
    }

    public static final /* synthetic */ void access$setPositiveDirection$p(AIUIPlayer $this, boolean bl) {
        $this.positiveDirection = bl;
    }

    public static final /* synthetic */ void access$onStateError(AIUIPlayer $this, int error, String description) {
        $this.onStateError(error, description);
    }

    public static final /* synthetic */ int access$getMReadyCount$p(AIUIPlayer $this) {
        return $this.mReadyCount;
    }

    public static final /* synthetic */ void access$setMReadyCount$p(AIUIPlayer $this, int n) {
        $this.mReadyCount = n;
    }

    public static final /* synthetic */ List access$getMPlayers$p(AIUIPlayer $this) {
        return $this.mPlayers;
    }

    public static final /* synthetic */ void access$setMPlayers$p(AIUIPlayer $this, List list) {
        $this.mPlayers = list;
    }

    public static final /* synthetic */ void access$onStateChange(AIUIPlayer $this, PlayState state) {
        $this.onStateChange(state);
    }

    public static final /* synthetic */ void access$runMain(AIUIPlayer $this, Function0 action) {
        $this.runMain((Function0<Unit>)action);
    }

    public static final /* synthetic */ List access$getMListeners$p(AIUIPlayer $this) {
        return $this.mListeners;
    }

    public static final /* synthetic */ PlayState access$getMState$p(AIUIPlayer $this) {
        return $this.mState;
    }

    public static final /* synthetic */ void access$setMState$p(AIUIPlayer $this, PlayState playState) {
        $this.mState = playState;
    }

    public static final /* synthetic */ AudioFocus access$getMAudioFocus$p(AIUIPlayer $this) {
        return $this.mAudioFocus;
    }

    public static final /* synthetic */ void access$onComplete(AIUIPlayer $this) {
        $this.onComplete();
    }
}

