/*
 * Decompiled with CFR 0.152.
 */
package io.ahmer.utils.utilcode;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public final class NumberUtils {
    private static final ThreadLocal<DecimalFormat> DF_THREAD_LOCAL = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            return (DecimalFormat)NumberFormat.getInstance();
        }
    };

    private NumberUtils() {
        throw new UnsupportedOperationException("You can't instantiate me...");
    }

    public static DecimalFormat getSafeDecimalFormat() {
        return DF_THREAD_LOCAL.get();
    }

    public static String format(float value, int fractionDigits) {
        return NumberUtils.format(value, false, 1, fractionDigits, true);
    }

    public static String format(float value, int fractionDigits, boolean isHalfUp) {
        return NumberUtils.format(value, false, 1, fractionDigits, isHalfUp);
    }

    public static String format(float value, int minIntegerDigits, int fractionDigits, boolean isHalfUp) {
        return NumberUtils.format(value, false, minIntegerDigits, fractionDigits, isHalfUp);
    }

    public static String format(float value, boolean isGrouping, int fractionDigits) {
        return NumberUtils.format(value, isGrouping, 1, fractionDigits, true);
    }

    public static String format(float value, boolean isGrouping, int fractionDigits, boolean isHalfUp) {
        return NumberUtils.format(value, isGrouping, 1, fractionDigits, isHalfUp);
    }

    public static String format(float value, boolean isGrouping, int minIntegerDigits, int fractionDigits, boolean isHalfUp) {
        return NumberUtils.format(NumberUtils.float2Double(value), isGrouping, minIntegerDigits, fractionDigits, isHalfUp);
    }

    public static String format(double value, int fractionDigits) {
        return NumberUtils.format(value, false, 1, fractionDigits, true);
    }

    public static String format(double value, int fractionDigits, boolean isHalfUp) {
        return NumberUtils.format(value, false, 1, fractionDigits, isHalfUp);
    }

    public static String format(double value, int minIntegerDigits, int fractionDigits, boolean isHalfUp) {
        return NumberUtils.format(value, false, minIntegerDigits, fractionDigits, isHalfUp);
    }

    public static String format(double value, boolean isGrouping, int fractionDigits) {
        return NumberUtils.format(value, isGrouping, 1, fractionDigits, true);
    }

    public static String format(double value, boolean isGrouping, int fractionDigits, boolean isHalfUp) {
        return NumberUtils.format(value, isGrouping, 1, fractionDigits, isHalfUp);
    }

    public static String format(double value, boolean isGrouping, int minIntegerDigits, int fractionDigits, boolean isHalfUp) {
        DecimalFormat nf = NumberUtils.getSafeDecimalFormat();
        nf.setGroupingUsed(isGrouping);
        nf.setRoundingMode(isHalfUp ? RoundingMode.HALF_UP : RoundingMode.DOWN);
        nf.setMinimumIntegerDigits(minIntegerDigits);
        nf.setMinimumFractionDigits(fractionDigits);
        nf.setMaximumFractionDigits(fractionDigits);
        return nf.format(value);
    }

    public static double float2Double(float value) {
        return new BigDecimal(String.valueOf(value)).doubleValue();
    }
}

