/*
 * Decompiled with CFR 0.152.
 */
package io.ahmer.utils.utilcode;

import android.app.Activity;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import androidx.annotation.NonNull;
import io.ahmer.utils.utilcode.Utils;

public final class MetaDataUtils {
    private MetaDataUtils() {
        throw new UnsupportedOperationException("You can't instantiate me...");
    }

    public static String getMetaDataInApp(@NonNull String key) {
        String value = "";
        PackageManager pm = Utils.getApp().getPackageManager();
        String packageName = Utils.getApp().getPackageName();
        try {
            ApplicationInfo ai = pm.getApplicationInfo(packageName, 128);
            value = String.valueOf(ai.metaData.get(key));
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static String getMetaDataInActivity(@NonNull Activity activity, @NonNull String key) {
        return MetaDataUtils.getMetaDataInActivity(activity.getClass(), key);
    }

    public static String getMetaDataInActivity(@NonNull Class<? extends Activity> clz, @NonNull String key) {
        String value = "";
        PackageManager pm = Utils.getApp().getPackageManager();
        ComponentName componentName = new ComponentName((Context)Utils.getApp(), clz);
        try {
            ActivityInfo ai = pm.getActivityInfo(componentName, 128);
            value = String.valueOf(ai.metaData.get(key));
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static String getMetaDataInService(@NonNull Service service, @NonNull String key) {
        return MetaDataUtils.getMetaDataInService(service.getClass(), key);
    }

    public static String getMetaDataInService(@NonNull Class<? extends Service> clz, @NonNull String key) {
        String value = "";
        PackageManager pm = Utils.getApp().getPackageManager();
        ComponentName componentName = new ComponentName((Context)Utils.getApp(), clz);
        try {
            ServiceInfo info = pm.getServiceInfo(componentName, 128);
            value = String.valueOf(info.metaData.get(key));
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static String getMetaDataInReceiver(@NonNull BroadcastReceiver receiver, @NonNull String key) {
        return MetaDataUtils.getMetaDataInReceiver(receiver.getClass(), key);
    }

    public static String getMetaDataInReceiver(@NonNull Class<? extends BroadcastReceiver> clz, @NonNull String key) {
        String value = "";
        PackageManager pm = Utils.getApp().getPackageManager();
        ComponentName componentName = new ComponentName((Context)Utils.getApp(), clz);
        try {
            ActivityInfo info = pm.getReceiverInfo(componentName, 128);
            value = String.valueOf(info.metaData.get(key));
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return value;
    }
}

