/*
 * Decompiled with CFR 0.152.
 */
package io.ahmer.utils.utilcode;

import android.content.Context;
import android.graphics.Color;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import io.ahmer.utils.utilcode.Utils;

public final class ColorUtils {
    private ColorUtils() {
        throw new UnsupportedOperationException("You can't instantiate me...");
    }

    public static int getColor(@ColorRes int id2) {
        return ContextCompat.getColor((Context)Utils.getApp(), (int)id2);
    }

    public static int setAlphaComponent(@ColorInt int color2, @IntRange(from=0L, to=255L) int alpha) {
        return color2 & 0xFFFFFF | alpha << 24;
    }

    public static int setAlphaComponent(@ColorInt int color2, @FloatRange(from=0.0, to=1.0) float alpha) {
        return color2 & 0xFFFFFF | (int)(alpha * 255.0f + 0.5f) << 24;
    }

    public static int setRedComponent(@ColorInt int color2, @IntRange(from=0L, to=255L) int red) {
        return color2 & 0xFF00FFFF | red << 16;
    }

    public static int setRedComponent(@ColorInt int color2, @FloatRange(from=0.0, to=1.0) float red) {
        return color2 & 0xFF00FFFF | (int)(red * 255.0f + 0.5f) << 16;
    }

    public static int setGreenComponent(@ColorInt int color2, @IntRange(from=0L, to=255L) int green) {
        return color2 & 0xFFFF00FF | green << 8;
    }

    public static int setGreenComponent(@ColorInt int color2, @FloatRange(from=0.0, to=1.0) float green) {
        return color2 & 0xFFFF00FF | (int)(green * 255.0f + 0.5f) << 8;
    }

    public static int setBlueComponent(@ColorInt int color2, @IntRange(from=0L, to=255L) int blue) {
        return color2 & 0xFFFFFF00 | blue;
    }

    public static int setBlueComponent(@ColorInt int color2, @FloatRange(from=0.0, to=1.0) float blue) {
        return color2 & 0xFFFFFF00 | (int)(blue * 255.0f + 0.5f);
    }

    public static int string2Int(@NonNull String colorString) {
        return Color.parseColor((String)colorString);
    }

    public static String int2RgbString(@ColorInt int colorInt) {
        String color2 = Integer.toHexString(colorInt &= 0xFFFFFF);
        while (color2.length() < 6) {
            color2 = "0" + color2;
        }
        return "#" + color2;
    }

    public static String int2ArgbString(@ColorInt int colorInt) {
        String color2 = Integer.toHexString(colorInt);
        while (color2.length() < 6) {
            color2 = "0" + color2;
        }
        while (color2.length() < 8) {
            color2 = "f" + color2;
        }
        return "#" + color2;
    }

    public static int getRandomColor() {
        return ColorUtils.getRandomColor(true);
    }

    public static int getRandomColor(boolean supportAlpha) {
        int high = supportAlpha ? (int)(Math.random() * 256.0) << 24 : -16777216;
        return high | (int)(Math.random() * 1.6777216E7);
    }

    public static boolean isLightColor(@ColorInt int color2) {
        return 0.299 * (double)Color.red((int)color2) + 0.587 * (double)Color.green((int)color2) + 0.114 * (double)Color.blue((int)color2) >= 127.5;
    }
}

