/*
 * Decompiled with CFR 0.152.
 */
package io.ahmer.utils.imageview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.appcompat.widget.AppCompatImageView;
import io.ahmer.utils.R;

public class CircleImageView
extends AppCompatImageView {
    private static final ImageView.ScaleType SCALE_TYPE = ImageView.ScaleType.CENTER_CROP;
    private static final Bitmap.Config BITMAP_CONFIG = Bitmap.Config.ARGB_8888;
    private static final int COLORDRAWABLE_DIMENSION = 2;
    private static final int DEFAULT_BORDER_WIDTH = 0;
    private static final int DEFAULT_BORDER_COLOR = -16777216;
    private static final int DEFAULT_CIRCLE_BACKGROUND_COLOR = 0;
    private static final int DEFAULT_IMAGE_ALPHA = 255;
    private static final boolean DEFAULT_BORDER_OVERLAY = false;
    private final RectF mDrawableRect = new RectF();
    private final RectF mBorderRect = new RectF();
    private final Matrix mShaderMatrix = new Matrix();
    private final Paint mBitmapPaint = new Paint();
    private final Paint mBorderPaint = new Paint();
    private final Paint mCircleBackgroundPaint = new Paint();
    private int mBorderColor = -16777216;
    private int mBorderWidth = 0;
    private int mCircleBackgroundColor = 0;
    private int mImageAlpha = 255;
    private Bitmap mBitmap;
    private Canvas mBitmapCanvas;
    private float mDrawableRadius;
    private float mBorderRadius;
    private ColorFilter mColorFilter;
    private boolean mInitialized;
    private boolean mRebuildShader;
    private boolean mDrawableDirty;
    private boolean mBorderOverlay;
    private boolean mDisableCircularTransformation;

    public CircleImageView(Context context) {
        super(context);
        this.init();
    }

    public CircleImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CircleImageView, defStyle, 0);
        this.mBorderWidth = a.getDimensionPixelSize(R.styleable.CircleImageView_civ_border_width, 0);
        this.mBorderColor = a.getColor(R.styleable.CircleImageView_civ_border_color, -16777216);
        this.mBorderOverlay = a.getBoolean(R.styleable.CircleImageView_civ_border_overlay, false);
        this.mCircleBackgroundColor = a.getColor(R.styleable.CircleImageView_civ_circle_background_color, 0);
        a.recycle();
        this.init();
    }

    private void init() {
        this.mInitialized = true;
        super.setScaleType(SCALE_TYPE);
        this.mBitmapPaint.setAntiAlias(true);
        this.mBitmapPaint.setDither(true);
        this.mBitmapPaint.setFilterBitmap(true);
        this.mBitmapPaint.setAlpha(this.mImageAlpha);
        this.mBitmapPaint.setColorFilter(this.mColorFilter);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setColor(this.mBorderColor);
        this.mBorderPaint.setStrokeWidth((float)this.mBorderWidth);
        this.mCircleBackgroundPaint.setStyle(Paint.Style.FILL);
        this.mCircleBackgroundPaint.setAntiAlias(true);
        this.mCircleBackgroundPaint.setColor(this.mCircleBackgroundColor);
        if (Build.VERSION.SDK_INT >= 21) {
            this.setOutlineProvider(new OutlineProvider());
        }
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        if (scaleType != SCALE_TYPE) {
            throw new IllegalArgumentException(String.format("ScaleType %s not supported.", scaleType));
        }
    }

    public void setAdjustViewBounds(boolean adjustViewBounds) {
        if (adjustViewBounds) {
            throw new IllegalArgumentException("adjustViewBounds not supported.");
        }
    }

    @SuppressLint(value={"CanvasSize"})
    protected void onDraw(Canvas canvas) {
        if (this.mDisableCircularTransformation) {
            super.onDraw(canvas);
            return;
        }
        if (this.mCircleBackgroundColor != 0) {
            canvas.drawCircle(this.mDrawableRect.centerX(), this.mDrawableRect.centerY(), this.mDrawableRadius, this.mCircleBackgroundPaint);
        }
        if (this.mBitmap != null) {
            if (this.mDrawableDirty && this.mBitmapCanvas != null) {
                this.mDrawableDirty = false;
                Drawable drawable = this.getDrawable();
                drawable.setBounds(0, 0, this.mBitmapCanvas.getWidth(), this.mBitmapCanvas.getHeight());
                drawable.draw(this.mBitmapCanvas);
            }
            if (this.mRebuildShader) {
                this.mRebuildShader = false;
                BitmapShader bitmapShader = new BitmapShader(this.mBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                bitmapShader.setLocalMatrix(this.mShaderMatrix);
                this.mBitmapPaint.setShader((Shader)bitmapShader);
            }
            canvas.drawCircle(this.mDrawableRect.centerX(), this.mDrawableRect.centerY(), this.mDrawableRadius, this.mBitmapPaint);
        }
        if (this.mBorderWidth > 0) {
            canvas.drawCircle(this.mBorderRect.centerX(), this.mBorderRect.centerY(), this.mBorderRadius, this.mBorderPaint);
        }
    }

    public void invalidateDrawable(@NonNull Drawable dr) {
        this.mDrawableDirty = true;
        this.invalidate();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.updateDimensions();
        this.invalidate();
    }

    public void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
        this.updateDimensions();
        this.invalidate();
    }

    public void setPaddingRelative(int start, int top, int end, int bottom) {
        super.setPaddingRelative(start, top, end, bottom);
        this.updateDimensions();
        this.invalidate();
    }

    public int getBorderColor() {
        return this.mBorderColor;
    }

    public void setBorderColor(@ColorInt int borderColor) {
        if (borderColor == this.mBorderColor) {
            return;
        }
        this.mBorderColor = borderColor;
        this.mBorderPaint.setColor(borderColor);
        this.invalidate();
    }

    public int getCircleBackgroundColor() {
        return this.mCircleBackgroundColor;
    }

    public void setCircleBackgroundColor(@ColorInt int circleBackgroundColor) {
        if (circleBackgroundColor == this.mCircleBackgroundColor) {
            return;
        }
        this.mCircleBackgroundColor = circleBackgroundColor;
        this.mCircleBackgroundPaint.setColor(circleBackgroundColor);
        this.invalidate();
    }

    @Deprecated
    public void setCircleBackgroundColorResource(@ColorRes int circleBackgroundRes) {
        this.setCircleBackgroundColor(this.getContext().getResources().getColor(circleBackgroundRes));
    }

    public int getBorderWidth() {
        return this.mBorderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        if (borderWidth == this.mBorderWidth) {
            return;
        }
        this.mBorderWidth = borderWidth;
        this.mBorderPaint.setStrokeWidth((float)borderWidth);
        this.updateDimensions();
        this.invalidate();
    }

    public boolean isBorderOverlay() {
        return this.mBorderOverlay;
    }

    public void setBorderOverlay(boolean borderOverlay) {
        if (borderOverlay == this.mBorderOverlay) {
            return;
        }
        this.mBorderOverlay = borderOverlay;
        this.updateDimensions();
        this.invalidate();
    }

    public boolean isDisableCircularTransformation() {
        return this.mDisableCircularTransformation;
    }

    public void setDisableCircularTransformation(boolean disableCircularTransformation) {
        if (disableCircularTransformation == this.mDisableCircularTransformation) {
            return;
        }
        this.mDisableCircularTransformation = disableCircularTransformation;
        if (disableCircularTransformation) {
            this.mBitmap = null;
            this.mBitmapCanvas = null;
            this.mBitmapPaint.setShader(null);
        } else {
            this.initializeBitmap();
        }
        this.invalidate();
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.initializeBitmap();
        this.invalidate();
    }

    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
        this.initializeBitmap();
        this.invalidate();
    }

    public void setImageResource(@DrawableRes int resId) {
        super.setImageResource(resId);
        this.initializeBitmap();
        this.invalidate();
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.initializeBitmap();
        this.invalidate();
    }

    public int getImageAlpha() {
        return this.mImageAlpha;
    }

    public void setImageAlpha(int alpha) {
        if ((alpha &= 0xFF) == this.mImageAlpha) {
            return;
        }
        this.mImageAlpha = alpha;
        if (this.mInitialized) {
            this.mBitmapPaint.setAlpha(alpha);
            this.invalidate();
        }
    }

    public ColorFilter getColorFilter() {
        return this.mColorFilter;
    }

    public void setColorFilter(ColorFilter cf) {
        if (cf == this.mColorFilter) {
            return;
        }
        this.mColorFilter = cf;
        if (this.mInitialized) {
            this.mBitmapPaint.setColorFilter(cf);
            this.invalidate();
        }
    }

    private Bitmap getBitmapFromDrawable(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        try {
            Bitmap bitmap = drawable instanceof ColorDrawable ? Bitmap.createBitmap((int)2, (int)2, (Bitmap.Config)BITMAP_CONFIG) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)BITMAP_CONFIG);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void initializeBitmap() {
        this.mBitmap = this.getBitmapFromDrawable(this.getDrawable());
        this.mBitmapCanvas = this.mBitmap != null && this.mBitmap.isMutable() ? new Canvas(this.mBitmap) : null;
        if (!this.mInitialized) {
            return;
        }
        if (this.mBitmap != null) {
            this.updateShaderMatrix();
        } else {
            this.mBitmapPaint.setShader(null);
        }
    }

    private void updateDimensions() {
        this.mBorderRect.set(this.calculateBounds());
        this.mBorderRadius = Math.min((this.mBorderRect.height() - (float)this.mBorderWidth) / 2.0f, (this.mBorderRect.width() - (float)this.mBorderWidth) / 2.0f);
        this.mDrawableRect.set(this.mBorderRect);
        if (!this.mBorderOverlay && this.mBorderWidth > 0) {
            this.mDrawableRect.inset((float)this.mBorderWidth - 1.0f, (float)this.mBorderWidth - 1.0f);
        }
        this.mDrawableRadius = Math.min(this.mDrawableRect.height() / 2.0f, this.mDrawableRect.width() / 2.0f);
        this.updateShaderMatrix();
    }

    private RectF calculateBounds() {
        int availableWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int availableHeight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int sideLength = Math.min(availableWidth, availableHeight);
        float left = (float)this.getPaddingLeft() + (float)(availableWidth - sideLength) / 2.0f;
        float top = (float)this.getPaddingTop() + (float)(availableHeight - sideLength) / 2.0f;
        return new RectF(left, top, left + (float)sideLength, top + (float)sideLength);
    }

    private void updateShaderMatrix() {
        float scale;
        if (this.mBitmap == null) {
            return;
        }
        float dx = 0.0f;
        float dy = 0.0f;
        this.mShaderMatrix.set(null);
        int bitmapHeight = this.mBitmap.getHeight();
        int bitmapWidth = this.mBitmap.getWidth();
        if ((float)bitmapWidth * this.mDrawableRect.height() > this.mDrawableRect.width() * (float)bitmapHeight) {
            scale = this.mDrawableRect.height() / (float)bitmapHeight;
            dx = (this.mDrawableRect.width() - (float)bitmapWidth * scale) * 0.5f;
        } else {
            scale = this.mDrawableRect.width() / (float)bitmapWidth;
            dy = (this.mDrawableRect.height() - (float)bitmapHeight * scale) * 0.5f;
        }
        this.mShaderMatrix.setScale(scale, scale);
        this.mShaderMatrix.postTranslate((float)((int)(dx + 0.5f)) + this.mDrawableRect.left, (float)((int)(dy + 0.5f)) + this.mDrawableRect.top);
        this.mRebuildShader = true;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (this.mDisableCircularTransformation) {
            return super.onTouchEvent(event);
        }
        return this.inTouchableArea(event.getX(), event.getY()) && super.onTouchEvent(event);
    }

    private boolean inTouchableArea(float x, float y) {
        if (this.mBorderRect.isEmpty()) {
            return true;
        }
        return Math.pow(x - this.mBorderRect.centerX(), 2.0) + Math.pow(y - this.mBorderRect.centerY(), 2.0) <= Math.pow(this.mBorderRadius, 2.0);
    }

    @RequiresApi(api=21)
    private class OutlineProvider
    extends ViewOutlineProvider {
        private OutlineProvider() {
        }

        public void getOutline(View view, Outline outline) {
            if (CircleImageView.this.mDisableCircularTransformation) {
                ViewOutlineProvider.BACKGROUND.getOutline(view, outline);
            } else {
                Rect bounds = new Rect();
                CircleImageView.this.mBorderRect.roundOut(bounds);
                outline.setRoundRect(bounds, (float)bounds.width() / 2.0f);
            }
        }
    }
}

