/*
 * Decompiled with CFR 0.152.
 */
package io.ahmer.utils.utilcode;

import android.os.Build;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import io.ahmer.utils.utilcode.Utils;
import io.ahmer.utils.utilcode.UtilsBridge;
import java.util.Locale;

public class ViewUtils {
    public static void setViewEnabled(View view, boolean enabled) {
        ViewUtils.setViewEnabled(view, enabled, new View[]{null});
    }

    public static void setViewEnabled(View view, boolean enabled, View ... excludes) {
        if (view == null) {
            return;
        }
        if (excludes != null) {
            for (View exclude : excludes) {
                if (view != exclude) continue;
                return;
            }
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int childCount = viewGroup.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                ViewUtils.setViewEnabled(viewGroup.getChildAt(i), enabled, excludes);
            }
        }
        view.setEnabled(enabled);
    }

    public static void runOnUiThread(Runnable runnable) {
        UtilsBridge.runOnUiThread(runnable);
    }

    public static void runOnUiThreadDelayed(Runnable runnable, long delayMillis) {
        UtilsBridge.runOnUiThreadDelayed(runnable, delayMillis);
    }

    public static boolean isLayoutRtl() {
        if (Build.VERSION.SDK_INT >= 17) {
            Locale primaryLocale = Build.VERSION.SDK_INT >= 24 ? Utils.getApp().getResources().getConfiguration().getLocales().get(0) : Utils.getApp().getResources().getConfiguration().locale;
            return TextUtils.getLayoutDirectionFromLocale((Locale)primaryLocale) == 1;
        }
        return false;
    }

    public static void fixScrollViewTopping(View view) {
        view.setFocusable(false);
        ViewGroup viewGroup = null;
        if (view instanceof ViewGroup) {
            viewGroup = (ViewGroup)view;
        }
        if (viewGroup == null) {
            return;
        }
        int n = viewGroup.getChildCount();
        for (int i = 0; i < n; ++i) {
            View childAt = viewGroup.getChildAt(i);
            childAt.setFocusable(false);
            if (!(childAt instanceof ViewGroup)) continue;
            ViewUtils.fixScrollViewTopping(childAt);
        }
    }

    public static View layoutId2View(@LayoutRes int layoutId) {
        LayoutInflater inflate = (LayoutInflater)Utils.getApp().getSystemService("layout_inflater");
        return inflate.inflate(layoutId, null);
    }
}

