/*
 * Decompiled with CFR 0.152.
 */
package io.ahmer.utils.utilcode;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.util.Log;
import android.util.Pair;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import io.ahmer.utils.constants.PermissionConstants;
import io.ahmer.utils.utilcode.Utils;
import io.ahmer.utils.utilcode.UtilsBridge;
import io.ahmer.utils.utilcode.UtilsTransActivity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class PermissionUtils {
    private static PermissionUtils sInstance;
    private static SimpleCallback sSimpleCallback4WriteSettings;
    private static SimpleCallback sSimpleCallback4DrawOverlays;
    private String[] mPermissionsParam;
    private OnExplainListener mOnExplainListener;
    private OnRationaleListener mOnRationaleListener;
    private SingleCallback mSingleCallback;
    private SimpleCallback mSimpleCallback;
    private FullCallback mFullCallback;
    private ThemeCallback mThemeCallback;
    private Set<String> mPermissions;
    private List<String> mPermissionsRequest;
    private List<String> mPermissionsGranted;
    private List<String> mPermissionsDenied;
    private List<String> mPermissionsDeniedForever;

    private PermissionUtils(String ... permissions) {
        this.mPermissionsParam = permissions;
        sInstance = this;
    }

    public static List<String> getPermissions() {
        return PermissionUtils.getPermissions(Utils.getApp().getPackageName());
    }

    public static List<String> getPermissions(String packageName) {
        PackageManager pm = Utils.getApp().getPackageManager();
        try {
            String[] permissions = pm.getPackageInfo((String)packageName, (int)4096).requestedPermissions;
            if (permissions == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(permissions);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public static boolean isGranted(String ... permissions) {
        Pair<List<String>, List<String>> requestAndDeniedPermissions = PermissionUtils.getRequestAndDeniedPermissions(permissions);
        List deniedPermissions = (List)requestAndDeniedPermissions.second;
        if (!deniedPermissions.isEmpty()) {
            return false;
        }
        List requestPermissions = (List)requestAndDeniedPermissions.first;
        for (String permission2 : requestPermissions) {
            if (PermissionUtils.isGranted(permission2)) continue;
            return false;
        }
        return true;
    }

    private static Pair<List<String>, List<String>> getRequestAndDeniedPermissions(String ... permissionsParam) {
        ArrayList<String> requestPermissions = new ArrayList<String>();
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        List<String> appPermissions = PermissionUtils.getPermissions();
        for (String param : permissionsParam) {
            String[] permissions;
            boolean isIncludeInManifest = false;
            for (String permission2 : permissions = PermissionConstants.getPermissions(param)) {
                if (!appPermissions.contains(permission2)) continue;
                requestPermissions.add(permission2);
                isIncludeInManifest = true;
            }
            if (isIncludeInManifest) continue;
            deniedPermissions.add(param);
            Log.e((String)"PermissionUtils", (String)("You should add the permission of " + param + " in manifest."));
        }
        return Pair.create(requestPermissions, deniedPermissions);
    }

    private static boolean isGranted(String permission2) {
        return Build.VERSION.SDK_INT < 23 || 0 == ContextCompat.checkSelfPermission((Context)Utils.getApp(), (String)permission2);
    }

    @RequiresApi(api=23)
    public static boolean isGrantedWriteSettings() {
        return Settings.System.canWrite((Context)Utils.getApp());
    }

    @RequiresApi(api=23)
    public static void requestWriteSettings(SimpleCallback callback) {
        if (PermissionUtils.isGrantedWriteSettings()) {
            if (callback != null) {
                callback.onGranted();
            }
            return;
        }
        sSimpleCallback4WriteSettings = callback;
        PermissionActivityImpl.start(2);
    }

    @TargetApi(value=23)
    private static void startWriteSettingsActivity(Activity activity, int requestCode) {
        Intent intent = new Intent("android.settings.action.MANAGE_WRITE_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + Utils.getApp().getPackageName())));
        if (!UtilsBridge.isIntentAvailable(intent)) {
            PermissionUtils.launchAppDetailsSettings();
            return;
        }
        activity.startActivityForResult(intent, requestCode);
    }

    @RequiresApi(api=23)
    public static boolean isGrantedDrawOverlays() {
        return Settings.canDrawOverlays((Context)Utils.getApp());
    }

    @RequiresApi(api=23)
    public static void requestDrawOverlays(SimpleCallback callback) {
        if (PermissionUtils.isGrantedDrawOverlays()) {
            if (callback != null) {
                callback.onGranted();
            }
            return;
        }
        sSimpleCallback4DrawOverlays = callback;
        PermissionActivityImpl.start(3);
    }

    @TargetApi(value=23)
    private static void startOverlayPermissionActivity(Activity activity, int requestCode) {
        Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
        intent.setData(Uri.parse((String)("package:" + Utils.getApp().getPackageName())));
        if (!UtilsBridge.isIntentAvailable(intent)) {
            PermissionUtils.launchAppDetailsSettings();
            return;
        }
        activity.startActivityForResult(intent, requestCode);
    }

    public static void launchAppDetailsSettings() {
        Intent intent = UtilsBridge.getLaunchAppDetailsSettingsIntent(Utils.getApp().getPackageName(), true);
        if (!UtilsBridge.isIntentAvailable(intent)) {
            return;
        }
        Utils.getApp().startActivity(intent);
    }

    public static PermissionUtils permissionGroup(String ... permissions) {
        return PermissionUtils.permission(permissions);
    }

    public static PermissionUtils permission(String ... permissions) {
        return new PermissionUtils(permissions);
    }

    public PermissionUtils explain(OnExplainListener listener) {
        this.mOnExplainListener = listener;
        return this;
    }

    public PermissionUtils rationale(OnRationaleListener listener) {
        this.mOnRationaleListener = listener;
        return this;
    }

    public PermissionUtils callback(SingleCallback callback) {
        this.mSingleCallback = callback;
        return this;
    }

    public PermissionUtils callback(SimpleCallback callback) {
        this.mSimpleCallback = callback;
        return this;
    }

    public PermissionUtils callback(FullCallback callback) {
        this.mFullCallback = callback;
        return this;
    }

    public PermissionUtils theme(ThemeCallback callback) {
        this.mThemeCallback = callback;
        return this;
    }

    public void request() {
        if (this.mPermissionsParam == null || this.mPermissionsParam.length <= 0) {
            Log.w((String)"PermissionUtils", (String)"No permissions to request.");
            return;
        }
        this.mPermissions = new LinkedHashSet<String>();
        this.mPermissionsRequest = new ArrayList<String>();
        this.mPermissionsGranted = new ArrayList<String>();
        this.mPermissionsDenied = new ArrayList<String>();
        this.mPermissionsDeniedForever = new ArrayList<String>();
        Pair<List<String>, List<String>> requestAndDeniedPermissions = PermissionUtils.getRequestAndDeniedPermissions(this.mPermissionsParam);
        this.mPermissions.addAll((Collection)requestAndDeniedPermissions.first);
        this.mPermissionsDenied.addAll((Collection)requestAndDeniedPermissions.second);
        if (Build.VERSION.SDK_INT < 23) {
            this.mPermissionsGranted.addAll(this.mPermissions);
            this.requestCallback();
        } else {
            for (String permission2 : this.mPermissions) {
                if (PermissionUtils.isGranted(permission2)) {
                    this.mPermissionsGranted.add(permission2);
                    continue;
                }
                this.mPermissionsRequest.add(permission2);
            }
            if (this.mPermissionsRequest.isEmpty()) {
                this.requestCallback();
            } else {
                this.startPermissionActivity();
            }
        }
    }

    @RequiresApi(api=23)
    private void startPermissionActivity() {
        PermissionActivityImpl.start(1);
    }

    @RequiresApi(api=23)
    private boolean shouldRationale(UtilsTransActivity activity, Runnable againRunnable) {
        boolean isRationale = false;
        if (this.mOnRationaleListener != null) {
            for (String permission2 : this.mPermissionsRequest) {
                if (!activity.shouldShowRequestPermissionRationale(permission2)) continue;
                this.rationalInner(activity, againRunnable);
                isRationale = true;
                break;
            }
            this.mOnRationaleListener = null;
        }
        return isRationale;
    }

    private void rationalInner(final UtilsTransActivity activity, final Runnable againRunnable) {
        this.getPermissionsStatus((Activity)activity);
        this.mOnRationaleListener.rationale(activity, new OnRationaleListener.ShouldRequest(){

            @Override
            public void again(boolean again) {
                if (again) {
                    PermissionUtils.this.mPermissionsDenied = new ArrayList<String>();
                    PermissionUtils.this.mPermissionsDeniedForever = new ArrayList<String>();
                    againRunnable.run();
                } else {
                    activity.finish();
                    PermissionUtils.this.requestCallback();
                }
            }
        });
    }

    private void getPermissionsStatus(Activity activity) {
        for (String permission2 : this.mPermissionsRequest) {
            if (PermissionUtils.isGranted(permission2)) {
                this.mPermissionsGranted.add(permission2);
                continue;
            }
            this.mPermissionsDenied.add(permission2);
            if (activity.shouldShowRequestPermissionRationale(permission2)) continue;
            this.mPermissionsDeniedForever.add(permission2);
        }
    }

    private void requestCallback() {
        if (this.mSingleCallback != null) {
            this.mSingleCallback.callback(this.mPermissionsDenied.isEmpty(), this.mPermissionsGranted, this.mPermissionsDeniedForever, this.mPermissionsDenied);
            this.mSingleCallback = null;
        }
        if (this.mSimpleCallback != null) {
            if (this.mPermissionsDenied.isEmpty()) {
                this.mSimpleCallback.onGranted();
            } else {
                this.mSimpleCallback.onDenied();
            }
            this.mSimpleCallback = null;
        }
        if (this.mFullCallback != null) {
            if (this.mPermissionsRequest.size() == 0 || this.mPermissionsGranted.size() > 0) {
                this.mFullCallback.onGranted(this.mPermissionsGranted);
            }
            if (!this.mPermissionsDenied.isEmpty()) {
                this.mFullCallback.onDenied(this.mPermissionsDeniedForever, this.mPermissionsDenied);
            }
            this.mFullCallback = null;
        }
        this.mOnRationaleListener = null;
        this.mThemeCallback = null;
    }

    private void onRequestPermissionsResult(Activity activity) {
        this.getPermissionsStatus(activity);
        this.requestCallback();
    }

    @RequiresApi(api=23)
    static final class PermissionActivityImpl
    extends UtilsTransActivity.TransActivityDelegate {
        private static final String TYPE = "TYPE";
        private static final int TYPE_RUNTIME = 1;
        private static final int TYPE_WRITE_SETTINGS = 2;
        private static final int TYPE_DRAW_OVERLAYS = 3;
        private static int currentRequestCode = -1;
        private static PermissionActivityImpl INSTANCE = new PermissionActivityImpl();

        PermissionActivityImpl() {
        }

        public static void start(final int type) {
            UtilsTransActivity.start(new Utils.Consumer<Intent>(){

                @Override
                public void accept(Intent data) {
                    data.putExtra(PermissionActivityImpl.TYPE, type);
                }
            }, (UtilsTransActivity.TransActivityDelegate)INSTANCE);
        }

        @Override
        public void onCreated(final @NonNull UtilsTransActivity activity, @Nullable Bundle savedInstanceState) {
            activity.getWindow().addFlags(262160);
            int type = activity.getIntent().getIntExtra(TYPE, -1);
            if (type == 1) {
                if (sInstance == null) {
                    Log.e((String)"PermissionUtils", (String)"sInstance is null.");
                    activity.finish();
                    return;
                }
                if (PermissionUtils.sInstance.mPermissionsRequest == null) {
                    Log.e((String)"PermissionUtils", (String)"mPermissionsRequest is null.");
                    activity.finish();
                    return;
                }
                if (PermissionUtils.sInstance.mPermissionsRequest.size() <= 0) {
                    Log.e((String)"PermissionUtils", (String)"mPermissionsRequest's size is no more than 0.");
                    activity.finish();
                    return;
                }
                if (PermissionUtils.sInstance.mThemeCallback != null) {
                    PermissionUtils.sInstance.mThemeCallback.onActivityCreate((Activity)activity);
                }
                if (PermissionUtils.sInstance.mOnExplainListener != null) {
                    PermissionUtils.sInstance.mOnExplainListener.explain(activity, PermissionUtils.sInstance.mPermissionsRequest, new OnExplainListener.ShouldRequest(){

                        @Override
                        public void start(boolean start) {
                            if (!start) {
                                activity.finish();
                            } else {
                                this.requestPermissions(activity);
                            }
                        }
                    });
                    PermissionUtils.sInstance.mOnExplainListener = null;
                    return;
                }
                this.requestPermissions(activity);
            } else if (type == 2) {
                currentRequestCode = 2;
                PermissionUtils.startWriteSettingsActivity((Activity)activity, 2);
            } else if (type == 3) {
                currentRequestCode = 3;
                PermissionUtils.startOverlayPermissionActivity((Activity)activity, 3);
            } else {
                activity.finish();
                Log.e((String)"PermissionUtils", (String)"type is wrong.");
            }
        }

        private void requestPermissions(final UtilsTransActivity activity) {
            if (sInstance.shouldRationale(activity, new Runnable(){

                @Override
                public void run() {
                    activity.requestPermissions(PermissionUtils.sInstance.mPermissionsRequest.toArray(new String[0]), 1);
                }
            })) {
                return;
            }
            activity.requestPermissions(PermissionUtils.sInstance.mPermissionsRequest.toArray(new String[0]), 1);
        }

        @Override
        public void onRequestPermissionsResult(@NonNull UtilsTransActivity activity, int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
            activity.finish();
            if (sInstance != null && PermissionUtils.sInstance.mPermissionsRequest != null) {
                sInstance.onRequestPermissionsResult((Activity)activity);
            }
        }

        @Override
        public boolean dispatchTouchEvent(@NonNull UtilsTransActivity activity, MotionEvent ev) {
            activity.finish();
            return true;
        }

        @Override
        public void onDestroy(@NonNull UtilsTransActivity activity) {
            if (currentRequestCode != -1) {
                this.checkRequestCallback(currentRequestCode);
                currentRequestCode = -1;
            }
            super.onDestroy(activity);
        }

        @Override
        public void onActivityResult(@NonNull UtilsTransActivity activity, int requestCode, int resultCode, Intent data) {
            activity.finish();
        }

        private void checkRequestCallback(int requestCode) {
            if (requestCode == 2) {
                if (sSimpleCallback4WriteSettings == null) {
                    return;
                }
                if (PermissionUtils.isGrantedWriteSettings()) {
                    sSimpleCallback4WriteSettings.onGranted();
                } else {
                    sSimpleCallback4WriteSettings.onDenied();
                }
                sSimpleCallback4WriteSettings = null;
            } else if (requestCode == 3) {
                if (sSimpleCallback4DrawOverlays == null) {
                    return;
                }
                if (PermissionUtils.isGrantedDrawOverlays()) {
                    sSimpleCallback4DrawOverlays.onGranted();
                } else {
                    sSimpleCallback4DrawOverlays.onDenied();
                }
                sSimpleCallback4DrawOverlays = null;
            }
        }
    }

    public static interface ThemeCallback {
        public void onActivityCreate(@NonNull Activity var1);
    }

    public static interface FullCallback {
        public void onGranted(@NonNull List<String> var1);

        public void onDenied(@NonNull List<String> var1, @NonNull List<String> var2);
    }

    public static interface SimpleCallback {
        public void onGranted();

        public void onDenied();
    }

    public static interface SingleCallback {
        public void callback(boolean var1, @NonNull List<String> var2, @NonNull List<String> var3, @NonNull List<String> var4);
    }

    public static interface OnRationaleListener {
        public void rationale(@NonNull UtilsTransActivity var1, @NonNull ShouldRequest var2);

        public static interface ShouldRequest {
            public void again(boolean var1);
        }
    }

    public static interface OnExplainListener {
        public void explain(@NonNull UtilsTransActivity var1, @NonNull List<String> var2, @NonNull ShouldRequest var3);

        public static interface ShouldRequest {
            public void start(boolean var1);
        }
    }
}

