package io.ahmer.utils;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.view.View;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.core.content.ContextCompat;

import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;

import io.ahmer.utils.constants.AppPackageConstants;
import io.ahmer.utils.utilcode.AppUtils;
import io.ahmer.utils.utilcode.DeviceUtils;
import io.ahmer.utils.utilcode.NetworkUtils;
import io.ahmer.utils.utilcode.SnackbarUtils;
import io.ahmer.utils.utilcode.ThrowableUtils;
import io.ahmer.utils.utilcode.ToastUtils;
import io.ahmer.utils.utilcode.Utils;

public class HelperUtils extends AppCompatActivity {

    public static void clipBoardCopied(Context context, TextView text) {
        ClipboardManager clipboardManager = (ClipboardManager) context.getSystemService(Context.CLIPBOARD_SERVICE);
        ClipData clipData = ClipData.newPlainText("text", text.getText());
        assert clipboardManager != null;
        clipboardManager.setPrimaryClip(clipData);
        ToastUtils.showShort(context.getString(R.string.text_copied));
    }

    public static void openCustomTabs(Context context, String url) {
        CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder();
        builder.setColorScheme(ContextCompat.getColor(context, R.color.colorPrimary));
        builder.setShowTitle(true);
        CustomTabsIntent customTabsIntent = builder.build();
        customTabsIntent.launchUrl(context, Uri.parse(url));
    }

    public static void showNoInternetSnack(Activity activity) {
        View view = activity.findViewById(android.R.id.content);
        if (NetworkUtils.isConnected()) {
            SnackbarUtils.with(view)
                    .setDuration(SnackbarUtils.LENGTH_LONG)
                    .setMessage(activity.getResources().getString(R.string.internet_connected))
                    .showSuccess();
        } else {
            SnackbarUtils.with(view)
                    .setDuration(SnackbarUtils.LENGTH_LONG)
                    .setMessage(activity.getResources().getString(R.string.internet_connection_no))
                    .showWarning();
        }
    }

    public static void appShareOrEmail(Context context, boolean flag, String msgForShareApp, String appName) {
        try {
            Utils.getApp().getPackageName();
        } catch (Exception e) {
            ThrowableUtils.getFullStackTrace(e);
        }
        Intent intent = new Intent(Intent.ACTION_SEND);
        intent.setType("message/rfc822");
        //If true its share app else email app
        String s;
        if (flag) {
            s = "\n\n\n" + context.getResources().getString(R.string.auto_generate_msg)
                    + msgForShareApp
                    + "\n" + context.getResources().getString(R.string.email_ahmer_yahoo);
            intent.putExtra(Intent.EXTRA_SUBJECT, appName);
        } else {
            s = "\n\n\n" + context.getResources().getString(R.string.auto_generate_msg)
                    + "\n\nApp Version: " + AppUtils.getAppVersionName()
                    + "\nManufacturer: " + DeviceUtils.getModel()
                    + "\nBrand: " + DeviceUtils.getManufacturer()
                    + "\nProduct: " + DeviceUtils.getProduct()
                    + "\nArchitecture: " + DeviceUtils.getArchitectureOS()
                    + "\nHardware: " + DeviceUtils.getHardware()
                    + "\nID: " + DeviceUtils.getId()
                    + "\nOS Version: " + DeviceUtils.getSDKVersionName()
                    + "\nOS API Level: " + DeviceUtils.getSDKVersionCode();
            intent.putExtra(Intent.EXTRA_EMAIL, new String[]{context.getResources().getString(R.string.email_ahmer_yahoo)});
            intent.putExtra(Intent.EXTRA_CC, new String[]{context.getResources().getString(R.string.email_ahmer_gmail)});
            intent.putExtra(Intent.EXTRA_SUBJECT, context.getResources().getString(R.string.send_email_to_author));
        }
        final PackageManager pm = Utils.getApp().getPackageManager();
        final List<ResolveInfo> matches = pm.queryIntentActivities(intent, 0);
        String className = null;
        for (final ResolveInfo info : matches) {
            if (info.activityInfo.packageName.equals(AppPackageConstants.PKG_GMAIL)) {
                className = info.activityInfo.name;
                if (className != null && !className.isEmpty()) {
                    break;
                }
            }
        }
        intent.setClassName(AppPackageConstants.PKG_GMAIL, Objects.requireNonNull(className));
        intent.putExtra(Intent.EXTRA_TEXT, s);
        intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_SINGLE_TOP);
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.N || Build.VERSION.SDK_INT >= Build.VERSION_CODES.P) {
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        }
        try {
            if (intent.resolveActivity(Utils.getApp().getPackageManager()) != null) {
                context.startActivity(Intent.createChooser(intent, context.getResources().getString(R.string.app_name)));
            }
            return;
        } catch (ActivityNotFoundException e) {
            ThrowableUtils.getFullStackTrace(e);
        }
        ToastUtils.showLong(context.getResources().getString(R.string.no_email_client));
    }

    public static String getFileSize(long size) {
        if (size <= 0) return "0 Bytes";
        final String[] units = new String[]{"Bytes", "KB", "MB", "GB", "TB"};
        int digitGroups = (int) (Math.log10(size) / Math.log10(1024));
        return new DecimalFormat("#,##0.##").format(size / Math.pow(1024, digitGroups)) + " " + units[digitGroups];
    }
}
