/*
 * Decompiled with CFR 0.152.
 */
package io.ahmer.utils.async;

import io.ahmer.utils.async.AsyncWorker;
import java.util.concurrent.ExecutorService;

public abstract class AsyncTask<INPUT, PROGRESS, OUTPUT> {
    private boolean cancelled = false;
    private OnProgressListener<PROGRESS> onProgressListener;
    private OnCancelledListener onCancelledListener;

    public AsyncTask<INPUT, PROGRESS, OUTPUT> execute() {
        return this.execute(null);
    }

    public AsyncTask<INPUT, PROGRESS, OUTPUT> execute(final INPUT input) {
        this.onPreExecute();
        ExecutorService executorService = AsyncWorker.getInstance().getExecutorService();
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    final Object output = AsyncTask.this.doInBackground(input);
                    AsyncWorker.getInstance().getHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            AsyncTask.this.onPostExecute(output);
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    AsyncWorker.getInstance().getHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            AsyncTask.this.onBackgroundError(e);
                        }
                    });
                }
            }
        });
        return this;
    }

    protected void publishProgress(final PROGRESS progress) {
        AsyncWorker.getInstance().getHandler().post(new Runnable(){

            @Override
            public void run() {
                AsyncTask.this.onProgress(progress);
                if (AsyncTask.this.onProgressListener != null) {
                    AsyncTask.this.onProgressListener.onProgress(progress);
                }
            }
        });
    }

    protected void onProgress(PROGRESS progress) {
    }

    public void cancel() {
        this.cancelled = true;
    }

    protected boolean isCancelled() {
        return this.cancelled;
    }

    protected void onCancelled() {
        AsyncWorker.getInstance().getHandler().post(new Runnable(){

            @Override
            public void run() {
                if (AsyncTask.this.onCancelledListener != null) {
                    AsyncTask.this.onCancelledListener.onCancelled();
                }
            }
        });
    }

    protected void onPreExecute() {
    }

    protected abstract OUTPUT doInBackground(INPUT var1) throws Exception;

    protected void onPostExecute(OUTPUT output) {
    }

    protected abstract void onBackgroundError(Exception var1);

    public void setOnProgressListener(OnProgressListener<PROGRESS> onProgressListener) {
        this.onProgressListener = onProgressListener;
    }

    public void setOnCancelledListener(OnCancelledListener onCancelledListener) {
        this.onCancelledListener = onCancelledListener;
    }

    public static interface OnProgressListener<PROGRESS> {
        public void onProgress(PROGRESS var1);
    }

    public static interface OnCancelledListener {
        public void onCancelled();
    }
}

