/*
 * Decompiled with CFR 0.152.
 */
package io.ahmer.utils.utilcode;

import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.util.Log;
import io.ahmer.utils.utilcode.Utils;
import java.io.IOException;

public final class FlashlightUtils {
    private static Camera mCamera;
    private static SurfaceTexture mSurfaceTexture;

    private FlashlightUtils() {
        throw new UnsupportedOperationException("You can't instantiate me...");
    }

    public static boolean isFlashlightEnable() {
        return Utils.getApp().getPackageManager().hasSystemFeature("android.hardware.camera.flash");
    }

    public static boolean isFlashlightOn() {
        if (!FlashlightUtils.init()) {
            return false;
        }
        Camera.Parameters parameters = mCamera.getParameters();
        return "torch".equals(parameters.getFlashMode());
    }

    public static void setFlashlightStatus(boolean isOn) {
        if (!FlashlightUtils.init()) {
            return;
        }
        Camera.Parameters parameters = mCamera.getParameters();
        if (isOn) {
            if (!"torch".equals(parameters.getFlashMode())) {
                try {
                    mCamera.setPreviewTexture(mSurfaceTexture);
                    mCamera.startPreview();
                    parameters.setFlashMode("torch");
                    mCamera.setParameters(parameters);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (!"off".equals(parameters.getFlashMode())) {
            parameters.setFlashMode("off");
            mCamera.setParameters(parameters);
        }
    }

    public static void destroy() {
        if (mCamera == null) {
            return;
        }
        mCamera.release();
        mSurfaceTexture = null;
        mCamera = null;
    }

    private static boolean init() {
        if (mCamera == null) {
            try {
                mCamera = Camera.open((int)0);
                mSurfaceTexture = new SurfaceTexture(0);
            }
            catch (Throwable t) {
                Log.e((String)"FlashlightUtils", (String)"init failed: ", (Throwable)t);
                return false;
            }
        }
        if (mCamera == null) {
            Log.e((String)"FlashlightUtils", (String)"init failed.");
            return false;
        }
        return true;
    }
}

