/*
 * Decompiled with CFR 0.152.
 */
package com.ahmer.afzal.utils.utilcode;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ThrowableUtils {
    private static final String LINE_SEP = System.getProperty("line.separator");

    private ThrowableUtils() {
        throw new UnsupportedOperationException("You can't instantiate me...");
    }

    public static String getFullStackTrace(Throwable throwable) {
        ArrayList<Throwable> throwableList = new ArrayList<Throwable>();
        while (throwable != null && !throwableList.contains(throwable)) {
            throwableList.add(throwable);
            throwable = throwable.getCause();
        }
        int size = throwableList.size();
        ArrayList<String> frames = new ArrayList<String>();
        List<String> nextTrace = ThrowableUtils.getStackFrameList((Throwable)throwableList.get(size - 1));
        int i = size;
        while (--i >= 0) {
            List<String> trace = nextTrace;
            if (i != 0) {
                nextTrace = ThrowableUtils.getStackFrameList((Throwable)throwableList.get(i - 1));
                ThrowableUtils.removeCommonFrames(trace, nextTrace);
            }
            if (i == size - 1) {
                frames.add(((Throwable)throwableList.get(i)).toString());
            } else {
                frames.add(" Caused by: " + ((Throwable)throwableList.get(i)).toString());
            }
            frames.addAll(trace);
        }
        StringBuilder sb = new StringBuilder();
        for (String element : frames) {
            sb.append(element).append(LINE_SEP);
        }
        return sb.toString();
    }

    private static List<String> getStackFrameList(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        String stackTrace = sw.toString();
        StringTokenizer frames = new StringTokenizer(stackTrace, LINE_SEP);
        ArrayList<String> list = new ArrayList<String>();
        boolean traceStarted = false;
        while (frames.hasMoreTokens()) {
            String token = frames.nextToken();
            int at = token.indexOf("at");
            if (at != -1 && token.substring(0, at).trim().isEmpty()) {
                traceStarted = true;
                list.add(token);
                continue;
            }
            if (!traceStarted) continue;
            break;
        }
        return list;
    }

    private static void removeCommonFrames(List<String> causeFrames, List<String> wrapperFrames) {
        int causeFrameIndex = causeFrames.size() - 1;
        for (int wrapperFrameIndex = wrapperFrames.size() - 1; causeFrameIndex >= 0 && wrapperFrameIndex >= 0; --causeFrameIndex, --wrapperFrameIndex) {
            String wrapperFrame;
            String causeFrame = causeFrames.get(causeFrameIndex);
            if (!causeFrame.equals(wrapperFrame = wrapperFrames.get(wrapperFrameIndex))) continue;
            causeFrames.remove(causeFrameIndex);
        }
    }
}

