/*
 * Decompiled with CFR 0.152.
 */
package com.ahmer.afzal.utils.subutil;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PowerManager;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.RequiresPermission;
import com.ahmer.afzal.utils.utilcode.IntentUtils;
import com.ahmer.afzal.utils.utilcode.ShellUtils;
import com.ahmer.afzal.utils.utilcode.Utils;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class DangerousUtils {
    private DangerousUtils() {
        throw new UnsupportedOperationException("You can't instantiate me...");
    }

    public static boolean installAppSilent(String filePath) {
        return DangerousUtils.installAppSilent(DangerousUtils.getFileByPath(filePath), null);
    }

    public static boolean installAppSilent(File file) {
        return DangerousUtils.installAppSilent(file, null);
    }

    public static boolean installAppSilent(String filePath, String params) {
        return DangerousUtils.installAppSilent(DangerousUtils.getFileByPath(filePath), params);
    }

    public static boolean installAppSilent(File file, String params) {
        return DangerousUtils.installAppSilent(file, params, DangerousUtils.isDeviceRooted());
    }

    public static boolean installAppSilent(File file, String params, boolean isRooted) {
        if (!DangerousUtils.isFileExists(file)) {
            return false;
        }
        String filePath = '\"' + file.getAbsolutePath() + '\"';
        String command = "LD_LIBRARY_PATH=/vendor/lib*:/system/lib* pm install " + (params == null ? "" : params + " ") + filePath;
        ShellUtils.CommandResult commandResult = ShellUtils.execCmd(command, isRooted);
        if (commandResult.successMsg != null && commandResult.successMsg.toLowerCase().contains("success")) {
            return true;
        }
        Log.e((String)"AppUtils", (String)("installAppSilent successMsg: " + commandResult.successMsg + ", errorMsg: " + commandResult.errorMsg));
        return false;
    }

    public static boolean uninstallAppSilent(String packageName) {
        return DangerousUtils.uninstallAppSilent(packageName, false);
    }

    public static boolean uninstallAppSilent(String packageName, boolean isKeepData) {
        return DangerousUtils.uninstallAppSilent(packageName, isKeepData, DangerousUtils.isDeviceRooted());
    }

    public static boolean uninstallAppSilent(String packageName, boolean isKeepData, boolean isRooted) {
        if (DangerousUtils.isSpace(packageName)) {
            return false;
        }
        String command = "LD_LIBRARY_PATH=/vendor/lib*:/system/lib* pm uninstall " + (isKeepData ? "-k " : "") + packageName;
        ShellUtils.CommandResult commandResult = ShellUtils.execCmd(command, isRooted);
        if (commandResult.successMsg != null && commandResult.successMsg.toLowerCase().contains("success")) {
            return true;
        }
        Log.e((String)"AppUtils", (String)("uninstallAppSilent successMsg: " + commandResult.successMsg + ", errorMsg: " + commandResult.errorMsg));
        return false;
    }

    private static boolean isFileExists(File file) {
        return file != null && file.exists();
    }

    private static File getFileByPath(String filePath) {
        return DangerousUtils.isSpace(filePath) ? null : new File(filePath);
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isDeviceRooted() {
        String[] locations;
        String su = "su";
        for (String location : locations = new String[]{"/system/bin/", "/system/xbin/", "/sbin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/xbin/", "/data/local/bin/", "/data/local/", "/system/sbin/", "/usr/bin/", "/vendor/bin/"}) {
            if (!new File(location + su).exists()) continue;
            return true;
        }
        return false;
    }

    public static boolean shutdown() {
        try {
            ShellUtils.CommandResult result = ShellUtils.execCmd("reboot -p", true);
            if (result.result == 0) {
                return true;
            }
            Utils.getApp().startActivity(IntentUtils.getShutdownIntent());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean reboot() {
        try {
            ShellUtils.CommandResult result = ShellUtils.execCmd("reboot", true);
            if (result.result == 0) {
                return true;
            }
            Intent intent = new Intent("android.intent.action.REBOOT");
            intent.putExtra("nowait", 1);
            intent.putExtra("interval", 1);
            intent.putExtra("window", 0);
            Utils.getApp().sendBroadcast(intent);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean reboot(String reason) {
        try {
            PowerManager pm = (PowerManager)Utils.getApp().getSystemService("power");
            pm.reboot(reason);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean reboot2Recovery() {
        ShellUtils.CommandResult result = ShellUtils.execCmd("reboot recovery", true);
        return result.result == 0;
    }

    public static boolean reboot2Bootloader() {
        ShellUtils.CommandResult result = ShellUtils.execCmd("reboot bootloader", true);
        return result.result == 0;
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public static boolean setMobileDataEnabled(boolean enabled) {
        try {
            TelephonyManager tm = (TelephonyManager)Utils.getApp().getSystemService("phone");
            if (tm == null) {
                return false;
            }
            if (Build.VERSION.SDK_INT >= 26) {
                tm.setDataEnabled(enabled);
                return true;
            }
            Method setDataEnabledMethod = tm.getClass().getDeclaredMethod("setDataEnabled", Boolean.TYPE);
            setDataEnabledMethod.invoke((Object)tm, enabled);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @RequiresPermission(value="android.permission.SEND_SMS")
    public static void sendSmsSilent(String phoneNumber, String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return;
        }
        PendingIntent sentIntent = PendingIntent.getBroadcast((Context)Utils.getApp(), (int)0, (Intent)new Intent("send"), (int)0);
        SmsManager smsManager = SmsManager.getDefault();
        if (content.length() >= 70) {
            ArrayList ms = smsManager.divideMessage(content);
            for (String str : ms) {
                smsManager.sendTextMessage(phoneNumber, null, str, sentIntent, null);
            }
        } else {
            smsManager.sendTextMessage(phoneNumber, null, content, sentIntent, null);
        }
    }
}

