/*
 * Decompiled with CFR 0.152.
 */
package com.ahmer.afzal.utils.imageview;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;

public class ZoomImageView
extends AppCompatImageView {
    private static final String TAG = ZoomImageView.class.getSimpleName();
    private static final int NONE = 0;
    private static final int DRAG = 1;
    private static final int ZOOM = 2;
    private static final int CLICK = 3;
    private final PointF last = new PointF();
    private final PointF start = new PointF();
    protected float origHeight;
    protected float origWidth;
    private float maxScale = 3.0f;
    private float saveScale = 1.0f;
    private float[] m;
    private int mode = 0;
    private int oldMeasuredHeight;
    private int viewHeight;
    private int viewWidth;
    private Matrix matrix;
    private ScaleGestureDetector mScaleDetector;

    public ZoomImageView(Context context) {
        super(context);
        this.init(context);
    }

    public ZoomImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        super.setClickable(true);
        this.mScaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        this.matrix = new Matrix();
        this.m = new float[9];
        this.setImageMatrix(this.matrix);
        this.setScaleType(ImageView.ScaleType.MATRIX);
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                ZoomImageView.this.mScaleDetector.onTouchEvent(event);
                PointF curr = new PointF(event.getX(), event.getY());
                switch (event.getAction()) {
                    case 0: {
                        ZoomImageView.this.last.set(curr);
                        ZoomImageView.this.start.set(ZoomImageView.this.last);
                        ZoomImageView.this.mode = 1;
                        break;
                    }
                    case 2: {
                        if (ZoomImageView.this.mode != 1) break;
                        float deltaX = curr.x - ((ZoomImageView)ZoomImageView.this).last.x;
                        float deltaY = curr.y - ((ZoomImageView)ZoomImageView.this).last.y;
                        float fixTransX = ZoomImageView.this.getFixDragTrans(deltaX, ZoomImageView.this.viewWidth, ZoomImageView.this.origWidth * ZoomImageView.this.saveScale);
                        float fixTransY = ZoomImageView.this.getFixDragTrans(deltaY, ZoomImageView.this.viewHeight, ZoomImageView.this.origHeight * ZoomImageView.this.saveScale);
                        ZoomImageView.this.matrix.postTranslate(fixTransX, fixTransY);
                        ZoomImageView.this.fixTrans();
                        ZoomImageView.this.last.set(curr.x, curr.y);
                        break;
                    }
                    case 1: {
                        ZoomImageView.this.mode = 0;
                        int xDiff = (int)Math.abs(curr.x - ((ZoomImageView)ZoomImageView.this).start.x);
                        int yDiff = (int)Math.abs(curr.y - ((ZoomImageView)ZoomImageView.this).start.y);
                        if (xDiff >= 3 || yDiff >= 3) break;
                        ZoomImageView.this.performClick();
                        break;
                    }
                    case 6: {
                        ZoomImageView.this.mode = 0;
                    }
                }
                ZoomImageView.this.setImageMatrix(ZoomImageView.this.matrix);
                ZoomImageView.this.invalidate();
                return true;
            }
        });
    }

    public void setMaxZoom(float x) {
        this.maxScale = x;
    }

    void fixTrans() {
        this.matrix.getValues(this.m);
        float transX = this.m[2];
        float transY = this.m[5];
        float fixTransX = this.getFixTrans(transX, this.viewWidth, this.origWidth * this.saveScale);
        float fixTransY = this.getFixTrans(transY, this.viewHeight, this.origHeight * this.saveScale);
        if (fixTransX != 0.0f || fixTransY != 0.0f) {
            this.matrix.postTranslate(fixTransX, fixTransY);
        }
    }

    float getFixTrans(float trans, float viewSize, float contentSize) {
        float maxTrans;
        float minTrans;
        if (contentSize <= viewSize) {
            minTrans = 0.0f;
            maxTrans = viewSize - contentSize;
        } else {
            minTrans = viewSize - contentSize;
            maxTrans = 0.0f;
        }
        if (trans < minTrans) {
            return -trans + minTrans;
        }
        if (trans > maxTrans) {
            return -trans + maxTrans;
        }
        return 0.0f;
    }

    float getFixDragTrans(float delta, float viewSize, float contentSize) {
        if (contentSize <= viewSize) {
            return 0.0f;
        }
        return delta;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.viewWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.viewHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.oldMeasuredHeight == this.viewWidth && this.oldMeasuredHeight == this.viewHeight || this.viewWidth == 0 || this.viewHeight == 0) {
            return;
        }
        this.oldMeasuredHeight = this.viewHeight;
        int oldMeasuredWidth = this.viewWidth;
        if (this.saveScale == 1.0f) {
            Drawable drawable = this.getDrawable();
            if (drawable == null || drawable.getIntrinsicWidth() == 0 || drawable.getIntrinsicHeight() == 0) {
                return;
            }
            int bmWidth = drawable.getIntrinsicWidth();
            int bmHeight = drawable.getIntrinsicHeight();
            Log.v((String)TAG, (String)("bmSize bmWidth: " + bmWidth + " bmHeight : " + bmHeight));
            float scaleX = (float)this.viewWidth / (float)bmWidth;
            float scaleY = (float)this.viewHeight / (float)bmHeight;
            float scale = Math.min(scaleX, scaleY);
            this.matrix.setScale(scale, scale);
            float redundantYSpace = (float)this.viewHeight - scale * (float)bmHeight;
            float redundantXSpace = (float)this.viewWidth - scale * (float)bmWidth;
            this.matrix.postTranslate(redundantXSpace /= 2.0f, redundantYSpace /= 2.0f);
            this.origWidth = (float)this.viewWidth - 2.0f * redundantXSpace;
            this.origHeight = (float)this.viewHeight - 2.0f * redundantYSpace;
            this.setImageMatrix(this.matrix);
        }
        this.fixTrans();
    }

    private class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        private ScaleListener() {
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            ZoomImageView.this.mode = 2;
            return true;
        }

        public boolean onScale(ScaleGestureDetector detector) {
            float mScaleFactor = detector.getScaleFactor();
            float origScale = ZoomImageView.this.saveScale;
            ZoomImageView.this.saveScale = ZoomImageView.this.saveScale * mScaleFactor;
            float minScale = 1.0f;
            if (ZoomImageView.this.saveScale > ZoomImageView.this.maxScale) {
                ZoomImageView.this.saveScale = ZoomImageView.this.maxScale;
                mScaleFactor = ZoomImageView.this.maxScale / origScale;
            } else if (ZoomImageView.this.saveScale < minScale) {
                ZoomImageView.this.saveScale = minScale;
                mScaleFactor = minScale / origScale;
            }
            if (ZoomImageView.this.origWidth * ZoomImageView.this.saveScale <= (float)ZoomImageView.this.viewWidth || ZoomImageView.this.origHeight * ZoomImageView.this.saveScale <= (float)ZoomImageView.this.viewHeight) {
                ZoomImageView.this.matrix.postScale(mScaleFactor, mScaleFactor, (float)ZoomImageView.this.viewWidth / 2.0f, (float)ZoomImageView.this.viewHeight / 2.0f);
            } else {
                ZoomImageView.this.matrix.postScale(mScaleFactor, mScaleFactor, detector.getFocusX(), detector.getFocusY());
            }
            ZoomImageView.this.fixTrans();
            return true;
        }
    }
}

