/*
 * Decompiled with CFR 0.152.
 */
package com.ahmer.afzal.utils.async;

import com.ahmer.afzal.utils.async.AsyncWorker;
import com.ahmer.afzal.utils.async.TaskNotExecutedException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public abstract class AdvancedAsyncTask<INPUT, PROGRESS, OUTPUT> {
    private boolean cancelled = false;
    private Future<OUTPUT> outputFuture;
    private OnProgressListener<PROGRESS> onProgressListener;
    private OnCancelledListener onCancelledListener;

    public AdvancedAsyncTask<INPUT, PROGRESS, OUTPUT> execute() {
        return this.execute(null);
    }

    public AdvancedAsyncTask<INPUT, PROGRESS, OUTPUT> execute(final INPUT input) {
        this.onPreExecute();
        ExecutorService executorService = AsyncWorker.getInstance().getExecutorService();
        this.outputFuture = executorService.submit(new Callable<OUTPUT>(){

            @Override
            public OUTPUT call() throws Exception {
                try {
                    final Object output = AdvancedAsyncTask.this.doInBackground(input);
                    AsyncWorker.getInstance().getHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            AdvancedAsyncTask.this.onPostExecute(output);
                        }
                    });
                    return output;
                }
                catch (Exception e) {
                    AsyncWorker.getInstance().getHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            AdvancedAsyncTask.this.onBackgroundError(e);
                        }
                    });
                    throw e;
                }
            }
        });
        return this;
    }

    public OUTPUT get() throws Exception {
        if (this.outputFuture == null) {
            throw new TaskNotExecutedException();
        }
        return this.outputFuture.get();
    }

    public OUTPUT get(long timeout, TimeUnit timeUnit) throws Exception {
        if (this.outputFuture == null) {
            throw new TaskNotExecutedException();
        }
        return this.outputFuture.get(timeout, timeUnit);
    }

    protected void publishProgress(final PROGRESS progress) {
        AsyncWorker.getInstance().getHandler().post(new Runnable(){

            @Override
            public void run() {
                AdvancedAsyncTask.this.onProgress(progress);
                if (AdvancedAsyncTask.this.onProgressListener != null) {
                    AdvancedAsyncTask.this.onProgressListener.onProgress(progress);
                }
            }
        });
    }

    protected void onProgress(PROGRESS progress) {
    }

    public void cancel() {
        this.cancelled = true;
    }

    protected boolean isCancelled() {
        return this.cancelled;
    }

    protected void onCancelled() {
        AsyncWorker.getInstance().getHandler().post(new Runnable(){

            @Override
            public void run() {
                if (AdvancedAsyncTask.this.onCancelledListener != null) {
                    AdvancedAsyncTask.this.onCancelledListener.onCancelled();
                }
            }
        });
    }

    protected void onPreExecute() {
    }

    protected abstract OUTPUT doInBackground(INPUT var1) throws Exception;

    protected void onPostExecute(OUTPUT output) {
    }

    protected abstract void onBackgroundError(Exception var1);

    public void setOnProgressListener(OnProgressListener<PROGRESS> onProgressListener) {
        this.onProgressListener = onProgressListener;
    }

    public void setOnCancelledListener(OnCancelledListener onCancelledListener) {
        this.onCancelledListener = onCancelledListener;
    }

    public static interface OnCancelledListener {
        public void onCancelled();
    }

    public static interface OnProgressListener<PROGRESS> {
        public void onProgress(PROGRESS var1);
    }
}

