/*
 * Decompiled with CFR 0.152.
 */
package com.ahmer.afzal.utils;

import android.content.Context;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatTextView;
import com.ahmer.afzal.utils.async.AsyncTask;
import com.ahmer.afzal.utils.utilcode.ThreadUtils;

public class VerticalMarqueeTextView
extends AppCompatTextView {
    private boolean isPaused;
    private boolean isUserScrolling;
    private boolean stop;
    private int duration;
    private int pixelYOffSet;

    public VerticalMarqueeTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public VerticalMarqueeTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public VerticalMarqueeTextView(Context context) {
        super(context);
        this.init();
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration <= 0 ? 65 : duration;
    }

    public int getPixelYOffSet() {
        return this.pixelYOffSet;
    }

    public void setPixelYOffSet(int pixelYOffSet) {
        this.pixelYOffSet = Math.max(pixelYOffSet, 1);
    }

    private void startMarquee() {
        new AutoScrollTextView(this).execute(null);
    }

    public void stopMarquee() {
        this.stop = true;
    }

    public void pauseMarquee() {
        this.isPaused = true;
    }

    public void resumeMarquee() {
        this.isPaused = false;
    }

    public boolean isPaused() {
        return this.isPaused || this.isUserScrolling;
    }

    private void init() {
        this.setDuration(65);
        this.setPixelYOffSet(1);
        this.stop = false;
        this.isPaused = false;
        this.isUserScrolling = false;
        this.startMarquee();
    }

    private static class AutoScrollTextView
    extends AsyncTask<Void, Void, Void> {
        private final VerticalMarqueeTextView vMTV;
        private boolean isNotDrawn;
        private int pixelCount;

        public AutoScrollTextView(VerticalMarqueeTextView vMTV) {
            this.vMTV = vMTV;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            this.isNotDrawn = true;
        }

        @Override
        protected Void doInBackground(Void aVoid) throws Exception {
            while (this.textViewNotDrawn()) {
                Thread.sleep(1000L);
            }
            while (!this.vMTV.stop) {
                if (!this.vMTV.isPressed() || !this.vMTV.isUserScrolling || this.vMTV.isPaused) {
                    this.vMTV.isUserScrolling = false;
                }
                while (!(this.vMTV.isUserScrolling || this.vMTV.stop || this.vMTV.isPaused)) {
                    Thread.sleep(this.vMTV.duration);
                    ThreadUtils.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (vMTV.isPressed()) {
                                vMTV.isUserScrolling = true;
                            } else {
                                if (vMTV.getScrollY() >= pixelCount) {
                                    vMTV.scrollTo(0, 0);
                                } else {
                                    vMTV.scrollBy(0, vMTV.pixelYOffSet);
                                }
                                vMTV.invalidate();
                            }
                        }
                    });
                }
            }
            return null;
        }

        @Override
        protected void onPostExecute(Void aVoid) {
            super.onPostExecute(aVoid);
        }

        @Override
        protected void onBackgroundError(Exception e) {
            e.printStackTrace();
        }

        private boolean textViewNotDrawn() {
            ThreadUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (vMTV.getLineCount() > 0) {
                        pixelCount = vMTV.getLineHeight() * vMTV.getLineCount();
                        isNotDrawn = false;
                    }
                }
            });
            return this.isNotDrawn;
        }
    }
}

