/*
 * Decompiled with CFR 0.152.
 */
package com.ahmer.afzal.utils;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.view.View;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.core.content.ContextCompat;
import com.ahmer.afzal.utils.R;
import com.ahmer.afzal.utils.utilcode.AppUtils;
import com.ahmer.afzal.utils.utilcode.DeviceUtils;
import com.ahmer.afzal.utils.utilcode.NetworkUtils;
import com.ahmer.afzal.utils.utilcode.SnackbarUtils;
import com.ahmer.afzal.utils.utilcode.ThrowableUtils;
import com.ahmer.afzal.utils.utilcode.ToastUtils;
import com.ahmer.afzal.utils.utilcode.Utils;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;

public class HelperUtils
extends AppCompatActivity {
    public static void clipBoardCopied(Context context, TextView text) {
        ClipboardManager clipboardManager = (ClipboardManager)context.getSystemService("clipboard");
        ClipData clipData = ClipData.newPlainText((CharSequence)"text", (CharSequence)text.getText());
        assert (clipboardManager != null);
        clipboardManager.setPrimaryClip(clipData);
        ToastUtils.showShort(context.getString(R.string.text_copied));
    }

    public static void openCustomTabs(Context context, String url) {
        CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder();
        builder.setColorScheme(ContextCompat.getColor((Context)context, (int)R.color.colorPrimary));
        builder.setShowTitle(true);
        CustomTabsIntent customTabsIntent = builder.build();
        customTabsIntent.launchUrl(context, Uri.parse((String)url));
    }

    public static void showNoInternetSnack(Activity activity) {
        View view = activity.findViewById(0x1020002);
        if (NetworkUtils.isConnected()) {
            SnackbarUtils.with(view).setDuration(0).setMessage(activity.getResources().getString(R.string.internet_connected)).showSuccess();
        } else {
            SnackbarUtils.with(view).setDuration(0).setMessage(activity.getResources().getString(R.string.internet_connection_no)).showWarning();
        }
    }

    public static void appShareOrEmail(Context context, boolean flag, String msgForShareApp, String appName) {
        String s;
        try {
            Utils.getApp().getPackageName();
        }
        catch (Exception e) {
            ThrowableUtils.getFullStackTrace(e);
        }
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("message/rfc822");
        if (flag) {
            s = "\n\n\n" + context.getResources().getString(R.string.auto_generate_msg) + msgForShareApp + "\n" + context.getResources().getString(R.string.email_ahmer_yahoo);
            intent.putExtra("android.intent.extra.SUBJECT", appName);
        } else {
            s = "\n\n\n" + context.getResources().getString(R.string.auto_generate_msg) + "\n\nApp Version: " + AppUtils.getAppVersionName() + "\nManufacturer: " + DeviceUtils.getModel() + "\nBrand: " + DeviceUtils.getManufacturer() + "\nProduct: " + DeviceUtils.getProduct() + "\nArchitecture: " + DeviceUtils.getArchitectureOS() + "\nHardware: " + DeviceUtils.getHardware() + "\nID: " + DeviceUtils.getId() + "\nOS Version: " + DeviceUtils.getSDKVersionName() + "\nOS API Level: " + DeviceUtils.getSDKVersionCode();
            intent.putExtra("android.intent.extra.EMAIL", new String[]{context.getResources().getString(R.string.email_ahmer_yahoo)});
            intent.putExtra("android.intent.extra.CC", new String[]{context.getResources().getString(R.string.email_ahmer_gmail)});
            intent.putExtra("android.intent.extra.SUBJECT", context.getResources().getString(R.string.send_email_to_author));
        }
        PackageManager pm = Utils.getApp().getPackageManager();
        List matches = pm.queryIntentActivities(intent, 0);
        String className = null;
        for (ResolveInfo info : matches) {
            if (!info.activityInfo.packageName.equals("com.google.android.gm") || (className = info.activityInfo.name) == null || className.isEmpty()) continue;
            break;
        }
        intent.setClassName("com.google.android.gm", (String)Objects.requireNonNull(className));
        intent.putExtra("android.intent.extra.TEXT", s);
        intent.setFlags(0x24000000);
        if (Build.VERSION.SDK_INT < 24 || Build.VERSION.SDK_INT >= 28) {
            intent.addFlags(0x10000000);
        }
        try {
            if (intent.resolveActivity(Utils.getApp().getPackageManager()) != null) {
                context.startActivity(Intent.createChooser((Intent)intent, (CharSequence)context.getResources().getString(R.string.app_name)));
            }
            return;
        }
        catch (ActivityNotFoundException e) {
            ThrowableUtils.getFullStackTrace(e);
            ToastUtils.showLong(context.getResources().getString(R.string.no_email_client));
            return;
        }
    }

    public static String getFileSize(long size) {
        if (size <= 0L) {
            return "0 Bytes";
        }
        String[] units = new String[]{"Bytes", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.##").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }
}

