/*
 * Decompiled with CFR 0.152.
 */
package com.ahmer.afzal.utils.utilcode;

import android.util.Log;
import com.ahmer.afzal.utils.utilcode.UtilsBridge;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public final class FileIOUtils {
    private static int sBufferSize = 524288;

    private FileIOUtils() {
        throw new UnsupportedOperationException("You can't instantiate me...");
    }

    public static boolean writeFileFromIS(String filePath, InputStream is) {
        return FileIOUtils.writeFileFromIS(UtilsBridge.getFileByPath(filePath), is, false, null);
    }

    public static boolean writeFileFromIS(String filePath, InputStream is, boolean append) {
        return FileIOUtils.writeFileFromIS(UtilsBridge.getFileByPath(filePath), is, append, null);
    }

    public static boolean writeFileFromIS(File file, InputStream is) {
        return FileIOUtils.writeFileFromIS(file, is, false, null);
    }

    public static boolean writeFileFromIS(File file, InputStream is, boolean append) {
        return FileIOUtils.writeFileFromIS(file, is, append, null);
    }

    public static boolean writeFileFromIS(String filePath, InputStream is, OnProgressUpdateListener listener) {
        return FileIOUtils.writeFileFromIS(UtilsBridge.getFileByPath(filePath), is, false, listener);
    }

    public static boolean writeFileFromIS(String filePath, InputStream is, boolean append, OnProgressUpdateListener listener) {
        return FileIOUtils.writeFileFromIS(UtilsBridge.getFileByPath(filePath), is, append, listener);
    }

    public static boolean writeFileFromIS(File file, InputStream is, OnProgressUpdateListener listener) {
        return FileIOUtils.writeFileFromIS(file, is, false, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromIS(File file, InputStream is, boolean append, OnProgressUpdateListener listener) {
        if (is == null || !UtilsBridge.createOrExistsFile(file)) {
            Log.e((String)"FileIOUtils", (String)("create file <" + file + "> failed."));
            return false;
        }
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(file, append), sBufferSize);
            if (listener == null) {
                int len;
                byte[] data = new byte[sBufferSize];
                while ((len = is.read(data)) != -1) {
                    ((OutputStream)os).write(data, 0, len);
                }
            } else {
                int len;
                double totalSize = is.available();
                int curSize = 0;
                listener.onProgressUpdate(0.0);
                byte[] data = new byte[sBufferSize];
                while ((len = is.read(data)) != -1) {
                    ((OutputStream)os).write(data, 0, len);
                    listener.onProgressUpdate((double)(curSize += len) / totalSize);
                }
            }
            boolean totalSize = true;
            return totalSize;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean writeFileFromBytesByStream(String filePath, byte[] bytes) {
        return FileIOUtils.writeFileFromBytesByStream(UtilsBridge.getFileByPath(filePath), bytes, false, null);
    }

    public static boolean writeFileFromBytesByStream(String filePath, byte[] bytes, boolean append) {
        return FileIOUtils.writeFileFromBytesByStream(UtilsBridge.getFileByPath(filePath), bytes, append, null);
    }

    public static boolean writeFileFromBytesByStream(File file, byte[] bytes) {
        return FileIOUtils.writeFileFromBytesByStream(file, bytes, false, null);
    }

    public static boolean writeFileFromBytesByStream(File file, byte[] bytes, boolean append) {
        return FileIOUtils.writeFileFromBytesByStream(file, bytes, append, null);
    }

    public static boolean writeFileFromBytesByStream(String filePath, byte[] bytes, OnProgressUpdateListener listener) {
        return FileIOUtils.writeFileFromBytesByStream(UtilsBridge.getFileByPath(filePath), bytes, false, listener);
    }

    public static boolean writeFileFromBytesByStream(String filePath, byte[] bytes, boolean append, OnProgressUpdateListener listener) {
        return FileIOUtils.writeFileFromBytesByStream(UtilsBridge.getFileByPath(filePath), bytes, append, listener);
    }

    public static boolean writeFileFromBytesByStream(File file, byte[] bytes, OnProgressUpdateListener listener) {
        return FileIOUtils.writeFileFromBytesByStream(file, bytes, false, listener);
    }

    public static boolean writeFileFromBytesByStream(File file, byte[] bytes, boolean append, OnProgressUpdateListener listener) {
        if (bytes == null) {
            return false;
        }
        return FileIOUtils.writeFileFromIS(file, (InputStream)new ByteArrayInputStream(bytes), append, listener);
    }

    public static boolean writeFileFromBytesByChannel(String filePath, byte[] bytes, boolean isForce) {
        return FileIOUtils.writeFileFromBytesByChannel(UtilsBridge.getFileByPath(filePath), bytes, false, isForce);
    }

    public static boolean writeFileFromBytesByChannel(String filePath, byte[] bytes, boolean append, boolean isForce) {
        return FileIOUtils.writeFileFromBytesByChannel(UtilsBridge.getFileByPath(filePath), bytes, append, isForce);
    }

    public static boolean writeFileFromBytesByChannel(File file, byte[] bytes, boolean isForce) {
        return FileIOUtils.writeFileFromBytesByChannel(file, bytes, false, isForce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromBytesByChannel(File file, byte[] bytes, boolean append, boolean isForce) {
        if (bytes == null) {
            Log.e((String)"FileIOUtils", (String)"bytes is null.");
            return false;
        }
        if (!UtilsBridge.createOrExistsFile(file)) {
            Log.e((String)"FileIOUtils", (String)("create file <" + file + "> failed."));
            return false;
        }
        FileChannel fc = null;
        try {
            fc = new FileOutputStream(file, append).getChannel();
            if (fc == null) {
                Log.e((String)"FileIOUtils", (String)"fc is null.");
                boolean bl = false;
                return bl;
            }
            fc.position(fc.size());
            fc.write(ByteBuffer.wrap(bytes));
            if (isForce) {
                fc.force(true);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fc != null) {
                    fc.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean writeFileFromBytesByMap(String filePath, byte[] bytes, boolean isForce) {
        return FileIOUtils.writeFileFromBytesByMap(filePath, bytes, false, isForce);
    }

    public static boolean writeFileFromBytesByMap(String filePath, byte[] bytes, boolean append, boolean isForce) {
        return FileIOUtils.writeFileFromBytesByMap(UtilsBridge.getFileByPath(filePath), bytes, append, isForce);
    }

    public static boolean writeFileFromBytesByMap(File file, byte[] bytes, boolean isForce) {
        return FileIOUtils.writeFileFromBytesByMap(file, bytes, false, isForce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromBytesByMap(File file, byte[] bytes, boolean append, boolean isForce) {
        if (bytes == null || !UtilsBridge.createOrExistsFile(file)) {
            Log.e((String)"FileIOUtils", (String)("create file <" + file + "> failed."));
            return false;
        }
        FileChannel fc = null;
        try {
            fc = new FileOutputStream(file, append).getChannel();
            if (fc == null) {
                Log.e((String)"FileIOUtils", (String)"fc is null.");
                boolean bl = false;
                return bl;
            }
            MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_WRITE, fc.size(), bytes.length);
            mbb.put(bytes);
            if (isForce) {
                mbb.force();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fc != null) {
                    fc.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean writeFileFromString(String filePath, String content) {
        return FileIOUtils.writeFileFromString(UtilsBridge.getFileByPath(filePath), content, false);
    }

    public static boolean writeFileFromString(String filePath, String content, boolean append) {
        return FileIOUtils.writeFileFromString(UtilsBridge.getFileByPath(filePath), content, append);
    }

    public static boolean writeFileFromString(File file, String content) {
        return FileIOUtils.writeFileFromString(file, content, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromString(File file, String content, boolean append) {
        if (file == null || content == null) {
            return false;
        }
        if (!UtilsBridge.createOrExistsFile(file)) {
            Log.e((String)"FileIOUtils", (String)("create file <" + file + "> failed."));
            return false;
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(file, append));
            bw.write(content);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<String> readFile2List(String filePath) {
        return FileIOUtils.readFile2List(UtilsBridge.getFileByPath(filePath), null);
    }

    public static List<String> readFile2List(String filePath, String charsetName) {
        return FileIOUtils.readFile2List(UtilsBridge.getFileByPath(filePath), charsetName);
    }

    public static List<String> readFile2List(File file) {
        return FileIOUtils.readFile2List(file, 0, Integer.MAX_VALUE, null);
    }

    public static List<String> readFile2List(File file, String charsetName) {
        return FileIOUtils.readFile2List(file, 0, Integer.MAX_VALUE, charsetName);
    }

    public static List<String> readFile2List(String filePath, int st, int end) {
        return FileIOUtils.readFile2List(UtilsBridge.getFileByPath(filePath), st, end, null);
    }

    public static List<String> readFile2List(String filePath, int st, int end, String charsetName) {
        return FileIOUtils.readFile2List(UtilsBridge.getFileByPath(filePath), st, end, charsetName);
    }

    public static List<String> readFile2List(File file, int st, int end) {
        return FileIOUtils.readFile2List(file, st, end, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFile2List(File file, int st, int end, String charsetName) {
        if (!UtilsBridge.isFileExists(file)) {
            return null;
        }
        if (st > end) {
            return null;
        }
        BufferedReader reader = null;
        try {
            String line;
            ArrayList<String> list = new ArrayList<String>();
            reader = UtilsBridge.isSpace(charsetName) ? new BufferedReader(new InputStreamReader(new FileInputStream(file))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
            for (int curLine = 1; (line = reader.readLine()) != null && curLine <= end; ++curLine) {
                if (st > curLine || curLine > end) continue;
                list.add(line);
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (IOException e) {
            e.printStackTrace();
            List<String> list = null;
            return list;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String readFile2String(String filePath) {
        return FileIOUtils.readFile2String(UtilsBridge.getFileByPath(filePath), null);
    }

    public static String readFile2String(String filePath, String charsetName) {
        return FileIOUtils.readFile2String(UtilsBridge.getFileByPath(filePath), charsetName);
    }

    public static String readFile2String(File file) {
        return FileIOUtils.readFile2String(file, null);
    }

    public static String readFile2String(File file, String charsetName) {
        byte[] bytes = FileIOUtils.readFile2BytesByStream(file);
        if (bytes == null) {
            return null;
        }
        if (UtilsBridge.isSpace(charsetName)) {
            return new String(bytes);
        }
        try {
            return new String(bytes, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static byte[] readFile2BytesByStream(String filePath) {
        return FileIOUtils.readFile2BytesByStream(UtilsBridge.getFileByPath(filePath), null);
    }

    public static byte[] readFile2BytesByStream(File file) {
        return FileIOUtils.readFile2BytesByStream(file, null);
    }

    public static byte[] readFile2BytesByStream(String filePath, OnProgressUpdateListener listener) {
        return FileIOUtils.readFile2BytesByStream(UtilsBridge.getFileByPath(filePath), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readFile2BytesByStream(File file, OnProgressUpdateListener listener) {
        if (!UtilsBridge.isFileExists(file)) {
            return null;
        }
        try {
            ByteArrayOutputStream os = null;
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file), sBufferSize);
            try {
                os = new ByteArrayOutputStream();
                byte[] b = new byte[sBufferSize];
                if (listener == null) {
                    int len;
                    while ((len = ((InputStream)is).read(b, 0, sBufferSize)) != -1) {
                        os.write(b, 0, len);
                    }
                } else {
                    int len;
                    double totalSize = ((InputStream)is).available();
                    int curSize = 0;
                    listener.onProgressUpdate(0.0);
                    while ((len = ((InputStream)is).read(b, 0, sBufferSize)) != -1) {
                        os.write(b, 0, len);
                        listener.onProgressUpdate((double)(curSize += len) / totalSize);
                    }
                }
                byte[] totalSize = os.toByteArray();
                return totalSize;
            }
            catch (IOException e) {
                e.printStackTrace();
                byte[] byArray = null;
                return byArray;
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e5) {
                    e5.printStackTrace();
                }
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e6) {
                    e6.printStackTrace();
                }
            }
        }
        catch (FileNotFoundException e4) {
            e4.printStackTrace();
            return null;
        }
    }

    public static byte[] readFile2BytesByChannel(String filePath) {
        return FileIOUtils.readFile2BytesByChannel(UtilsBridge.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile2BytesByChannel(File file) {
        if (!UtilsBridge.isFileExists(file)) {
            return null;
        }
        FileChannel fc = null;
        try {
            fc = new RandomAccessFile(file, "r").getChannel();
            if (fc == null) {
                Log.e((String)"FileIOUtils", (String)"fc is null.");
                byte[] byArray = new byte[]{};
                return byArray;
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)fc.size());
            while (fc.read(byteBuffer) > 0) {
            }
            byte[] byArray = byteBuffer.array();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (fc != null) {
                    fc.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static byte[] readFile2BytesByMap(String filePath) {
        return FileIOUtils.readFile2BytesByMap(UtilsBridge.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile2BytesByMap(File file) {
        if (!UtilsBridge.isFileExists(file)) {
            return null;
        }
        FileChannel fc = null;
        try {
            fc = new RandomAccessFile(file, "r").getChannel();
            if (fc == null) {
                Log.e((String)"FileIOUtils", (String)"fc is null.");
                byte[] byArray = new byte[]{};
                return byArray;
            }
            int size = (int)fc.size();
            MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, size).load();
            byte[] result = new byte[size];
            mbb.get(result, 0, size);
            byte[] byArray = result;
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (fc != null) {
                    fc.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void setBufferSize(int bufferSize) {
        sBufferSize = bufferSize;
    }

    public static interface OnProgressUpdateListener {
        public void onProgressUpdate(double var1);
    }
}

