/*
 * Decompiled with CFR 0.152.
 */
package com.ahmer.afzal.utils.subutil;

import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.util.Log;
import com.ahmer.afzal.utils.utilcode.AppUtils;
import com.ahmer.afzal.utils.utilcode.RomUtils;
import com.ahmer.afzal.utils.utilcode.Utils;
import java.util.List;

public final class AppStoreUtils {
    private static final String TAG = "AppStoreUtils";
    private static final String GOOGLE_PLAY_APP_STORE_PACKAGE_NAME = "com.android.vending";

    public static Intent getAppStoreIntent() {
        return AppStoreUtils.getAppStoreIntent(Utils.getApp().getPackageName(), false);
    }

    public static Intent getAppStoreIntent(boolean isIncludeGooglePlayStore) {
        return AppStoreUtils.getAppStoreIntent(Utils.getApp().getPackageName(), isIncludeGooglePlayStore);
    }

    public static Intent getAppStoreIntent(String packageName) {
        return AppStoreUtils.getAppStoreIntent(packageName, false);
    }

    public static Intent getAppStoreIntent(String packageName, boolean isIncludeGooglePlayStore) {
        Intent leecoAppStoreIntent;
        Intent samsungAppStoreIntent;
        if (RomUtils.isSamsung() && (samsungAppStoreIntent = AppStoreUtils.getSamsungAppStoreIntent(packageName)) != null) {
            return samsungAppStoreIntent;
        }
        if (RomUtils.isLeeco() && (leecoAppStoreIntent = AppStoreUtils.getLeecoAppStoreIntent(packageName)) != null) {
            return leecoAppStoreIntent;
        }
        Uri uri = Uri.parse((String)("market://details?id=" + packageName));
        Intent intent = new Intent();
        intent.setData(uri);
        intent.addFlags(0x10000000);
        List resolveInfos = Utils.getApp().getPackageManager().queryIntentActivities(intent, 65536);
        if (resolveInfos == null || resolveInfos.size() == 0) {
            Log.e((String)TAG, (String)"No app store!");
            return null;
        }
        Intent googleIntent = null;
        for (ResolveInfo resolveInfo : resolveInfos) {
            String pkgName = resolveInfo.activityInfo.packageName;
            if (!GOOGLE_PLAY_APP_STORE_PACKAGE_NAME.equals(pkgName)) {
                if (!AppUtils.isAppSystem(pkgName)) continue;
                intent.setPackage(pkgName);
                return intent;
            }
            intent.setPackage(GOOGLE_PLAY_APP_STORE_PACKAGE_NAME);
            googleIntent = intent;
        }
        if (isIncludeGooglePlayStore && googleIntent != null) {
            return googleIntent;
        }
        intent.setPackage(((ResolveInfo)resolveInfos.get((int)0)).activityInfo.packageName);
        return intent;
    }

    private static Intent getSamsungAppStoreIntent(String packageName) {
        Intent intent = new Intent();
        intent.setClassName("com.sec.android.app.samsungapps", "com.sec.android.app.samsungapps.Main");
        intent.setData(Uri.parse((String)("http://www.samsungapps.com/appquery/appDetail.as?appId=" + packageName)));
        intent.addFlags(0x10000000);
        if (AppStoreUtils.getAvailableIntentSize(intent) > 0) {
            return intent;
        }
        return null;
    }

    private static Intent getLeecoAppStoreIntent(String packageName) {
        Intent intent = new Intent();
        intent.setClassName("com.letv.app.appstore", "com.letv.app.appstore.appmodule.details.DetailsActivity");
        intent.setAction("com.letv.app.appstore.appdetailactivity");
        intent.putExtra("packageName", packageName);
        intent.addFlags(0x10000000);
        if (AppStoreUtils.getAvailableIntentSize(intent) > 0) {
            return intent;
        }
        return null;
    }

    private static int getAvailableIntentSize(Intent intent) {
        return Utils.getApp().getPackageManager().queryIntentActivities(intent, 65536).size();
    }
}

