/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.pdf.PdfRenderer;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import android.util.LruCache;
import android.util.Size;
import androidx.compose.runtime.internal.StabilityInferred;
import com.rajat.pdfviewer.util.CommonUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0001\u0018\u0000 +2\u00020\u0001:\u0001+B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0006\u0010\u0011\u001a\u00020\u000eJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0006\u0010\u0015\u001a\u00020\tJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\tJ\b\u0010\u0018\u001a\u00020\u000eH\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\tJ\u001e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\tJi\u0010 \u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\n2Q\b\u0002\u0010!\u001aK\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b#\u0012\b\b$\u0012\u0004\b\b(%\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b#\u0012\b\b$\u0012\u0004\b\b(\u0013\u0012\u0015\u0012\u0013\u0018\u00010\n\u00a2\u0006\f\b#\u0012\b\b$\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u000e\u0018\u00010\"J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0002J\"\u0010)\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\n2\b\b\u0002\u0010*\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/rajat/pdfviewer/PdfRendererCore;", "", "context", "Landroid/content/Context;", "pdfFile", "Ljava/io/File;", "(Landroid/content/Context;Ljava/io/File;)V", "memoryCache", "Landroid/util/LruCache;", "", "Landroid/graphics/Bitmap;", "pdfRenderer", "Landroid/graphics/pdf/PdfRenderer;", "addBitmapToMemoryCache", "", "key", "bitmap", "closePdfRender", "decodeBitmapFromDiskCache", "pageNo", "getBitmapFromCache", "getPageCount", "getPageDimensions", "Landroid/util/Size;", "initCache", "openPdfFile", "pageExistInCache", "", "prefetchPages", "currentPage", "width", "height", "renderPage", "onBitmapReady", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "success", "sanitizeFilePath", "", "filePath", "writeBitmapToCache", "shouldCache", "Companion", "pdfViewer_release"})
@TargetApi(value=21)
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPdfRendererCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PdfRendererCore.kt\ncom/rajat/pdfviewer/PdfRendererCore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n1855#2,2:182\n*S KotlinDebug\n*F\n+ 1 PdfRendererCore.kt\ncom/rajat/pdfviewer/PdfRendererCore\n*L\n115#1:182,2\n*E\n"})
public final class PdfRendererCore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @Nullable
    private PdfRenderer pdfRenderer;
    @NotNull
    private final LruCache<Integer, Bitmap> memoryCache;
    public static final int $stable = 8;
    @NotNull
    private static final String CACHE_PATH = "___pdf___cache___";

    public PdfRendererCore(@NotNull Context context, @NotNull File pdfFile) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pdfFile, (String)"pdfFile");
        this.context = context;
        int maxMemory = (int)(Runtime.getRuntime().maxMemory() / (long)1024);
        int cacheSize = maxMemory / 8;
        this.memoryCache = (LruCache)new LruCache<Integer, Bitmap>(cacheSize){

            protected int sizeOf(int key, @NotNull Bitmap bitmap) {
                Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
                return bitmap.getByteCount() / 1024;
            }
        };
        String string = pdfFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        File safeFile = new File(this.sanitizeFilePath(string));
        this.openPdfFile(safeFile);
        this.initCache();
    }

    private final String sanitizeFilePath(String filePath) {
        String string;
        try {
            Path path;
            string = Build.VERSION.SDK_INT >= 26 ? (Files.exists(path = Paths.get(filePath, new String[0]), new LinkOption[0]) ? filePath : "") : filePath;
        }
        catch (Exception e) {
            string = "";
        }
        return string;
    }

    private final void initCache() {
        File cacheDir = new File(this.context.getCacheDir(), CACHE_PATH);
        if (cacheDir.exists()) {
            FilesKt.deleteRecursively((File)cacheDir);
        }
        cacheDir.mkdirs();
    }

    private final Bitmap getBitmapFromCache(int pageNo) {
        Bitmap bitmap = (Bitmap)this.memoryCache.get((Object)pageNo);
        if (bitmap == null) {
            bitmap = this.decodeBitmapFromDiskCache(pageNo);
        }
        return bitmap;
    }

    private final Bitmap decodeBitmapFromDiskCache(int pageNo) {
        Bitmap bitmap;
        File loadPath = new File(new File(this.context.getCacheDir(), CACHE_PATH), String.valueOf(pageNo));
        if (!loadPath.exists()) {
            return null;
        }
        Bitmap it = bitmap = BitmapFactory.decodeFile((String)loadPath.getAbsolutePath());
        boolean bl = false;
        if (it != null) {
            this.addBitmapToMemoryCache(pageNo, it);
        }
        return bitmap;
    }

    private final void addBitmapToMemoryCache(int key, Bitmap bitmap) {
        if (this.memoryCache.get((Object)key) == null) {
            this.memoryCache.put((Object)key, (Object)bitmap);
        }
    }

    private final void writeBitmapToCache(int pageNo, Bitmap bitmap, boolean shouldCache) {
        if (!shouldCache) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, pageNo, bitmap, null){
            int label;
            final /* synthetic */ PdfRendererCore this$0;
            final /* synthetic */ int $pageNo;
            final /* synthetic */ Bitmap $bitmap;
            {
                this.this$0 = $receiver;
                this.$pageNo = $pageNo;
                this.$bitmap = $bitmap;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            File savePath = new File(new File(PdfRendererCore.access$getContext$p(this.this$0).getCacheDir(), "___pdf___cache___"), String.valueOf(this.$pageNo));
                            Closeable closeable = new FileOutputStream(savePath);
                            Bitmap bitmap = this.$bitmap;
                            Throwable throwable = null;
                            try {
                                FileOutputStream fos = (FileOutputStream)closeable;
                                boolean bl = false;
                                boolean bl2 = bitmap.compress(Bitmap.CompressFormat.JPEG, 75, (OutputStream)fos);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                        }
                        catch (Exception e) {
                            Log.e((String)"PdfRendererCore", (String)("Error writing bitmap to cache: " + e.getMessage()));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    static /* synthetic */ void writeBitmapToCache$default(PdfRendererCore pdfRendererCore, int n, Bitmap bitmap, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        pdfRendererCore.writeBitmapToCache(n, bitmap, bl);
    }

    public final boolean pageExistInCache(int pageNo) {
        File loadPath = new File(new File(this.context.getCacheDir(), CACHE_PATH), String.valueOf(pageNo));
        return loadPath.exists();
    }

    public final void prefetchPages(int currentPage, int width, int height) {
        PdfRenderer pdfRenderer = this.pdfRenderer;
        Intrinsics.checkNotNull((Object)pdfRenderer);
        int dynamicPrefetchCount = CommonUtils.Companion.calculateDynamicPrefetchCount(this.context, pdfRenderer);
        IntRange prefetchRange = new IntRange(currentPage - dynamicPrefetchCount, currentPage + dynamicPrefetchCount);
        Iterable $this$forEach$iv = (Iterable)prefetchRange;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int pageNo = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            boolean bl2 = 0 <= pageNo ? pageNo < this.getPageCount() : false;
            if (!bl2 || this.pageExistInCache(pageNo)) continue;
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(width, height, this, pageNo, null){
                int label;
                final /* synthetic */ int $width;
                final /* synthetic */ int $height;
                final /* synthetic */ PdfRendererCore this$0;
                final /* synthetic */ int $pageNo;
                {
                    this.$width = $width;
                    this.$height = $height;
                    this.this$0 = $receiver;
                    this.$pageNo = $pageNo;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            Bitmap bitmap = CommonUtils.Companion.BitmapPool.INSTANCE.getBitmap(this.$width, this.$height);
                            this.this$0.renderPage(this.$pageNo, bitmap, (Function3<? super Boolean, ? super Integer, ? super Bitmap, Unit>)((Function3)new Function3<Boolean, Integer, Bitmap, Unit>(this.this$0, this.$pageNo, bitmap){
                                final /* synthetic */ PdfRendererCore this$0;
                                final /* synthetic */ int $pageNo;
                                final /* synthetic */ Bitmap $bitmap;
                                {
                                    this.this$0 = $receiver;
                                    this.$pageNo = $pageNo;
                                    this.$bitmap = $bitmap;
                                    super(3);
                                }

                                public final void invoke(boolean success, int n, @Nullable Bitmap renderedBitmap) {
                                    if (success) {
                                        Bitmap bitmap = renderedBitmap;
                                        if (bitmap == null) {
                                            bitmap = this.$bitmap;
                                        }
                                        PdfRendererCore.access$writeBitmapToCache(this.this$0, this.$pageNo, bitmap, true);
                                    } else {
                                        CommonUtils.Companion.BitmapPool.INSTANCE.recycleBitmap(this.$bitmap);
                                    }
                                }
                            }));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private final void openPdfFile(File pdfFile) {
        ParcelFileDescriptor fileDescriptor = ParcelFileDescriptor.open((File)pdfFile, (int)0x10000000);
        this.pdfRenderer = new PdfRenderer(fileDescriptor);
    }

    public final int getPageCount() {
        PdfRenderer pdfRenderer = this.pdfRenderer;
        return pdfRenderer != null ? pdfRenderer.getPageCount() : 0;
    }

    public final void renderPage(int pageNo, @NotNull Bitmap bitmap, @Nullable Function3<? super Boolean, ? super Integer, ? super Bitmap, Unit> onBitmapReady) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        if (pageNo >= this.getPageCount()) {
            Function3<? super Boolean, ? super Integer, ? super Bitmap, Unit> function3 = onBitmapReady;
            if (function3 != null) {
                function3.invoke((Object)false, (Object)pageNo, null);
            }
            return;
        }
        Bitmap cachedBitmap = this.getBitmapFromCache(pageNo);
        if (cachedBitmap != null) {
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(onBitmapReady, pageNo, cachedBitmap, null){
                int label;
                final /* synthetic */ Function3<Boolean, Integer, Bitmap, Unit> $onBitmapReady;
                final /* synthetic */ int $pageNo;
                final /* synthetic */ Bitmap $cachedBitmap;
                {
                    this.$onBitmapReady = $onBitmapReady;
                    this.$pageNo = $pageNo;
                    this.$cachedBitmap = $cachedBitmap;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            Function3<Boolean, Integer, Bitmap, Unit> function3 = this.$onBitmapReady;
                            if (function3 != null) {
                                function3.invoke((Object)Boxing.boxBoolean((boolean)true), (Object)Boxing.boxInt((int)this.$pageNo), (Object)this.$cachedBitmap);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            return;
        }
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, pageNo, bitmap, onBitmapReady, null){
            int label;
            final /* synthetic */ PdfRendererCore this$0;
            final /* synthetic */ int $pageNo;
            final /* synthetic */ Bitmap $bitmap;
            final /* synthetic */ Function3<Boolean, Integer, Bitmap, Unit> $onBitmapReady;
            {
                this.this$0 = $receiver;
                this.$pageNo = $pageNo;
                this.$bitmap = $bitmap;
                this.$onBitmapReady = $onBitmapReady;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        PdfRendererCore pdfRendererCore = this.this$0;
                        PdfRendererCore pdfRendererCore2 = this.this$0;
                        int n = this.$pageNo;
                        Bitmap bitmap = this.$bitmap;
                        Function3<Boolean, Integer, Bitmap, Unit> function3 = this.$onBitmapReady;
                        PdfRendererCore pdfRendererCore3 = pdfRendererCore;
                        synchronized (pdfRendererCore3) {
                            PdfRenderer.Page page;
                            boolean bl = false;
                            PdfRenderer pdfRenderer = PdfRendererCore.access$getPdfRenderer$p(pdfRendererCore2);
                            if (pdfRenderer != null && (pdfRenderer = (page = pdfRenderer.openPage(n))) != null) {
                                Intrinsics.checkNotNull((Object)pdfRenderer);
                                AutoCloseable autoCloseable = (AutoCloseable)page;
                                Throwable throwable = null;
                                try {
                                    PdfRenderer.Page pdfPage = (PdfRenderer.Page)autoCloseable;
                                    boolean bl2 = false;
                                    try {
                                        bitmap.eraseColor(-1);
                                        pdfPage.render(bitmap, null, null, 1);
                                        PdfRendererCore.access$addBitmapToMemoryCache(pdfRendererCore2, n, bitmap);
                                        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(pdfRendererCore2, n, bitmap, null){
                                            int label;
                                            final /* synthetic */ PdfRendererCore this$0;
                                            final /* synthetic */ int $pageNo;
                                            final /* synthetic */ Bitmap $bitmap;
                                            {
                                                this.this$0 = $receiver;
                                                this.$pageNo = $pageNo;
                                                this.$bitmap = $bitmap;
                                                super(2, $completion);
                                            }

                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        PdfRendererCore.writeBitmapToCache$default(this.this$0, this.$pageNo, this.$bitmap, false, 4, null);
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (int)3, null);
                                        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(function3, n, bitmap, null){
                                            int label;
                                            final /* synthetic */ Function3<Boolean, Integer, Bitmap, Unit> $onBitmapReady;
                                            final /* synthetic */ int $pageNo;
                                            final /* synthetic */ Bitmap $bitmap;
                                            {
                                                this.$onBitmapReady = $onBitmapReady;
                                                this.$pageNo = $pageNo;
                                                this.$bitmap = $bitmap;
                                                super(2, $completion);
                                            }

                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        Function3<Boolean, Integer, Bitmap, Unit> function3 = this.$onBitmapReady;
                                                        if (function3 != null) {
                                                            function3.invoke((Object)Boxing.boxBoolean((boolean)true), (Object)Boxing.boxInt((int)this.$pageNo), (Object)this.$bitmap);
                                                        }
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (int)3, null);
                                    }
                                    catch (Exception exception) {
                                        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(function3, n, null){
                                            int label;
                                            final /* synthetic */ Function3<Boolean, Integer, Bitmap, Unit> $onBitmapReady;
                                            final /* synthetic */ int $pageNo;
                                            {
                                                this.$onBitmapReady = $onBitmapReady;
                                                this.$pageNo = $pageNo;
                                                super(2, $completion);
                                            }

                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        Function3<Boolean, Integer, Bitmap, Unit> function3 = this.$onBitmapReady;
                                                        if (function3 != null) {
                                                            function3.invoke((Object)Boxing.boxBoolean((boolean)false), (Object)Boxing.boxInt((int)this.$pageNo), null);
                                                        }
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (int)3, null);
                                    }
                                    Unit unit = Unit.INSTANCE;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                                }
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static /* synthetic */ void renderPage$default(PdfRendererCore pdfRendererCore, int n, Bitmap bitmap, Function3 function3, int n2, Object object) {
        if ((n2 & 4) != 0) {
            function3 = null;
        }
        pdfRendererCore.renderPage(n, bitmap, (Function3<? super Boolean, ? super Integer, ? super Bitmap, Unit>)function3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Size getPageDimensions(int pageNo) {
        PdfRendererCore pdfRendererCore = this;
        synchronized (pdfRendererCore) {
            PdfRenderer.Page page;
            Size size;
            boolean bl = false;
            PdfRenderer.Page pdfPage = null;
            try {
                PdfRenderer pdfRenderer = this.pdfRenderer;
                Intrinsics.checkNotNull((Object)pdfRenderer);
                pdfPage = pdfRenderer.openPage(pageNo);
                size = new Size(pdfPage.getWidth(), pdfPage.getHeight());
                page = pdfPage;
            }
            catch (Throwable throwable) {
                PdfRenderer.Page page2 = pdfPage;
                if (page2 != null) {
                    page2.close();
                }
                throw throwable;
            }
            if (page != null) {
                page.close();
            }
            Size size2 = size;
            return size2;
        }
    }

    public final void closePdfRender() {
        PdfRenderer pdfRenderer = this.pdfRenderer;
        if (pdfRenderer != null) {
            pdfRenderer.close();
        }
        File cacheDir = new File(this.context.getCacheDir(), CACHE_PATH);
        if (cacheDir.exists()) {
            FilesKt.deleteRecursively((File)cacheDir);
        }
    }

    public static final /* synthetic */ Context access$getContext$p(PdfRendererCore $this) {
        return $this.context;
    }

    public static final /* synthetic */ void access$addBitmapToMemoryCache(PdfRendererCore $this, int key, Bitmap bitmap) {
        $this.addBitmapToMemoryCache(key, bitmap);
    }

    public static final /* synthetic */ PdfRenderer access$getPdfRenderer$p(PdfRendererCore $this) {
        return $this.pdfRenderer;
    }

    public static final /* synthetic */ void access$writeBitmapToCache(PdfRendererCore $this, int pageNo, Bitmap bitmap, boolean shouldCache) {
        $this.writeBitmapToCache(pageNo, bitmap, shouldCache);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/rajat/pdfviewer/PdfRendererCore$Companion;", "", "()V", "CACHE_PATH", "", "pdfViewer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

