/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.pdf.PdfRenderer;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import com.rajat.pdfviewer.PdfQuality;
import com.rajat.pdfviewer.PdfRendererCore;
import com.rajat.pdfviewer.PdfRendererCore$renderPage$1$invokeSuspend$;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 !2\u00020\u0001:\u0001!B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u00020\u000e0\u0012H\u0002J\u0006\u0010\u0014\u001a\u00020\u000eJ\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0016\u001a\u00020\u0010J\b\u0010\u0017\u001a\u00020\u000eH\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002JL\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102<\b\u0002\u0010\u001b\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\u0013\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u001cJ\u0018\u0010 \u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0013H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/rajat/pdfviewer/PdfRendererCore;", "", "context", "Landroid/content/Context;", "pdfFile", "Ljava/io/File;", "pdfQuality", "Lcom/rajat/pdfviewer/PdfQuality;", "(Landroid/content/Context;Ljava/io/File;Lcom/rajat/pdfviewer/PdfQuality;)V", "cachePath", "", "pdfRenderer", "Landroid/graphics/pdf/PdfRenderer;", "buildBitmap", "", "pageNo", "", "onBitmap", "Lkotlin/Function1;", "Landroid/graphics/Bitmap;", "closePdfRender", "getBitmapFromCache", "getPageCount", "initCache", "openPdfFile", "prefetchNext", "renderPage", "onBitmapReady", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "bitmap", "writeBitmapToCache", "Companion", "pdfViewer_release"})
@TargetApi(value=21)
public final class PdfRendererCore {
    private final String cachePath = "___pdf___cache___";
    private PdfRenderer pdfRenderer;
    private final Context context;
    private final PdfQuality pdfQuality;
    private static final int PREFETCH_COUNT = 3;
    public static final Companion Companion = new Companion(null);

    private final void initCache() {
        File cache = new File(this.context.getCacheDir(), this.cachePath);
        if (cache.exists()) {
            FilesKt.deleteRecursively((File)cache);
        }
        cache.mkdirs();
    }

    private final Bitmap getBitmapFromCache(int pageNo) {
        Bitmap bitmap;
        File loadPath = new File(new File(this.context.getCacheDir(), this.cachePath), String.valueOf(pageNo));
        if (!loadPath.exists()) {
            return null;
        }
        try {
            bitmap = BitmapFactory.decodeFile((String)loadPath.getAbsolutePath());
        }
        catch (Exception e) {
            bitmap = null;
        }
        return bitmap;
    }

    private final void writeBitmapToCache(int pageNo, Bitmap bitmap) throws IOException {
        File savePath = new File(new File(this.context.getCacheDir(), this.cachePath), String.valueOf(pageNo));
        savePath.createNewFile();
        FileOutputStream fos = new FileOutputStream(savePath);
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
        fos.flush();
        fos.close();
    }

    private final void openPdfFile(File pdfFile) {
        try {
            ParcelFileDescriptor fileDescriptor = ParcelFileDescriptor.open((File)pdfFile, (int)0x10000000);
            this.pdfRenderer = new PdfRenderer(fileDescriptor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final int getPageCount() {
        PdfRenderer pdfRenderer = this.pdfRenderer;
        return pdfRenderer != null ? pdfRenderer.getPageCount() : 0;
    }

    public final void renderPage(int pageNo, @Nullable Function2<? super Bitmap, ? super Integer, Unit> onBitmapReady) {
        if (pageNo >= this.getPageCount()) {
            return;
        }
        BuildersKt.async$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, pageNo, onBitmapReady, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ PdfRendererCore this$0;
            final /* synthetic */ int $pageNo;
            final /* synthetic */ Function2 $onBitmapReady;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Unit unit;
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$async = this.p$;
                        PdfRendererCore pdfRendererCore = this.this$0;
                        boolean bl = false;
                        boolean bl2 = false;
                        synchronized (pdfRendererCore) {
                            Unit unit2;
                            boolean bl3 = false;
                            PdfRendererCore.access$buildBitmap(this.this$0, this.$pageNo, (Function1)new Function1<Bitmap, Unit>(this){
                                final /* synthetic */ renderPage.1 this$0;
                                {
                                    this.this$0 = var1_1;
                                    super(1);
                                }

                                public final void invoke(@Nullable Bitmap bitmap) {
                                    BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, bitmap, null){
                                        private CoroutineScope p$;
                                        int label;
                                        final /* synthetic */ renderPage$1$invokeSuspend$$inlined$synchronized$lambda$1 this$0;
                                        final /* synthetic */ Bitmap $bitmap;
                                        {
                                            this.this$0 = var1_1;
                                            this.$bitmap = bitmap;
                                            super(2, continuation);
                                        }

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object $result) {
                                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    CoroutineScope $this$launch = this.p$;
                                                    Function2 function2 = this.this$0.this$0.$onBitmapReady;
                                                    if (function2 != null) {
                                                        Unit cfr_ignored_0 = (Unit)function2.invoke((Object)this.$bitmap, (Object)Boxing.boxInt((int)this.this$0.this$0.$pageNo));
                                                    }
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                            Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                            CoroutineScope cfr_ignored_0 = (CoroutineScope)value;
                                            function2.p$ = (CoroutineScope)value;
                                            Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
                                            return function22;
                                        }

                                        public final Object invoke(Object object, Object object2) {
                                            return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)2, null);
                                }
                            });
                            Function2 function2 = this.$onBitmapReady;
                            if (function2 != null) {
                                Function2 function22 = function2;
                                boolean bl4 = false;
                                boolean bl5 = false;
                                Function2 it = function22;
                                boolean bl6 = false;
                                unit2 = Unit.INSTANCE;
                            } else {
                                unit2 = null;
                            }
                            unit = unit2;
                        }
                        return unit;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = pdfRendererCore;
                this.$pageNo = n;
                this.$onBitmapReady = function2;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static /* synthetic */ void renderPage$default(PdfRendererCore pdfRendererCore, int n, Function2 function2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            function2 = null;
        }
        pdfRendererCore.renderPage(n, (Function2<? super Bitmap, ? super Integer, Unit>)function2);
    }

    /*
     * WARNING - void declaration
     */
    private final void prefetchNext(int pageNo) {
        int n = this.getPageCount();
        int n2 = pageNo + 3;
        boolean bl = false;
        int countForPrefetch = Math.min(n, n2);
        n = pageNo;
        n2 = countForPrefetch;
        while (n < n2) {
            void pageToPrefetch;
            PdfRendererCore.renderPage$default(this, (int)pageToPrefetch, null, 2, null);
            ++pageToPrefetch;
        }
    }

    private final void buildBitmap(int pageNo, Function1<? super Bitmap, Unit> onBitmap) {
        Bitmap bitmap;
        Bitmap bitmap2 = bitmap = this.getBitmapFromCache(pageNo);
        if (bitmap2 != null) {
            Bitmap bitmap3 = bitmap2;
            boolean bl = false;
            boolean bl2 = false;
            Bitmap it = bitmap3;
            boolean bl3 = false;
            onBitmap.invoke((Object)it);
            return;
        }
        long startTime = System.currentTimeMillis();
        try {
            PdfRenderer.Page pdfPage;
            PdfRenderer pdfRenderer = this.pdfRenderer;
            if (pdfRenderer == null) {
                Intrinsics.throwNpe();
            }
            PdfRenderer.Page page = pdfPage = pdfRenderer.openPage(pageNo);
            Intrinsics.checkExpressionValueIsNotNull((Object)page, (String)"pdfPage");
            bitmap = Bitmap.createBitmap((int)(page.getWidth() * this.pdfQuality.getRatio()), (int)(pdfPage.getHeight() * this.pdfQuality.getRatio()), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            if (bitmap == null) {
                return;
            }
            pdfPage.render(bitmap, null, null, 1);
            pdfPage.close();
            this.writeBitmapToCache(pageNo, bitmap);
            onBitmap.invoke((Object)bitmap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void closePdfRender() {
        if (this.pdfRenderer != null) {
            try {
                PdfRenderer pdfRenderer = this.pdfRenderer;
                if (pdfRenderer == null) {
                    Intrinsics.throwNpe();
                }
                pdfRenderer.close();
            }
            catch (Exception e) {
                Log.e((String)"PdfRendererCore", (String)e.toString());
            }
        }
    }

    public PdfRendererCore(@NotNull Context context, @NotNull File pdfFile, @NotNull PdfQuality pdfQuality) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)pdfFile, (String)"pdfFile");
        Intrinsics.checkParameterIsNotNull((Object)((Object)pdfQuality), (String)"pdfQuality");
        this.context = context;
        this.pdfQuality = pdfQuality;
        this.cachePath = "___pdf___cache___";
        this.initCache();
        this.openPdfFile(pdfFile);
    }

    public static final /* synthetic */ void access$buildBitmap(PdfRendererCore $this, int pageNo, Function1 onBitmap) {
        $this.buildBitmap(pageNo, (Function1<? super Bitmap, Unit>)onBitmap);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/rajat/pdfviewer/PdfRendererCore$Companion;", "", "()V", "PREFETCH_COUNT", "", "pdfViewer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

