/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer.util;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.TypedValue;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorRes;
import androidx.annotation.StyleRes;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.ContextCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0004J\"\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\b2\b\b\u0001\u0010\u000e\u001a\u00020\bJ\u001e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bJ\u001e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bJ\"\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\b2\b\b\u0001\u0010\u000e\u001a\u00020\b\u00a8\u0006\u0014"}, d2={"Lcom/rajat/pdfviewer/util/ThemeUtils;", "", "()V", "getBooleanFromTypedArray", "", "typedArray", "Landroid/content/res/TypedArray;", "index", "", "default", "getColorFromAttr", "context", "Landroid/content/Context;", "attrRes", "fallbackRes", "getColorFromTypedArray", "fallbackColor", "getResIdFromTypedArray", "fallbackResId", "getResourceIdFromAttr", "pdfViewer_release"})
@StabilityInferred(parameters=1)
public final class ThemeUtils {
    @NotNull
    public static final ThemeUtils INSTANCE = new ThemeUtils();
    public static final int $stable;

    private ThemeUtils() {
    }

    public final int getColorFromAttr(@NotNull Context context, @AttrRes int attrRes, @ColorRes int fallbackRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TypedValue typedValue = new TypedValue();
        return context.getTheme().resolveAttribute(attrRes, typedValue, true) ? typedValue.data : ContextCompat.getColor((Context)context, (int)fallbackRes);
    }

    public final int getResourceIdFromAttr(@NotNull Context context, @AttrRes int attrRes, @StyleRes int fallbackRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TypedValue typedValue = new TypedValue();
        return context.getTheme().resolveAttribute(attrRes, typedValue, true) ? typedValue.resourceId : fallbackRes;
    }

    public final boolean getBooleanFromTypedArray(@NotNull TypedArray typedArray, int index, boolean bl) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)typedArray, (String)"typedArray");
        try {
            bl2 = typedArray.getBoolean(index, bl);
        }
        catch (Exception e) {
            bl2 = bl;
        }
        return bl2;
    }

    public static /* synthetic */ boolean getBooleanFromTypedArray$default(ThemeUtils themeUtils, TypedArray typedArray, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return themeUtils.getBooleanFromTypedArray(typedArray, n, bl);
    }

    public final int getColorFromTypedArray(@NotNull TypedArray typedArray, int index, int fallbackColor) {
        int n;
        Intrinsics.checkNotNullParameter((Object)typedArray, (String)"typedArray");
        try {
            n = typedArray.getColor(index, fallbackColor);
        }
        catch (Exception e) {
            n = fallbackColor;
        }
        return n;
    }

    public final int getResIdFromTypedArray(@NotNull TypedArray typedArray, int index, int fallbackResId) {
        int n;
        Intrinsics.checkNotNullParameter((Object)typedArray, (String)"typedArray");
        try {
            n = typedArray.getResourceId(index, fallbackResId);
        }
        catch (Exception e) {
            n = fallbackResId;
        }
        return n;
    }
}

