/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.util.Log;
import android.util.Size;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.recyclerview.widget.RecyclerView;
import com.rajat.pdfviewer.PdfRendererCore;
import com.rajat.pdfviewer.databinding.ListItemPdfPageBinding;
import com.rajat.pdfviewer.util.CommonUtils;
import com.rajat.pdfviewer.util.ViewExtKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0001\u0016B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u001c\u0010\u0012\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/rajat/pdfviewer/PdfViewAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/rajat/pdfviewer/PdfViewAdapter$PdfPageViewHolder;", "context", "Landroid/content/Context;", "renderer", "Lcom/rajat/pdfviewer/PdfRendererCore;", "pageSpacing", "Landroid/graphics/Rect;", "enableLoadingForPages", "", "(Landroid/content/Context;Lcom/rajat/pdfviewer/PdfRendererCore;Landroid/graphics/Rect;Z)V", "getItemCount", "", "onBindViewHolder", "", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "PdfPageViewHolder", "pdfViewer_release"})
@StabilityInferred(parameters=0)
public final class PdfViewAdapter
extends RecyclerView.Adapter<PdfPageViewHolder> {
    @NotNull
    private final Context context;
    @NotNull
    private final PdfRendererCore renderer;
    @NotNull
    private final Rect pageSpacing;
    private final boolean enableLoadingForPages;
    public static final int $stable = 8;

    public PdfViewAdapter(@NotNull Context context, @NotNull PdfRendererCore renderer, @NotNull Rect pageSpacing, boolean enableLoadingForPages) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)pageSpacing, (String)"pageSpacing");
        this.context = context;
        this.renderer = renderer;
        this.pageSpacing = pageSpacing;
        this.enableLoadingForPages = enableLoadingForPages;
    }

    @NotNull
    public PdfPageViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        ListItemPdfPageBinding listItemPdfPageBinding = ListItemPdfPageBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)listItemPdfPageBinding, (String)"inflate(...)");
        return new PdfPageViewHolder(listItemPdfPageBinding);
    }

    public int getItemCount() {
        return this.renderer.getPageCount();
    }

    public void onBindViewHolder(@NotNull PdfPageViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        holder.bind(position);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/rajat/pdfviewer/PdfViewAdapter$PdfPageViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemBinding", "Lcom/rajat/pdfviewer/databinding/ListItemPdfPageBinding;", "(Lcom/rajat/pdfviewer/PdfViewAdapter;Lcom/rajat/pdfviewer/databinding/ListItemPdfPageBinding;)V", "applyFadeInAnimation", "", "view", "Landroid/view/View;", "bind", "position", "", "calculateBitmapHeight", "width", "handleLoadingForPage", "pdfViewer_release"})
    public final class PdfPageViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final ListItemPdfPageBinding itemBinding;

        public PdfPageViewHolder(ListItemPdfPageBinding itemBinding) {
            Intrinsics.checkNotNullParameter((Object)itemBinding, (String)"itemBinding");
            super((View)itemBinding.getRoot());
            this.itemBinding = itemBinding;
        }

        public final void bind(int position) {
            ListItemPdfPageBinding listItemPdfPageBinding = this.itemBinding;
            PdfViewAdapter pdfViewAdapter = PdfViewAdapter.this;
            ListItemPdfPageBinding $this$bind_u24lambda_u241 = listItemPdfPageBinding;
            boolean bl = false;
            this.handleLoadingForPage(position);
            if ($this$bind_u24lambda_u241.pageView.getWidth() == 0 || $this$bind_u24lambda_u241.pageView.getHeight() == 0) {
                $this$bind_u24lambda_u241.pageView.post(() -> PdfPageViewHolder.bind$lambda$1$lambda$0(this, position));
                return;
            }
            int width = $this$bind_u24lambda_u241.pageView.getWidth();
            int height = this.calculateBitmapHeight(width, position);
            Bitmap bitmap = CommonUtils.Companion.BitmapPool.INSTANCE.getBitmap(width, height);
            int itemHeight = this.calculateBitmapHeight(this.itemBinding.getRoot().getWidth(), position);
            ViewGroup.LayoutParams layoutParams = this.itemBinding.getRoot().getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
            ViewGroup.MarginLayoutParams layoutParams2 = (ViewGroup.MarginLayoutParams)layoutParams;
            Log.i((String)"Item height", (String)("" + width + '-' + height + '-' + itemHeight + '-' + layoutParams2.height));
            layoutParams2.height = itemHeight;
            layoutParams2.setMargins(((PdfViewAdapter)pdfViewAdapter).pageSpacing.left, ((PdfViewAdapter)pdfViewAdapter).pageSpacing.top, ((PdfViewAdapter)pdfViewAdapter).pageSpacing.right, ((PdfViewAdapter)pdfViewAdapter).pageSpacing.bottom);
            this.itemBinding.getRoot().setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
            Log.d((String)"PdfViewAdapter", (String)("BEFORE    Bitmap Width: " + width + ", Device Width: " + ((PdfViewAdapter)pdfViewAdapter).context.getResources().getDisplayMetrics().widthPixels));
            pdfViewAdapter.renderer.renderPage(position, bitmap, (Function3<? super Boolean, ? super Integer, ? super Bitmap, Unit>)((Function3)new Function3<Boolean, Integer, Bitmap, Unit>(position, pdfViewAdapter, width, height, bitmap, this, $this$bind_u24lambda_u241){
                final /* synthetic */ int $position;
                final /* synthetic */ PdfViewAdapter this$0;
                final /* synthetic */ int $width;
                final /* synthetic */ int $height;
                final /* synthetic */ Bitmap $bitmap;
                final /* synthetic */ PdfPageViewHolder this$1;
                final /* synthetic */ ListItemPdfPageBinding $this_with;
                {
                    this.$position = $position;
                    this.this$0 = $receiver;
                    this.$width = $width;
                    this.$height = $height;
                    this.$bitmap = $bitmap;
                    this.this$1 = $receiver2;
                    this.$this_with = $receiver3;
                    super(3);
                }

                public final void invoke(boolean success, int pageNo, @Nullable Bitmap renderedBitmap) {
                    if (success && pageNo == this.$position) {
                        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$1, renderedBitmap, this.$bitmap, this.$this_with, null){
                            int label;
                            final /* synthetic */ PdfPageViewHolder this$0;
                            final /* synthetic */ Bitmap $renderedBitmap;
                            final /* synthetic */ Bitmap $bitmap;
                            final /* synthetic */ ListItemPdfPageBinding $this_with;
                            {
                                this.this$0 = $receiver;
                                this.$renderedBitmap = $renderedBitmap;
                                this.$bitmap = $bitmap;
                                this.$this_with = $receiver2;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        Bitmap it;
                                        ResultKt.throwOnFailure((Object)object);
                                        PdfPageViewHolder.access$getItemBinding$p((PdfPageViewHolder)this.this$0).pageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
                                        Bitmap bitmap = this.$renderedBitmap;
                                        if (bitmap != null) {
                                            it = bitmap;
                                            boolean bl = false;
                                            Boxing.boxInt((int)Log.d((String)"PdfViewAdapter", (String)("renderedBitmap Width: " + it.getWidth() + ", Bitmap Height: " + it.getHeight())));
                                        }
                                        Bitmap bitmap2 = this.$bitmap;
                                        if (bitmap2 != null) {
                                            it = bitmap2;
                                            boolean bl = false;
                                            Boxing.boxInt((int)Log.d((String)"PdfViewAdapter", (String)("Bitmap Width: " + it.getWidth() + ", Bitmap Height: " + it.getHeight())));
                                        }
                                        ImageView imageView = PdfPageViewHolder.access$getItemBinding$p((PdfPageViewHolder)this.this$0).pageView;
                                        Bitmap bitmap3 = this.$renderedBitmap;
                                        Bitmap bitmap4 = this.$bitmap;
                                        ImageView $this$invokeSuspend_u24lambda_u242 = imageView;
                                        boolean bl = false;
                                        Bitmap bitmap5 = bitmap3;
                                        if (bitmap5 == null) {
                                            bitmap5 = bitmap4;
                                        }
                                        $this$invokeSuspend_u24lambda_u242.setImageBitmap(bitmap5);
                                        ImageView imageView2 = this.$this_with.pageView;
                                        Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"pageView");
                                        PdfPageViewHolder.access$applyFadeInAnimation(this.this$0, (View)imageView2);
                                        ProgressBar progressBar = this.$this_with.pageLoadingLayout.pdfViewPageLoadingProgress;
                                        Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"pdfViewPageLoadingProgress");
                                        ViewExtKt.hide((View)progressBar);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        PdfViewAdapter.access$getRenderer$p(this.this$0).prefetchPages(this.$position, this.$width, this.$height);
                    } else {
                        CommonUtils.Companion.BitmapPool.INSTANCE.recycleBitmap(this.$bitmap);
                    }
                }
            }));
        }

        private final int calculateBitmapHeight(int width, int position) {
            Size pageDimensions = PdfViewAdapter.this.renderer.getPageDimensions(position);
            float aspectRatio = (float)pageDimensions.getWidth() / (float)pageDimensions.getHeight();
            return (int)((float)width / aspectRatio);
        }

        /*
         * WARNING - void declaration
         */
        private final void applyFadeInAnimation(View view) {
            void $this$applyFadeInAnimation_u24lambda_u242;
            AlphaAnimation alphaAnimation;
            AlphaAnimation alphaAnimation2 = alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
            View view2 = view;
            boolean bl = false;
            $this$applyFadeInAnimation_u24lambda_u242.setInterpolator((Interpolator)new LinearInterpolator());
            $this$applyFadeInAnimation_u24lambda_u242.setDuration(300L);
            $this$applyFadeInAnimation_u24lambda_u242.start();
            view2.setAnimation((Animation)alphaAnimation);
        }

        private final void handleLoadingForPage(int position) {
            ListItemPdfPageBinding listItemPdfPageBinding = this.itemBinding;
            PdfViewAdapter pdfViewAdapter = PdfViewAdapter.this;
            ListItemPdfPageBinding $this$handleLoadingForPage_u24lambda_u243 = listItemPdfPageBinding;
            boolean bl = false;
            if (!pdfViewAdapter.enableLoadingForPages || pdfViewAdapter.renderer.pageExistInCache(position)) {
                ProgressBar progressBar = $this$handleLoadingForPage_u24lambda_u243.pageLoadingLayout.pdfViewPageLoadingProgress;
                Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"pdfViewPageLoadingProgress");
                ViewExtKt.hide((View)progressBar);
            } else {
                ProgressBar progressBar = $this$handleLoadingForPage_u24lambda_u243.pageLoadingLayout.pdfViewPageLoadingProgress;
                Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"pdfViewPageLoadingProgress");
                ViewExtKt.show((View)progressBar);
            }
        }

        private static final void bind$lambda$1$lambda$0(PdfPageViewHolder this$0, int $position) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            this$0.bind($position);
        }

        public static final /* synthetic */ ListItemPdfPageBinding access$getItemBinding$p(PdfPageViewHolder $this) {
            return $this.itemBinding;
        }

        public static final /* synthetic */ void access$applyFadeInAnimation(PdfPageViewHolder $this, View view) {
            $this.applyFadeInAnimation(view);
        }
    }
}

