/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer.util;

import android.content.Context;
import android.os.Environment;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ(\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\rJ\u0016\u0010\u0010\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0011"}, d2={"Lcom/rajat/pdfviewer/util/FileUtils;", "", "()V", "copy", "", "inputStream", "Ljava/io/InputStream;", "output", "Ljava/io/File;", "downloadFile", "context", "Landroid/content/Context;", "assetName", "", "filePath", "fileName", "fileFromAsset", "pdfViewer_release"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();

    private FileUtils() {
    }

    @NotNull
    public final File fileFromAsset(@NotNull Context context, @NotNull String assetName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)assetName, (String)"assetName");
        File outFile = new File(context.getCacheDir(), String.valueOf(assetName));
        if (StringsKt.contains$default((CharSequence)assetName, (CharSequence)"/", (boolean)false, (int)2, null)) {
            outFile.getParentFile().mkdirs();
        }
        this.copy(context.getAssets().open(assetName), outFile);
        return outFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void copy(@Nullable InputStream inputStream, @Nullable File output) throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(output);
            int read = 0;
            byte[] bytes = new byte[1024];
            while (true) {
                int n;
                InputStream inputStream2 = inputStream;
                Intrinsics.checkNotNull((Object)inputStream2);
                int it = n = inputStream2.read(bytes);
                boolean bl = false;
                read = it;
                if (n != -1) {
                    ((FileOutputStream)outputStream).write(bytes, 0, read);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            try {
                InputStream inputStream3 = inputStream;
                if (inputStream3 == null) throw throwable;
                inputStream3.close();
                throw throwable;
            }
            finally {
                OutputStream outputStream2 = outputStream;
                if (outputStream2 != null) {
                    outputStream2.close();
                }
            }
        }
        try {
            inputStream.close();
            return;
        }
        finally {
            outputStream.close();
        }
    }

    public final void downloadFile(@NotNull Context context, @NotNull String assetName, @NotNull String filePath, @Nullable String fileName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)assetName, (String)"assetName");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        String dirPath = Environment.getExternalStorageDirectory() + "/" + filePath;
        File outFile = new File(dirPath);
        if (!outFile.exists()) {
            outFile.mkdirs();
        }
        File outFile1 = new File(dirPath, "/" + fileName + ".pdf");
        this.copy(context.getAssets().open(assetName), outFile1);
    }
}

