/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 %2\u00020\u0001:\u0002%&B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B#\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\tH\u0014J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/rajat/pdfviewer/PinchZoomRecyclerView;", "Landroidx/recyclerview/widget/RecyclerView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "height", "", "mActivePointerId", "mLastTouchX", "mLastTouchY", "mPosX", "mPosY", "mScaleDetector", "Landroid/view/ScaleGestureDetector;", "mScaleFactor", "maxHeight", "maxWidth", "width", "dispatchDraw", "", "canvas", "Landroid/graphics/Canvas;", "onDraw", "onInterceptTouchEvent", "", "ev", "Landroid/view/MotionEvent;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onTouchEvent", "Companion", "ScaleListener", "pdfViewer_release"})
public final class PinchZoomRecyclerView
extends RecyclerView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int mActivePointerId;
    @Nullable
    private ScaleGestureDetector mScaleDetector;
    private float mScaleFactor;
    private float maxWidth;
    private float maxHeight;
    private float mLastTouchX;
    private float mLastTouchY;
    private float mPosX;
    private float mPosY;
    private float width;
    private float height;
    @NotNull
    public Map<Integer, View> _$_findViewCache = new LinkedHashMap();
    private static final int INVALID_POINTER_ID = -1;

    public PinchZoomRecyclerView(@Nullable Context context) {
        Context context2 = context;
        Intrinsics.checkNotNull((Object)context2);
        super(context2);
        this.mActivePointerId = -1;
        this.mScaleFactor = 1.0f;
        if (!this.isInEditMode()) {
            this.mScaleDetector = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        }
    }

    public PinchZoomRecyclerView(@Nullable Context context, @Nullable AttributeSet attrs) {
        Context context2 = context;
        Intrinsics.checkNotNull((Object)context2);
        super(context2, attrs);
        this.mActivePointerId = -1;
        this.mScaleFactor = 1.0f;
        if (!this.isInEditMode()) {
            this.mScaleDetector = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        }
    }

    public PinchZoomRecyclerView(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Context context2 = context;
        Intrinsics.checkNotNull((Object)context2);
        super(context2, attrs, defStyleAttr);
        this.mActivePointerId = -1;
        this.mScaleFactor = 1.0f;
        if (!this.isInEditMode()) {
            this.mScaleDetector = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public boolean onInterceptTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        try {
            return super.onInterceptTouchEvent(ev);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean onTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        super.onTouchEvent(ev);
        int action = ev.getAction();
        ScaleGestureDetector scaleGestureDetector = this.mScaleDetector;
        Intrinsics.checkNotNull((Object)scaleGestureDetector);
        scaleGestureDetector.onTouchEvent(ev);
        switch (action & 0xFF) {
            case 0: {
                float x = ev.getX();
                float y = ev.getY();
                this.mLastTouchX = x;
                this.mLastTouchY = y;
                this.mActivePointerId = ev.getPointerId(0);
                break;
            }
            case 2: {
                int pointerIndex = (action & 0xFF00) >> 8;
                float x = ev.getX(pointerIndex);
                float y = ev.getY(pointerIndex);
                float dx = x - this.mLastTouchX;
                float dy = y - this.mLastTouchY;
                this.mPosX += dx;
                this.mPosY += dy;
                if (this.mPosX > 0.0f) {
                    this.mPosX = 0.0f;
                } else if (this.mPosX < this.maxWidth) {
                    this.mPosX = this.maxWidth;
                }
                if (this.mPosY > 0.0f) {
                    this.mPosY = 0.0f;
                } else if (this.mPosY < this.maxHeight) {
                    this.mPosY = this.maxHeight;
                }
                this.mLastTouchX = x;
                this.mLastTouchY = y;
                this.invalidate();
                break;
            }
            case 1: {
                this.mActivePointerId = -1;
                break;
            }
            case 3: {
                this.mActivePointerId = -1;
                break;
            }
            case 6: {
                int pointerIndex = (action & 0xFF00) >> 8;
                int pointerId = ev.getPointerId(pointerIndex);
                if (pointerId != this.mActivePointerId) break;
                int newPointerIndex = pointerIndex == 0 ? 1 : 0;
                this.mLastTouchX = ev.getX(newPointerIndex);
                this.mLastTouchY = ev.getY(newPointerIndex);
                this.mActivePointerId = ev.getPointerId(newPointerIndex);
            }
        }
        return true;
    }

    public void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        canvas.save();
        canvas.translate(this.mPosX, this.mPosY);
        canvas.scale(this.mScaleFactor, this.mScaleFactor);
        canvas.restore();
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.save();
        if (this.mScaleFactor == 1.0f) {
            this.mPosX = 0.0f;
            this.mPosY = 0.0f;
        }
        canvas.translate(this.mPosX, this.mPosY);
        canvas.scale(this.mScaleFactor, this.mScaleFactor);
        super.dispatchDraw(canvas);
        canvas.restore();
        this.invalidate();
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2 = this.findViewById(id2);
            if (view2 != null) {
                map.put(id2, view2);
                view = view2;
            } else {
                view = null;
            }
        }
        return view;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/rajat/pdfviewer/PinchZoomRecyclerView$ScaleListener;", "Landroid/view/ScaleGestureDetector$SimpleOnScaleGestureListener;", "(Lcom/rajat/pdfviewer/PinchZoomRecyclerView;)V", "onScale", "", "detector", "Landroid/view/ScaleGestureDetector;", "pdfViewer_release"})
    private final class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        public boolean onScale(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
            float scale = detector.getScaleFactor();
            PinchZoomRecyclerView.this.mScaleFactor = RangesKt.coerceAtLeast((float)1.0f, (float)RangesKt.coerceAtMost((float)(PinchZoomRecyclerView.this.mScaleFactor * scale), (float)3.0f));
            if (PinchZoomRecyclerView.this.mScaleFactor < 3.0f) {
                float centerX = detector.getFocusX();
                float centerY = detector.getFocusY();
                float diffX = centerX - PinchZoomRecyclerView.this.mPosX;
                float diffY = centerY - PinchZoomRecyclerView.this.mPosY;
                diffX = diffX * detector.getScaleFactor() - diffX;
                diffY = diffY * detector.getScaleFactor() - diffY;
                PinchZoomRecyclerView pinchZoomRecyclerView = PinchZoomRecyclerView.this;
                pinchZoomRecyclerView.mPosX = pinchZoomRecyclerView.mPosX - diffX;
                pinchZoomRecyclerView = PinchZoomRecyclerView.this;
                pinchZoomRecyclerView.mPosY = pinchZoomRecyclerView.mPosY - diffY;
            }
            PinchZoomRecyclerView.this.maxWidth = PinchZoomRecyclerView.this.width - PinchZoomRecyclerView.this.width * PinchZoomRecyclerView.this.mScaleFactor;
            PinchZoomRecyclerView.this.maxHeight = PinchZoomRecyclerView.this.height - PinchZoomRecyclerView.this.height * PinchZoomRecyclerView.this.mScaleFactor;
            PinchZoomRecyclerView.this.invalidate();
            return true;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/rajat/pdfviewer/PinchZoomRecyclerView$Companion;", "", "()V", "INVALID_POINTER_ID", "", "pdfViewer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

