/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer;

import android.app.Activity;
import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.rajat.pdfviewer.PdfEngine;
import com.rajat.pdfviewer.PdfQuality;
import com.rajat.pdfviewer.PdfRendererView;
import com.rajat.pdfviewer.R;
import com.rajat.pdfviewer.util.FileUtils;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\u0018\u0000 12\u00020\u0001:\u00011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\b\u0010\u0014\u001a\u00020\u0010H\u0002J\b\u0010\u0015\u001a\u00020\u0010H\u0002J\b\u0010\u0016\u001a\u00020\u0010H\u0002J\u001a\u0010\u0017\u001a\u00020\u00102\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u00020\u00102\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010\u001c\u001a\u00020\u00102\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010\u001d\u001a\u00020\u00102\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0014J\u0012\u0010 \u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010#\u001a\u00020\u0010H\u0014J\u0010\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u0006H\u0016J\b\u0010&\u001a\u00020\u0010H\u0002J\u0012\u0010'\u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J-\u0010(\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040*2\u0006\u0010+\u001a\u00020,H\u0016\u00a2\u0006\u0002\u0010-J\u0010\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\u0004H\u0002J\f\u00100\u001a\u00020\u0010*\u00020\nH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u00062"}, d2={"Lcom/rajat/pdfviewer/PdfViewerActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "fileUrl", "", "menuItem", "Landroid/view/MenuItem;", "onComplete", "Landroid/content/BroadcastReceiver;", "permissionGranted", "", "Ljava/lang/Boolean;", "checkInternetConnection", "context", "Landroid/content/Context;", "checkPermission", "", "requestCode", "", "checkPermissionOnInit", "downloadPdf", "enableDownload", "init", "initPdfViewer", "engine", "Lcom/rajat/pdfviewer/PdfEngine;", "initPdfViewerWithPath", "filePath", "loadFileFromNetwork", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "menu", "Landroid/view/Menu;", "onDestroy", "onOptionsItemSelected", "item", "onPdfError", "onPrepareOptionsMenu", "onRequestPermissionsResult", "permissions", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "setUpToolbar", "toolbarTitle", "showProgressBar", "Companion", "pdfViewer_release"})
public final class PdfViewerActivity
extends AppCompatActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Boolean permissionGranted = false;
    @Nullable
    private MenuItem menuItem;
    @Nullable
    private String fileUrl;
    @NotNull
    private BroadcastReceiver onComplete;
    @NotNull
    public Map<Integer, View> _$_findViewCache = new LinkedHashMap();
    @NotNull
    public static final String FILE_URL = "pdf_file_url";
    @NotNull
    public static final String FILE_DIRECTORY = "pdf_file_directory";
    @NotNull
    public static final String FILE_TITLE = "pdf_file_title";
    @NotNull
    public static final String ENABLE_FILE_DOWNLOAD = "enable_download";
    @NotNull
    public static final String FROM_ASSETS = "from_assests";
    @NotNull
    private static PdfEngine engine = PdfEngine.INTERNAL;
    private static boolean enableDownload = true;
    private static boolean isPDFFromPath;
    private static boolean isFromAssets;
    private static int PERMISSION_CODE;

    public PdfViewerActivity() {
        this.onComplete = new BroadcastReceiver(){

            public void onReceive(@Nullable Context context, @Nullable Intent intent) {
                block0: {
                    Toast.makeText((Context)context, (CharSequence)"File is Downloaded Successfully", (int)0).show();
                    Context context2 = context;
                    if (context2 == null) break block0;
                    context2.unregisterReceiver((BroadcastReceiver)this);
                }
            }
        };
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_pdf_viewer);
        Bundle bundle = this.getIntent().getExtras();
        Intrinsics.checkNotNull((Object)bundle);
        String string = bundle.getString(FILE_TITLE, "PDF");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"intent.extras!!.getStrin\u2026      \"PDF\"\n            )");
        this.setUpToolbar(string);
        Bundle bundle2 = this.getIntent().getExtras();
        Intrinsics.checkNotNull((Object)bundle2);
        enableDownload = bundle2.getBoolean(ENABLE_FILE_DOWNLOAD, true);
        Bundle bundle3 = this.getIntent().getExtras();
        Intrinsics.checkNotNull((Object)bundle3);
        isFromAssets = bundle3.getBoolean(FROM_ASSETS, false);
        engine = PdfEngine.INTERNAL;
        this.init();
    }

    private final void init() {
        Bundle bundle = this.getIntent().getExtras();
        Intrinsics.checkNotNull((Object)bundle);
        if (bundle.containsKey(FILE_URL)) {
            Bundle bundle2 = this.getIntent().getExtras();
            Intrinsics.checkNotNull((Object)bundle2);
            this.fileUrl = bundle2.getString(FILE_URL);
            if (isPDFFromPath) {
                this.initPdfViewerWithPath(this.fileUrl);
            } else if (this.checkInternetConnection((Context)this)) {
                this.loadFileFromNetwork(this.fileUrl);
            } else {
                Toast.makeText((Context)((Context)this), (CharSequence)"No Internet Connection. Please Check your internet connection.", (int)0).show();
            }
        }
    }

    private final boolean checkInternetConnection(Context context) {
        int result;
        block7: {
            ConnectivityManager cm;
            block6: {
                NetworkCapabilities $this$checkInternetConnection_u24lambda_u2d1_u24lambda_u2d0;
                block9: {
                    block8: {
                        result = 0;
                        cm = (ConnectivityManager)context.getSystemService("connectivity");
                        if (Build.VERSION.SDK_INT < 23) break block6;
                        ConnectivityManager connectivityManager = cm;
                        if (connectivityManager == null) break block7;
                        ConnectivityManager $this$checkInternetConnection_u24lambda_u2d1 = connectivityManager;
                        boolean bl = false;
                        NetworkCapabilities networkCapabilities = cm.getNetworkCapabilities(cm.getActiveNetwork());
                        if (networkCapabilities == null) break block7;
                        $this$checkInternetConnection_u24lambda_u2d1_u24lambda_u2d0 = networkCapabilities;
                        boolean bl2 = false;
                        if (!$this$checkInternetConnection_u24lambda_u2d1_u24lambda_u2d0.hasTransport(1)) break block8;
                        result = 2;
                        break block7;
                    }
                    if (!$this$checkInternetConnection_u24lambda_u2d1_u24lambda_u2d0.hasTransport(0)) break block9;
                    result = 1;
                    break block7;
                }
                if (!$this$checkInternetConnection_u24lambda_u2d1_u24lambda_u2d0.hasTransport(4)) break block7;
                result = 3;
                break block7;
            }
            ConnectivityManager connectivityManager = cm;
            if (connectivityManager == null) break block7;
            ConnectivityManager $this$checkInternetConnection_u24lambda_u2d3 = connectivityManager;
            boolean bl = false;
            NetworkInfo networkInfo = cm.getActiveNetworkInfo();
            if (networkInfo != null) {
                NetworkInfo $this$checkInternetConnection_u24lambda_u2d3_u24lambda_u2d2 = networkInfo;
                boolean bl3 = false;
                switch ($this$checkInternetConnection_u24lambda_u2d3_u24lambda_u2d2.getType()) {
                    case 1: {
                        result = 2;
                        break;
                    }
                    case 0: {
                        result = 1;
                        break;
                    }
                    case 17: {
                        result = 3;
                    }
                }
            }
        }
        return result != 0;
    }

    private final void setUpToolbar(String toolbarTitle) {
        block3: {
            ActionBar actionBar;
            this.setSupportActionBar((Toolbar)this._$_findCachedViewById(R.id.toolbar));
            ActionBar actionBar2 = this.getSupportActionBar();
            if (actionBar2 == null) break block3;
            ActionBar $this$setUpToolbar_u24lambda_u2d4 = actionBar = actionBar2;
            boolean bl = false;
            $this$setUpToolbar_u24lambda_u2d4.setDisplayHomeAsUpEnabled(true);
            $this$setUpToolbar_u24lambda_u2d4.setDisplayShowHomeEnabled(true);
            if ((TextView)this._$_findCachedViewById(R.id.tvAppBarTitle) != null) {
                TextView textView = (TextView)this._$_findCachedViewById(R.id.tvAppBarTitle);
                if (textView != null) {
                    textView.setText((CharSequence)toolbarTitle);
                }
                $this$setUpToolbar_u24lambda_u2d4.setDisplayShowTitleEnabled(false);
            } else {
                $this$setUpToolbar_u24lambda_u2d4.setDisplayShowTitleEnabled(true);
                $this$setUpToolbar_u24lambda_u2d4.setTitle((CharSequence)toolbarTitle);
            }
        }
    }

    public boolean onCreateOptionsMenu(@Nullable Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu, menu2);
        Menu menu3 = menu2;
        this.menuItem = menu3 != null ? menu3.findItem(R.id.download) : null;
        return true;
    }

    public boolean onPrepareOptionsMenu(@Nullable Menu menu2) {
        MenuItem menuItem = this.menuItem;
        if (menuItem != null) {
            menuItem.setVisible(enableDownload);
        }
        return true;
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (item.getItemId() == R.id.download) {
            this.checkPermission(PERMISSION_CODE);
        }
        if (item.getItemId() == 16908332) {
            this.finish();
        }
        return super.onOptionsItemSelected(item);
    }

    private final void loadFileFromNetwork(String fileUrl) {
        this.initPdfViewer(fileUrl, engine);
    }

    private final void initPdfViewer(String fileUrl, PdfEngine engine) {
        if (TextUtils.isEmpty((CharSequence)fileUrl)) {
            this.onPdfError();
        }
        try {
            PdfRendererView pdfRendererView = (PdfRendererView)this._$_findCachedViewById(R.id.pdfView);
            String string = fileUrl;
            Intrinsics.checkNotNull((Object)string);
            pdfRendererView.initWithUrl(string, PdfQuality.NORMAL, engine);
        }
        catch (Exception e) {
            this.onPdfError();
        }
        this.enableDownload();
    }

    private final void initPdfViewerWithPath(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            this.onPdfError();
        }
        try {
            File file;
            if (isFromAssets) {
                Context context = (Context)this;
                String string = filePath;
                Intrinsics.checkNotNull((Object)string);
                file = FileUtils.INSTANCE.fileFromAsset(context, string);
            } else {
                String string = filePath;
                Intrinsics.checkNotNull((Object)string);
                file = new File(string);
            }
            File file2 = file;
            ((PdfRendererView)this._$_findCachedViewById(R.id.pdfView)).initWithFile(file2, PdfQuality.NORMAL);
        }
        catch (Exception e) {
            this.onPdfError();
        }
        this.enableDownload();
    }

    private final void enableDownload() {
        this.checkPermissionOnInit();
        ((PdfRendererView)this._$_findCachedViewById(R.id.pdfView)).setStatusListener(new PdfRendererView.StatusCallBack(this){
            final /* synthetic */ PdfViewerActivity this$0;
            {
                this.this$0 = $receiver;
            }

            public void onDownloadStart() {
                PdfViewerActivity.access$showProgressBar(this.this$0, true);
            }

            public void onDownloadProgress(int progress, long downloadedBytes, @Nullable Long totalBytes) {
            }

            public void onDownloadSuccess() {
                PdfViewerActivity.access$showProgressBar(this.this$0, false);
            }

            public void onError(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                PdfViewerActivity.access$onPdfError(this.this$0);
            }

            public void onPageChanged(int currentPage, int totalPage) {
            }
        });
    }

    private final void checkPermissionOnInit() {
        if (ContextCompat.checkSelfPermission((Context)((Context)this), (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
            this.permissionGranted = true;
        }
    }

    private final void onPdfError() {
        Toast.makeText((Context)((Context)this), (CharSequence)"Pdf has been corrupted", (int)0).show();
        this.showProgressBar(true);
        this.finish();
    }

    private final void showProgressBar(boolean $this$showProgressBar) {
        ((ProgressBar)this._$_findCachedViewById(R.id.progressBar)).setVisibility($this$showProgressBar ? 0 : 8);
    }

    private final void downloadPdf() {
        block6: {
            try {
                Boolean bl = this.permissionGranted;
                Intrinsics.checkNotNull((Object)bl);
                if (bl.booleanValue()) {
                    String directoryName = this.getIntent().getStringExtra(FILE_DIRECTORY);
                    String fileName = this.getIntent().getStringExtra(FILE_TITLE);
                    String fileUrl = this.getIntent().getStringExtra(FILE_URL);
                    String filePath = TextUtils.isEmpty((CharSequence)directoryName) ? "/" + fileName + ".pdf" : "/" + directoryName + "/" + fileName + ".pdf";
                    try {
                        if (isPDFFromPath) {
                            Context context = (Context)this;
                            String string = fileUrl;
                            Intrinsics.checkNotNull((Object)string);
                            String string2 = directoryName;
                            Intrinsics.checkNotNull((Object)string2);
                            FileUtils.INSTANCE.downloadFile(context, string, string2, fileName);
                            break block6;
                        }
                        Uri downloadUrl = Uri.parse((String)fileUrl);
                        DownloadManager downloadManger = (DownloadManager)this.getSystemService("download");
                        DownloadManager.Request request = new DownloadManager.Request(downloadUrl);
                        request.setAllowedNetworkTypes(3);
                        request.setAllowedOverRoaming(true);
                        request.setTitle((CharSequence)fileName);
                        request.setDescription((CharSequence)("Downloading " + fileName));
                        request.setVisibleInDownloadsUi(true);
                        request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, filePath);
                        request.setNotificationVisibility(1);
                        this.registerReceiver(this.onComplete, new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"));
                        DownloadManager downloadManager = downloadManger;
                        Intrinsics.checkNotNull((Object)downloadManager);
                        downloadManager.enqueue(request);
                    }
                    catch (Exception e) {
                        Toast.makeText((Context)((Context)this), (CharSequence)"Unable to download file", (int)0).show();
                    }
                    break block6;
                }
                this.checkPermissionOnInit();
            }
            catch (Exception e) {
                Log.e((String)"Error", (String)e.toString());
            }
        }
    }

    private final void checkPermission(int requestCode) {
        if (ContextCompat.checkSelfPermission((Context)((Context)this), (String)"android.permission.WRITE_EXTERNAL_STORAGE") == -1) {
            String[] stringArray = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
            ActivityCompat.requestPermissions((Activity)((Activity)this), (String[])stringArray, (int)requestCode);
        } else {
            this.permissionGranted = true;
            this.downloadPdf();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == PERMISSION_CODE && !(grantResults.length == 0) && grantResults[0] == 0) {
            this.permissionGranted = true;
            this.downloadPdf();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        ((PdfRendererView)this._$_findCachedViewById(R.id.pdfView)).closePdfRender();
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2 = this.findViewById(id2);
            if (view2 != null) {
                map.put(id2, view2);
                view = view2;
            } else {
                view = null;
            }
        }
        return view;
    }

    public static final /* synthetic */ void access$showProgressBar(PdfViewerActivity $this, boolean $receiver) {
        $this.showProgressBar($receiver);
    }

    public static final /* synthetic */ void access$onPdfError(PdfViewerActivity $this) {
        $this.onPdfError();
    }

    static {
        PERMISSION_CODE = 4040;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010\u00042\b\u0010$\u001a\u0004\u0018\u00010\u00042\b\u0010%\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010&\u001a\u00020\u0010J8\u0010'\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010(\u001a\u0004\u0018\u00010\u00042\b\u0010$\u001a\u0004\u0018\u00010\u00042\b\u0010%\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0012\"\u0004\b\u001c\u0010\u0014R\u001a\u0010\u001d\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0012\"\u0004\b\u001e\u0010\u0014\u00a8\u0006)"}, d2={"Lcom/rajat/pdfviewer/PdfViewerActivity$Companion;", "", "()V", "ENABLE_FILE_DOWNLOAD", "", "FILE_DIRECTORY", "FILE_TITLE", "FILE_URL", "FROM_ASSETS", "PERMISSION_CODE", "", "getPERMISSION_CODE", "()I", "setPERMISSION_CODE", "(I)V", "enableDownload", "", "getEnableDownload", "()Z", "setEnableDownload", "(Z)V", "engine", "Lcom/rajat/pdfviewer/PdfEngine;", "getEngine", "()Lcom/rajat/pdfviewer/PdfEngine;", "setEngine", "(Lcom/rajat/pdfviewer/PdfEngine;)V", "isFromAssets", "setFromAssets", "isPDFFromPath", "setPDFFromPath", "launchPdfFromPath", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "path", "pdfTitle", "directoryName", "fromAssets", "launchPdfFromUrl", "pdfUrl", "pdfViewer_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PdfEngine getEngine() {
            return engine;
        }

        public final void setEngine(@NotNull PdfEngine pdfEngine) {
            Intrinsics.checkNotNullParameter((Object)((Object)pdfEngine), (String)"<set-?>");
            engine = pdfEngine;
        }

        public final boolean getEnableDownload() {
            return enableDownload;
        }

        public final void setEnableDownload(boolean bl) {
            enableDownload = bl;
        }

        public final boolean isPDFFromPath() {
            return isPDFFromPath;
        }

        public final void setPDFFromPath(boolean bl) {
            isPDFFromPath = bl;
        }

        public final boolean isFromAssets() {
            return isFromAssets;
        }

        public final void setFromAssets(boolean bl) {
            isFromAssets = bl;
        }

        public final int getPERMISSION_CODE() {
            return PERMISSION_CODE;
        }

        public final void setPERMISSION_CODE(int n) {
            PERMISSION_CODE = n;
        }

        @NotNull
        public final Intent launchPdfFromUrl(@Nullable Context context, @Nullable String pdfUrl, @Nullable String pdfTitle, @Nullable String directoryName, boolean enableDownload2) {
            Intent intent = new Intent(context, PdfViewerActivity.class);
            intent.putExtra(PdfViewerActivity.FILE_URL, pdfUrl);
            intent.putExtra(PdfViewerActivity.FILE_TITLE, pdfTitle);
            intent.putExtra(PdfViewerActivity.FILE_DIRECTORY, directoryName);
            intent.putExtra(PdfViewerActivity.ENABLE_FILE_DOWNLOAD, enableDownload2);
            this.setPDFFromPath(false);
            return intent;
        }

        public static /* synthetic */ Intent launchPdfFromUrl$default(Companion companion, Context context, String string, String string2, String string3, boolean bl, int n, Object object) {
            if ((n & 0x10) != 0) {
                bl = true;
            }
            return companion.launchPdfFromUrl(context, string, string2, string3, bl);
        }

        @NotNull
        public final Intent launchPdfFromPath(@Nullable Context context, @Nullable String path, @Nullable String pdfTitle, @Nullable String directoryName, boolean enableDownload2, boolean fromAssets) {
            Intent intent = new Intent(context, PdfViewerActivity.class);
            intent.putExtra(PdfViewerActivity.FILE_URL, path);
            intent.putExtra(PdfViewerActivity.FILE_TITLE, pdfTitle);
            intent.putExtra(PdfViewerActivity.FILE_DIRECTORY, directoryName);
            intent.putExtra(PdfViewerActivity.ENABLE_FILE_DOWNLOAD, enableDownload2);
            intent.putExtra(PdfViewerActivity.FROM_ASSETS, fromAssets);
            this.setPDFFromPath(true);
            return intent;
        }

        public static /* synthetic */ Intent launchPdfFromPath$default(Companion companion, Context context, String string, String string2, String string3, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 0x10) != 0) {
                bl = true;
            }
            if ((n & 0x20) != 0) {
                bl2 = false;
            }
            return companion.launchPdfFromPath(context, string, string2, string3, bl, bl2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

